/*
 * Decompiled with CFR 0.152.
 */
package util.tvdataservice;

import devplugin.Channel;
import devplugin.Date;
import devplugin.Program;
import java.util.HashMap;
import tvdataservice.MutableChannelDayProgram;

public class ProgramDispatcher {
    private HashMap<Date, HashMap<Channel, MutableChannelDayProgram>> mDayProgramHash = new HashMap();

    public void dispatch(Program program) {
        Date date = program.getDate();
        Channel channel = program.getChannel();
        MutableChannelDayProgram channelDayProg = this.getChannelDayProgram(date, channel, true);
        channelDayProg.addProgram(program);
    }

    public MutableChannelDayProgram getChannelDayProgram(Date date, Channel channel) {
        MutableChannelDayProgram channelDayProgram = this.getChannelDayProgram(date, channel, false);
        return channelDayProgram;
    }

    private MutableChannelDayProgram getChannelDayProgram(Date date, Channel channel, boolean createIfNotExisting) {
        MutableChannelDayProgram channelDayProg;
        HashMap<Channel, MutableChannelDayProgram> channelDayProgramHash = this.mDayProgramHash.get(date);
        if (channelDayProgramHash == null) {
            if (createIfNotExisting) {
                channelDayProgramHash = new HashMap();
                this.mDayProgramHash.put(date, channelDayProgramHash);
            } else {
                return null;
            }
        }
        if ((channelDayProg = channelDayProgramHash.get(channel)) == null) {
            if (createIfNotExisting) {
                channelDayProg = new MutableChannelDayProgram(date, channel);
                channelDayProgramHash.put(channel, channelDayProg);
            } else {
                return null;
            }
        }
        return channelDayProg;
    }
}

