/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import tvbrowser.core.Settings;
import util.settings.Property;
import util.settings.PropertyManager;

public class HiddenMessagesProperty
extends Property {
    private static final PropertyManager DUMMY = new PropertyManager();
    private boolean mDefaultValue;

    public HiddenMessagesProperty(String messageId, boolean isHiddenDefault) {
        super(DUMMY, messageId);
        this.mDefaultValue = isHiddenDefault;
    }

    public boolean getDefault() {
        return this.mDefaultValue;
    }

    public boolean isHidden() {
        return Settings.Other.MESSAGE_BOXES_HIDDEN.containsItem(this.getKey());
    }

    public void setHidden(boolean hidden) {
        if (hidden && !this.isHidden()) {
            Settings.Other.MESSAGE_BOXES_HIDDEN.addItem(this.getKey());
        } else if (!hidden && this.isHidden()) {
            Settings.Other.MESSAGE_BOXES_HIDDEN.removeItem(this.getKey());
        }
    }

    public String getMessageId() {
        return this.getKey();
    }

    @Override
    protected void clearCache() {
    }
}

