/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import util.io.IOUtilities;
import util.settings.Property;
import util.settings.PropertyManager;

public class EncodedStringProperty
extends Property {
    private long mSeed;
    private String mDefaultValue;
    private String mCachedValue;

    public EncodedStringProperty(PropertyManager manager, String key, String defaultValue, long seed) {
        super(manager, key);
        this.mDefaultValue = defaultValue;
        this.mCachedValue = null;
        this.mSeed = seed;
    }

    public String getDefault() {
        return this.mDefaultValue;
    }

    public String getString() {
        if (this.mCachedValue == null) {
            String encodedString = this.getProperty();
            this.mCachedValue = encodedString == null ? this.mDefaultValue : IOUtilities.xorDecode(encodedString, this.mSeed);
        }
        return this.mCachedValue;
    }

    public void setString(String value) {
        if (value == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        if (value.equals(this.mDefaultValue)) {
            this.setProperty(null);
        } else {
            this.setProperty(IOUtilities.xorEncode(value, this.mSeed));
        }
        this.mCachedValue = value;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }
}

