/*
 * Decompiled with CFR 0.152.
 */
package util.settings;

import org.apache.commons.lang3.StringUtils;
import util.settings.ContextMenuMouseActionSetting;
import util.settings.Property;
import util.settings.PropertyManager;

public class ContextMenuMouseActionArrayProperty
extends Property {
    private ContextMenuMouseActionSetting[] mDefaultValue;
    private ContextMenuMouseActionSetting[] mCachedValue;

    public ContextMenuMouseActionArrayProperty(PropertyManager manager, String key, ContextMenuMouseActionSetting[] defaultSetting) {
        super(manager, key);
        this.mDefaultValue = defaultSetting;
        this.mCachedValue = null;
    }

    public ContextMenuMouseActionSetting[] getDefault() {
        return this.mDefaultValue;
    }

    public ContextMenuMouseActionSetting[] getContextMenuMouseActionArray() {
        if (this.mCachedValue == null) {
            String asString = this.getProperty();
            if (asString != null && asString.length() > 0) {
                String[] splits = asString.split(",");
                try {
                    ContextMenuMouseActionSetting[] menuSettingsArr = new ContextMenuMouseActionSetting[splits.length];
                    for (int i = 0; i < menuSettingsArr.length; ++i) {
                        menuSettingsArr[i] = new ContextMenuMouseActionSetting(splits[i]);
                    }
                    this.mCachedValue = menuSettingsArr;
                }
                catch (NumberFormatException exc) {
                    exc.printStackTrace();
                }
            } else if (asString != null && StringUtils.isEmpty((CharSequence)asString)) {
                this.mCachedValue = new ContextMenuMouseActionSetting[0];
            }
            if (this.mCachedValue == null) {
                this.mCachedValue = this.mDefaultValue;
            }
        }
        return this.mCachedValue;
    }

    public void setContextMenuMouseActionArray(ContextMenuMouseActionSetting[] array) {
        if (array == null) {
            throw new IllegalArgumentException("You can't set a null value");
        }
        boolean equalsDefault = false;
        if (this.mDefaultValue != null && array.length == this.mDefaultValue.length) {
            equalsDefault = true;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == this.mDefaultValue[i]) continue;
                equalsDefault = false;
                break;
            }
        }
        if (equalsDefault) {
            this.setProperty(null);
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(array[i].toString());
            }
            this.setProperty(buffer.toString());
        }
        this.mCachedValue = array;
    }

    @Override
    protected void clearCache() {
        this.mCachedValue = null;
    }
}

