/*
 * Decompiled with CFR 0.152.
 */
package util.program;

import devplugin.Program;
import devplugin.ProgramFieldType;
import util.io.IOUtilities;

public class CompoundedProgramFieldType {
    public static final CompoundedProgramFieldType EPISODE_COMPOSITION = new CompoundedProgramFieldType(-1, new ProgramFieldType[]{ProgramFieldType.EPISODE_NUMBER_TYPE, ProgramFieldType.EPISODE_TOTAL_NUMBER_TYPE, ProgramFieldType.SEASON_NUMBER_TYPE, ProgramFieldType.EPISODE_TYPE}, ProgramFieldType.EPISODE_TYPE.getLocalizedName(), new String[]{"/", " - ", ", "});
    public static final CompoundedProgramFieldType COMPOSITION_ORIGIN_YEAR = new CompoundedProgramFieldType(-2, null, ProgramFieldType.ORIGIN_TYPE.getLocalizedName() + "/" + ProgramFieldType.PRODUCTION_YEAR_TYPE.getLocalizedName(), new Formatter(){

        @Override
        public String getFormattedValueForProgram(ProgramFieldType[] fieldTypes, Program prog) {
            String origin = prog.getTextField(ProgramFieldType.ORIGIN_TYPE);
            int year = prog.getIntField(ProgramFieldType.PRODUCTION_YEAR_TYPE);
            int yearFirst = prog.getIntField(ProgramFieldType.FIRST_PRODUCTION_YEAR);
            int yearLast = prog.getIntField(ProgramFieldType.LAST_PRODUCTION_YEAR_TYPE);
            if (yearLast < year) {
                yearLast = -1;
            }
            if (year != -1 && (yearLast != -1 && yearFirst == -1 || yearLast == -1 && yearFirst < year && yearFirst != -1)) {
                yearFirst = year;
            }
            StringBuilder result = new StringBuilder();
            int originIndex = 0;
            if (origin != null) {
                result.append(origin);
                originIndex = result.length();
            }
            if (year != -1) {
                if (result.length() >= 0) {
                    result.append(" ");
                }
                result.append(year);
            }
            if (yearLast != -1 && yearLast != year) {
                if (yearFirst != -1) {
                    if (result.length() >= 0) {
                        if (yearFirst == year) {
                            result.append(" \u2013 ");
                        } else {
                            result.append(" (");
                        }
                    }
                    if (yearFirst == year) {
                        result.append(yearLast);
                    } else {
                        result.append(yearFirst).append(" \u2013 ").append(yearLast).append(")");
                    }
                } else {
                    result.append(yearLast);
                }
            } else if (yearFirst != -1 && yearFirst != year) {
                if (yearFirst < year) {
                    result.insert(originIndex, " \u2013 ");
                    result.insert(originIndex, yearFirst);
                    if (originIndex != 0) {
                        result.insert(originIndex, " ");
                    }
                } else if (year == -1) {
                    if (originIndex > 0) {
                        result.append(" ");
                    }
                    result.append(yearFirst);
                }
            }
            if (!result.toString().trim().isEmpty()) {
                return result.toString();
            }
            return null;
        }
    });
    private int mId;
    private ProgramFieldType[] mFieldTypes;
    private String mName;
    private String mFormatString;
    private Formatter mFormatter;
    private String[] mPartSeparators;

    private CompoundedProgramFieldType(int id, ProgramFieldType[] fieldTypes, String name, String formatString) {
        this.mId = id;
        this.mFieldTypes = fieldTypes;
        this.mName = name;
        this.mFormatString = formatString;
        this.mPartSeparators = null;
    }

    private CompoundedProgramFieldType(int id, ProgramFieldType[] fieldTypes, String name, String[] partSeparators) {
        this.mId = id;
        this.mFieldTypes = fieldTypes;
        this.mName = name;
        this.mFormatString = null;
        this.mPartSeparators = partSeparators;
    }

    private CompoundedProgramFieldType(int id, ProgramFieldType[] fieldTypes, String name, Formatter formatter) {
        this.mId = id;
        this.mFieldTypes = fieldTypes;
        this.mName = name;
        this.mFormatString = null;
        this.mPartSeparators = null;
        this.mFormatter = formatter;
    }

    public String getFormattedValueForProgram(Program prog) {
        if (this.mFormatString != null) {
            String value = this.mFormatString;
            boolean found = false;
            for (int i = 0; i < this.mFieldTypes.length; ++i) {
                String formattedValue = "";
                if (this.mFieldTypes[i].getFormat() == 3) {
                    formattedValue = prog.getTextField(this.mFieldTypes[i]);
                } else if (this.mFieldTypes[i].getFormat() == 4) {
                    formattedValue = this.mFieldTypes[i].equals(ProgramFieldType.EPISODE_NUMBER_TYPE) && prog.hasFieldValue(ProgramFieldType.EPISODE_NUMBER_TYPE) ? IOUtilities.decodeSingleFieldValueToMultipleEpisodeString(prog.getIntField(this.mFieldTypes[i])) : prog.getIntFieldAsString(this.mFieldTypes[i]);
                } else if (this.mFieldTypes[i].getFormat() == 5) {
                    formattedValue = prog.getTimeFieldAsString(this.mFieldTypes[i]);
                }
                if (formattedValue == null) {
                    formattedValue = "";
                } else {
                    found = true;
                }
                value = value.replace("{" + i + "}", formattedValue);
            }
            return found ? value : null;
        }
        if (this.mPartSeparators != null) {
            StringBuilder value = new StringBuilder();
            String prevValue = "";
            String currentValue = "";
            for (int i = 0; i < this.mFieldTypes.length; ++i) {
                if (this.mFieldTypes[i].getFormat() == 3) {
                    currentValue = prog.getTextField(this.mFieldTypes[i]);
                } else if (this.mFieldTypes[i].getFormat() == 4) {
                    currentValue = this.mFieldTypes[i].equals(ProgramFieldType.EPISODE_NUMBER_TYPE) && prog.hasFieldValue(ProgramFieldType.EPISODE_NUMBER_TYPE) ? IOUtilities.decodeSingleFieldValueToMultipleEpisodeString(prog.getIntField(this.mFieldTypes[i])) : prog.getIntFieldAsString(this.mFieldTypes[i]);
                } else if (this.mFieldTypes[i].getFormat() == 5) {
                    currentValue = prog.getTimeFieldAsString(this.mFieldTypes[i]);
                }
                if ((prevValue != null || value.length() > 0) && currentValue != null) {
                    if (i == 0) {
                        value.append(currentValue);
                    } else {
                        value.append(this.mPartSeparators[i - 1]).append(currentValue);
                    }
                } else if (currentValue != null) {
                    value.append(currentValue);
                }
                prevValue = currentValue;
            }
            if (value.toString().trim().length() > 0) {
                return value.toString();
            }
        } else if (this.mFormatter != null) {
            return this.mFormatter.getFormattedValueForProgram(this.mFieldTypes, prog);
        }
        return null;
    }

    public String getName() {
        if (this.mName != null) {
            return this.mName;
        }
        return this.mFieldTypes[0].getLocalizedName();
    }

    public String toString() {
        return this.getName();
    }

    public int getId() {
        return this.mId;
    }

    public static CompoundedProgramFieldType getCompoundedProgramFieldTypeForId(int id) {
        if (id == EPISODE_COMPOSITION.getId()) {
            return EPISODE_COMPOSITION;
        }
        if (id == COMPOSITION_ORIGIN_YEAR.getId()) {
            return COMPOSITION_ORIGIN_YEAR;
        }
        return null;
    }

    private static interface Formatter {
        public String getFormattedValueForProgram(ProgramFieldType[] var1, Program var2);
    }
}

