/*
 * Decompiled with CFR 0.152.
 */
package util.exc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import util.exc.ErrorHandler;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.ui.ImageUtilities;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

class ErrorWindow {
    private JDialog mDialog;
    private JFrame mFrame;
    private JPanel mMainPn;
    private JPanel mMessagePn;
    private JTextArea mErrorMessageTA;
    private JPanel mDetailPn;
    private JButton mOkBt;
    private JButton mYesBt;
    private JButton mNoBt;
    private JButton mDetailBt;
    private boolean mDetailsVisible;
    private Throwable mThrowable;
    private int mReturn = 3;

    public ErrorWindow(Component parent, String errorMsg, Throwable thr) {
        this(parent, errorMsg, thr, 0);
    }

    public ErrorWindow(Component parent, String errorMsg, Throwable thr, int messageType) {
        boolean useFrame;
        this.mThrowable = thr;
        Frame root = JOptionPane.getFrameForComponent(parent);
        boolean bl = useFrame = root == null || !root.isVisible();
        if (useFrame) {
            this.mFrame = new JFrame();
            Image iconImage = ImageUtilities.createImage("imgs/tvbrowser16.png");
            this.mFrame.setIconImage(iconImage);
        } else {
            this.mDialog = UiUtilities.createDialog(ErrorHandler.mParent, true);
        }
        if (this.mDialog != null) {
            this.mDialog.setTitle(Localizer.getLocalization("i18n_error"));
        } else {
            this.mFrame.setTitle(Localizer.getLocalization("i18n_error"));
        }
        this.mMainPn = new JPanel(new BorderLayout());
        this.mMainPn.setBorder(UiUtilities.DIALOG_BORDER);
        if (this.mDialog != null) {
            this.mDialog.setContentPane(this.mMainPn);
        } else {
            this.mFrame.setContentPane(this.mMainPn);
        }
        this.mMessagePn = new JPanel(new BorderLayout(10, 10));
        this.mMainPn.add((Component)this.mMessagePn, "North");
        JLabel errorLb = new JLabel(ErrorHandler.ERROR_ICON);
        this.mMessagePn.add((Component)errorLb, "West");
        this.mErrorMessageTA = UiUtilities.createHelpTextArea(errorMsg);
        this.mMessagePn.add(this.mErrorMessageTA);
        JPanel buttonPn = new JPanel(new FlowLayout(2));
        this.mMessagePn.add((Component)buttonPn, "South");
        if (messageType == 1) {
            this.mYesBt = new JButton(ErrorHandler.LOCALIZER.msg("yes", "Yes"));
            this.mYesBt.addActionListener(evt -> {
                this.mReturn = 2;
                this.getWindow().dispose();
            });
            buttonPn.add(this.mYesBt);
            this.mNoBt = new JButton(ErrorHandler.LOCALIZER.msg("no", "No"));
            this.mNoBt.addActionListener(evt -> {
                this.mReturn = 3;
                this.getWindow().dispose();
            });
            buttonPn.add(this.mNoBt);
        } else {
            this.mOkBt = new JButton(Localizer.getLocalization("i18n_ok"));
            this.mOkBt.addActionListener(evt -> {
                this.mReturn = 1;
                this.getWindow().dispose();
            });
            buttonPn.add(this.mOkBt);
        }
        if (this.mDialog != null) {
            this.mDialog.getRootPane().setDefaultButton(this.mOkBt);
        } else {
            this.mFrame.getRootPane().setDefaultButton(this.mOkBt);
        }
        String msg = ErrorHandler.LOCALIZER.msg("details", "Details");
        this.mDetailBt = new JButton(msg);
        this.mDetailBt.addActionListener(e -> this.setDetailsVisible(!this.mDetailsVisible));
        buttonPn.add(this.mDetailBt);
        Dimension size = buttonPn.getPreferredSize();
        size.width = 350;
        buttonPn.setPreferredSize(size);
        this.mDetailsVisible = true;
        this.setDetailsVisible(false);
        this.getWindow().pack();
    }

    private Window getWindow() {
        if (this.mDialog != null) {
            return this.mDialog;
        }
        return this.mFrame;
    }

    public void centerAndShow() {
        UiUtilities.centerAndShow(this.getWindow());
    }

    public int getReturnValue() {
        return this.mReturn;
    }

    private JPanel createDetailPanel() {
        JPanel detailPn = new JPanel(new BorderLayout(0, 10));
        detailPn.add((Component)new JSeparator(), "North");
        detailPn.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        if (this.mThrowable.getCause() == null) {
            JComponent detailComp = this.createDetailComponent(this.mThrowable);
            detailPn.add((Component)detailComp, "Center");
        } else {
            JTabbedPane tabbedPane = new JTabbedPane();
            detailPn.add((Component)tabbedPane, "Center");
            Throwable thr = this.mThrowable;
            int i = 0;
            while (thr != null) {
                JComponent detailComp = this.createDetailComponent(thr);
                tabbedPane.addTab(Integer.toString(i + 1), detailComp);
                thr = thr.getCause();
                ++i;
            }
        }
        String msg = ErrorHandler.LOCALIZER.msg("copyToClipboard", "Copy to clipboard");
        JButton copyToClipBoardBt = new JButton(msg);
        copyToClipBoardBt.addActionListener(e -> this.copyDetailsToClipBoard());
        detailPn.add((Component)copyToClipBoardBt, "South");
        return detailPn;
    }

    private void copyDetailsToClipBoard() {
        StringBuilder buffer = new StringBuilder(this.mErrorMessageTA.getText());
        buffer.append("\n\n----- Start of stacktrace -----\n");
        for (Throwable thr = this.mThrowable; thr != null; thr = thr.getCause()) {
            if (thr != this.mThrowable) {
                buffer.append("\n\nCaused by:\n");
            }
            buffer.append(this.getStackTrace(thr));
        }
        while (buffer.charAt(buffer.length() - 1) == '\n') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("\n----- End of stacktrace -----\n");
        StringSelection content = new StringSelection(buffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(content, null);
    }

    private JComponent createDetailComponent(Throwable thr) {
        String detailText = this.getStackTrace(thr);
        JTextArea textArea = new JTextArea(detailText);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        return scrollPane;
    }

    private String getStackTrace(Throwable thr) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            thr.printStackTrace(printer);
            printer.close();
            writer.close();
            IOUtilities.replace(writer.getBuffer(), "\t", "  ");
            IOUtilities.replace(writer.getBuffer(), "\r\n", "\n");
            return writer.toString();
        }
        catch (Exception exc) {
            return "";
        }
    }

    private void setDetailsVisible(boolean detailsVisible) {
        if (detailsVisible != this.mDetailsVisible) {
            this.mDetailsVisible = detailsVisible;
            if (this.mDetailsVisible) {
                if (this.mDetailPn == null) {
                    this.mDetailPn = this.createDetailPanel();
                    this.mMainPn.add((Component)this.mDetailPn, "Center");
                }
                this.mDetailPn.setVisible(true);
                this.mDetailBt.setIcon(TVBrowserIcons.up(16));
            } else {
                if (this.mDetailPn != null) {
                    this.mDetailPn.setVisible(false);
                }
                this.mDetailBt.setIcon(TVBrowserIcons.down(16));
            }
            this.getWindow().pack();
        }
    }
}

