/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import devplugin.Channel;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import tvbrowser.TVBrowser;
import tvbrowser.ui.settings.channel.ChannelUtil;
import util.i18n.Localizer;

public class ChannelJList
extends JList<Object> {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelJList.class);

    public ChannelJList() {
    }

    public ChannelJList(DefaultListModel<Object> model) {
        super(model);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int index = this.locationToIndex(evt.getPoint());
        if (index < 0) {
            return null;
        }
        Object item = this.getModel().getElementAt(index);
        if (item instanceof Channel) {
            Channel channel = (Channel)item;
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append("<b>").append(Localizer.getLocalization("i18n_channel")).append(" :</b> ").append(channel.getName()).append("<br>");
            if (!TVBrowser.isStable()) {
                buf.append("<b>ID (dev. only) :</b> ").append(channel.getUniqueId()).append("<br>");
            }
            buf.append("<b>").append(mLocalizer.msg("countries", "Countries")).append(" :</b> ");
            String[] countries = channel.getAllCountries();
            for (int i = 0; i < countries.length; ++i) {
                Locale loc = new Locale(Locale.getDefault().getLanguage(), countries[i]);
                buf.append(loc.getDisplayCountry());
                if (i >= countries.length - 1) continue;
                buf.append(", ");
            }
            buf.append("<br>");
            buf.append("<b>").append(mLocalizer.msg("timezone", "Timezone")).append(" :</b> ").append(channel.getTimeZone().getDisplayName()).append("<br>");
            buf.append("<b>").append(mLocalizer.msg("category", "Category")).append(" :</b> ").append(ChannelUtil.getNameForCategories(channel.getCategories())).append("<br>");
            if (channel.getSortNumber().length() > 0 || channel.getUserChannelName() != null || channel.getUserIconFileName() != null || channel.getUserWebPage() != null || channel.isTimeLimited() || channel.getTimeZoneCorrectionMinutes() != 0) {
                buf.append("<b>").append(mLocalizer.msg("userSettings", "User defined settings")).append(" :</b> ");
            }
            if (channel.getSortNumber().length() > 0) {
                buf.append(mLocalizer.msg("sortNumber", "Sort number"));
            }
            if (channel.getUserChannelName() != null) {
                buf.append(mLocalizer.msg("name", "Name"));
            }
            if (channel.getUserIconFileName() != null) {
                if (channel.getUserChannelName() != null) {
                    buf.append(", ");
                }
                buf.append(mLocalizer.msg("logo", "Logo"));
            }
            if (channel.getUserWebPage() != null) {
                if (channel.getUserChannelName() != null || channel.getUserIconFileName() != null) {
                    buf.append(", ");
                }
                buf.append(mLocalizer.msg("website", "Website"));
            }
            if (channel.getTimeZoneCorrectionMinutes() != 0) {
                if (channel.getUserWebPage() != null || channel.getUserChannelName() != null || channel.getUserIconFileName() != null) {
                    buf.append(", ");
                }
                buf.append(mLocalizer.msg("timeCorrection", "Timezone offset"));
            }
            if (channel.isTimeLimited()) {
                if (channel.getTimeZoneCorrectionMinutes() != 0 && channel.getUserWebPage() != null || channel.getUserChannelName() != null || channel.getUserIconFileName() != null) {
                    buf.append(", ");
                }
                buf.append(mLocalizer.msg("timeLimitation", "Time limitation"));
            }
            if (channel.getUserChannelName() != null || channel.getUserIconFileName() != null || channel.getUserWebPage() != null || channel.isTimeLimited() || channel.getTimeZoneCorrectionMinutes() != 0) {
                buf.append("<br>");
            }
            buf.append("<br>");
            buf.append(mLocalizer.msg("provided", "provided by")).append("<br><center>").append(ChannelUtil.getProviderName(channel)).append("</center>");
            buf.append("</html>");
            return buf.toString();
        }
        return null;
    }
}

