/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.HyperlinkEvent;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import util.i18n.Localizer;
import util.ui.DefaultMarkingPrioritySelectionPanel;
import util.ui.EnhancedPanelBuilder;
import util.ui.MarkPriorityComboBoxRenderer;
import util.ui.UiUtilities;

public class TrayImportantSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = TrayBaseSettingsTab.LOCALIZER;
    private static final int mMaxSizeTray = 30;
    private static final int mMaxSizeSubmenu = 40;
    private JCheckBox mIsEnabled;
    private JCheckBox mShowDate;
    private JCheckBox mShowTime;
    private JCheckBox mShowToolTip;
    private JRadioButton mShowInSubMenu;
    private JRadioButton mShowInTray;
    private JSpinner mSize;
    private JLabel mIconSeparator;
    private JLabel mSeparator1;
    private JLabel mSeparator2;
    private JLabel mSizeLabel;
    private JLabel mSizeInfo;
    private JEditorPane mHelpLabel;
    private JRadioButton mShowIconAndName;
    private JRadioButton mShowName;
    private JRadioButton mShowIcon;
    private JCheckBox mShowSortNumber;
    private JComboBox<Object> mPriority;
    private JLabel mPriorityText;
    private static boolean mTrayIsEnabled = Settings.Tray.ENABLED.getBoolean();
    private static TrayImportantSettingsTab mInstance;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        EnhancedPanelBuilder builder = new EnhancedPanelBuilder(new FormLayout("5dlu,12dlu,pref,5dlu,pref,5dlu,pref:grow,5dlu"));
        builder.border(Borders.DIALOG);
        this.mIsEnabled = new JCheckBox(LOCALIZER.msg("importantEnabled", "Show important programs"), Settings.Tray.Important.ENABLED.getBoolean());
        this.mIsEnabled.setToolTipText(LOCALIZER.msg("importantToolTip", "Important programs are all marked programs."));
        ButtonGroup bg = new ButtonGroup();
        this.mShowInSubMenu = new JRadioButton(LOCALIZER.msg("inSubMenu", "in a sub menu"), Settings.Tray.Important.IN_SUB_MENU.getBoolean());
        this.mShowInTray = new JRadioButton(LOCALIZER.msg("inTray", "in the tray menu"), !this.mShowInSubMenu.isSelected());
        bg.add(this.mShowInSubMenu);
        bg.add(this.mShowInTray);
        int maxSizeValue = Settings.Tray.Important.IN_SUB_MENU.getBoolean() ? 40 : 30;
        this.mSize = new JSpinner(new SpinnerNumberModel(Settings.Tray.Important.SIZE.getInt(), 1, maxSizeValue, 1));
        this.mShowIconAndName = new JRadioButton(LOCALIZER.msg("showIconName", "Show channel icon and channel name"), Settings.Tray.Important.CONTAINS_NAME.getBoolean() && Settings.Tray.Important.CONTAINS_ICON.getBoolean());
        this.mShowName = new JRadioButton(LOCALIZER.msg("showName", "Show channel name"), Settings.Tray.Important.CONTAINS_NAME.getBoolean() && !Settings.Tray.Important.CONTAINS_ICON.getBoolean());
        this.mShowIcon = new JRadioButton(LOCALIZER.msg("showIcon", "Show channel icon"), !Settings.Tray.Important.CONTAINS_NAME.getBoolean() && Settings.Tray.Important.CONTAINS_ICON.getBoolean());
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.mShowIconAndName);
        bg1.add(this.mShowIcon);
        bg1.add(this.mShowName);
        this.mShowSortNumber = new JCheckBox(LOCALIZER.msg("showChannelNumber", "Show sort number"), Settings.Tray.Important.SORT_NUMBER_SHOW.getBoolean());
        this.mShowDate = new JCheckBox(LOCALIZER.msg("showDate", "Show date"), Settings.Tray.Important.CONTAINS_DATE.getBoolean());
        this.mShowTime = new JCheckBox(LOCALIZER.msg("showTime", "Show start time"), Settings.Tray.Important.CONTAINS_TIME.getBoolean());
        this.mShowToolTip = new JCheckBox(LOCALIZER.msg("showToolTip", "Show additional information of the program in a tool tip"), Settings.Tray.Important.CONTAINS_TOOL_TIP.getBoolean());
        this.mShowToolTip.setToolTipText(LOCALIZER.msg("toolTipTip", "Tool tips are small helper to something, like this one."));
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SettingsDialog.getInstance().showSettingsTab("#tray");
            }
        });
        EnhancedPanelBuilder priority = new EnhancedPanelBuilder(new FormLayout("default,5dlu,default", "1dlu,default"));
        String[] colors = DefaultMarkingPrioritySelectionPanel.getMarkingColorNames(false);
        this.mPriorityText = new JLabel(LOCALIZER.msg("importantMarkPriority", "Mark priority higher or the same like:"));
        this.mPriority = new JComboBox<String>(colors);
        this.mPriority.setSelectedIndex(Settings.Tray.Important.PRIORITY.getInt());
        this.mPriority.setRenderer(new MarkPriorityComboBoxRenderer(this.mPriority.getRenderer()));
        priority.add(this.mPriorityText, 1);
        priority.add(this.mPriority, 3);
        JPanel c = (JPanel)builder.addSeparatorRowFull(false, LOCALIZER.msg("important", "Important programs"));
        builder.addRow(this.mIsEnabled, 2, 6);
        builder.addRow(false, (Component)this.mShowInTray, 3, 5);
        builder.addRow(false, (Component)this.mShowInSubMenu, 3, 5);
        this.mSizeLabel = builder.addLabelRow(false, LOCALIZER.msg("importantSize", "Number of shown programs:"), 3);
        builder.add(this.mSize, 5);
        this.mSizeInfo = builder.labelAdd(LOCALIZER.msg("sizeInfo", "(maximum: {0})", maxSizeValue), 7);
        builder.addRow(false, (Component)priority.getPanel(), 3, 5);
        JPanel c1 = (JPanel)builder.addParagraph(LOCALIZER.msg("iconNameSeparator", "Channel icons/channel name"));
        builder.addRow(this.mShowIconAndName, 2, 6);
        builder.addRow(false, (Component)this.mShowIcon, 2, 6);
        builder.addRow(false, (Component)this.mShowName, 2, 6);
        builder.addRow(this.mShowSortNumber, 2, 6);
        JPanel c2 = (JPanel)builder.addParagraph(LOCALIZER.msg("settings", "Settings"));
        builder.addRow(this.mShowDate, 2, 6);
        builder.addRow(false, (Component)this.mShowTime, 2, 6);
        builder.addRow(false, (Component)this.mShowToolTip, 2, 6);
        builder.addRowFull("fill:pref:grow", (Component)this.mHelpLabel);
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.mIconSeparator = (JLabel)c1.getComponent(0);
        this.mSeparator2 = (JLabel)c2.getComponent(0);
        this.setEnabled(true);
        this.mShowInSubMenu.addActionListener(e -> {
            this.mSize.setModel(new SpinnerNumberModel((Integer)this.mSize.getValue(), 1, 40, 1));
            this.mSizeInfo.setText(LOCALIZER.msg("sizeInfo", "(maximum: {0})", 40));
        });
        this.mShowInTray.addActionListener(e -> {
            int value = (Integer)this.mSize.getValue();
            this.mSize.setModel(new SpinnerNumberModel(value > 30 ? 30 : value, 1, 30, 1));
            this.mSizeInfo.setText(LOCALIZER.msg("sizeInfo", "(maximum: {0})", 30));
        });
        this.mIsEnabled.addActionListener(e -> this.setEnabled(false));
        return builder.getPanel();
    }

    private void setEnabled(boolean trayStateChange) {
        this.mHelpLabel.setVisible(!mTrayIsEnabled);
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
            this.mIsEnabled.setEnabled(mTrayIsEnabled);
        }
        this.mIconSeparator.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSeparator2.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInSubMenu.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInTray.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIconAndName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIcon.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowDate.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowTime.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowToolTip.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSizeLabel.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSize.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mSizeInfo.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mPriority.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mPriorityText.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
    }

    @Override
    public void saveSettings() {
        if (this.mIsEnabled != null) {
            Settings.Tray.Important.ENABLED.setBoolean(this.mIsEnabled.isSelected());
        }
        if (this.mShowInSubMenu != null) {
            Settings.Tray.Important.IN_SUB_MENU.setBoolean(this.mShowInSubMenu.isSelected());
        }
        if (this.mSize != null) {
            Settings.Tray.Important.SIZE.setInt((Integer)this.mSize.getValue());
        }
        if (this.mShowIconAndName != null && this.mShowName != null && this.mShowIcon != null) {
            Settings.Tray.Important.CONTAINS_NAME.setBoolean(this.mShowIconAndName.isSelected() || this.mShowName.isSelected());
            Settings.Tray.Important.CONTAINS_ICON.setBoolean(this.mShowIconAndName.isSelected() || this.mShowIcon.isSelected());
        }
        if (this.mShowDate != null) {
            Settings.Tray.Important.CONTAINS_DATE.setBoolean(this.mShowDate.isSelected());
        }
        if (this.mShowTime != null) {
            Settings.Tray.Important.CONTAINS_TIME.setBoolean(this.mShowTime.isSelected());
        }
        if (this.mShowToolTip != null) {
            Settings.Tray.Important.CONTAINS_TOOL_TIP.setBoolean(this.mShowToolTip.isSelected());
        }
        if (this.mPriority != null) {
            Settings.Tray.Important.PRIORITY.setInt(this.mPriority.getSelectedIndex());
        }
        if (this.mShowSortNumber != null) {
            Settings.Tray.Important.SORT_NUMBER_SHOW.setBoolean(this.mShowSortNumber.isSelected());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("important", "Important programs");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }
}

