/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.InfoIf;
import devplugin.PluginInfo;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.PluginAndDataServiceComparator;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.ChannelsSettingsTab;
import tvbrowser.ui.settings.PluginInfoDialog;
import tvbrowser.ui.settings.PluginTableCellRenderer;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.update.SoftwareUpdateDlg;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.ImageIconEnhanced;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class PluginSettingsTab
implements SettingsTab,
TableModelListener {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(PluginSettingsTab.class);
    private static final Logger LOG = Logger.getLogger(PluginSettingsTab.class.getName());
    private JTable mTable;
    private JButton mInfo;
    private JButton mRemove;
    private DefaultTableModel mTableModel;
    private SettingsDialog mSettingsDialog;
    private JCheckBox mAutoUpdates;
    private JButton mConfigure;
    private JComboBox<SoftwareUpdateDlg.FilterItem> mFilterBox;
    private JTextField mFilterName;

    public PluginSettingsTab(SettingsDialog settingsDialog) {
        this.mSettingsDialog = settingsDialog;
    }

    @Override
    public JPanel createSettingsPanel() {
        JPanel contentPanel = new JPanel((LayoutManager)new FormLayout("default:grow, default", "default, 2dlu, default, 3dlu, fill:100dlu:grow, 3dlu, default"));
        contentPanel.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        JButton update = new JButton(LOCALIZER.msg("updateInstallPlugin", "Update/Install Plugins"), IconLoader.getInstance().getIconFromTheme("actions", "web-search", 16));
        update.addActionListener(e -> MainFrame.getInstance().showUpdatePluginsDlg(false));
        contentPanel.add((Component)update, cc.xy(2, 1));
        this.mAutoUpdates = new JCheckBox(LOCALIZER.msg("autoUpdates", "Find plugin updates automatically"), Settings.Plugins.AUTO_UPDATE_ENABLED.getBoolean());
        this.mAutoUpdates.addItemListener(e -> Settings.Plugins.AUTO_UPDATE_ENABLED.setBoolean(e.getStateChange() == 1));
        contentPanel.add((Component)this.mAutoUpdates, cc.xy(1, 1));
        JPanel categorySelection = new JPanel((LayoutManager)new FormLayout("default,3dlu,default:grow", "default,2dlu,default"));
        JLabel filterLabel = new JLabel(SoftwareUpdateDlg.LOCALIZER.msg("filterLabel", "Show only Plugins with the following category:"));
        this.mFilterBox = new JComboBox();
        this.mFilterBox.addItemListener(e -> this.populatePluginList());
        JLabel nameFilterLabel = new JLabel(SoftwareUpdateDlg.LOCALIZER.msg("nameFilterLabel", "Show only Plugins with the following text:"));
        this.mFilterName = new JTextField();
        this.mFilterName.addCaretListener(e -> this.populatePluginList());
        categorySelection.add((Component)filterLabel, cc.xy(1, 1));
        categorySelection.add(this.mFilterBox, cc.xy(3, 1));
        categorySelection.add((Component)nameFilterLabel, cc.xy(1, 3));
        categorySelection.add((Component)this.mFilterName, cc.xy(3, 3));
        contentPanel.add((Component)categorySelection, cc.xyw(1, 3, 2));
        this.mTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                Object value;
                if (column == 0 && (value = this.getValueAt(row, 1)) instanceof PluginProxy) {
                    return !Settings.Plugins.BLOCKED_ARRAY.isBlocked((PluginProxy)value);
                }
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                return super.getColumnClass(columnIndex);
            }
        };
        this.mTableModel.setColumnCount(2);
        this.mTableModel.setColumnIdentifiers(new String[]{LOCALIZER.msg("active", "Active"), LOCALIZER.msg("plugin", "Plugin")});
        this.mTable = new JTable(this.mTableModel);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(PluginTableCellRenderer.getInstance());
        this.mTable.getColumnModel().getColumn(1).setCellRenderer(PluginTableCellRenderer.getInstance());
        this.mTable.setSelectionMode(0);
        this.mTable.setRowHeight(40);
        this.mTable.setShowVerticalLines(false);
        this.mTable.setShowHorizontalLines(false);
        this.mTable.getModel().addTableModelListener(this);
        int columnWidth = UiUtilities.getStringWidth(this.mTable.getFont(), this.mTableModel.getColumnName(0)) + 16;
        this.mTable.getColumnModel().getColumn(0).setPreferredWidth(columnWidth);
        this.mTable.getColumnModel().getColumn(0).setMaxWidth(columnWidth);
        this.mTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int rowIndex;
                if (e.isPopupTrigger() && (rowIndex = PluginSettingsTab.this.mTable.rowAtPoint(e.getPoint())) >= 0) {
                    PluginSettingsTab.this.mTable.setRowSelectionInterval(rowIndex, rowIndex);
                    Object plugin = PluginSettingsTab.this.mTable.getModel().getValueAt(rowIndex, 1);
                    JPopupMenu menu = plugin instanceof InfoIf ? PluginSettingsTab.this.createContextMenu((InfoIf)plugin) : PluginSettingsTab.this.createContextMenu((InternalPluginProxyIf)plugin);
                    menu.show(PluginSettingsTab.this.mTable, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int rowIndex;
                if (e.isPopupTrigger() && (rowIndex = PluginSettingsTab.this.mTable.rowAtPoint(e.getPoint())) >= 0) {
                    PluginSettingsTab.this.mTable.setRowSelectionInterval(rowIndex, rowIndex);
                    Object plugin = PluginSettingsTab.this.mTable.getModel().getValueAt(rowIndex, 1);
                    JPopupMenu menu = plugin instanceof InfoIf ? PluginSettingsTab.this.createContextMenu((InfoIf)plugin) : PluginSettingsTab.this.createContextMenu((InternalPluginProxyIf)plugin);
                    menu.show(PluginSettingsTab.this.mTable, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int rowIndex;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (rowIndex = PluginSettingsTab.this.mTable.getSelectedRow()) >= 0) {
                    Object proxy = PluginSettingsTab.this.mTableModel.getValueAt(rowIndex, 1);
                    if (proxy instanceof PluginProxy) {
                        PluginSettingsTab.this.showInfoDialog((PluginProxy)proxy);
                    } else if (proxy instanceof InternalPluginProxyIf) {
                        PluginSettingsTab.this.showInfoDialog((InternalPluginProxyIf)proxy);
                    } else if (proxy instanceof TvDataServiceProxy) {
                        PluginSettingsTab.this.showInformation((TvDataServiceProxy)proxy);
                    }
                }
            }
        });
        this.populatePluginList();
        JScrollPane pane = new JScrollPane(this.mTable);
        pane.getViewport().setBackground(this.mTable.getBackground());
        contentPanel.add((Component)pane, cc.xyw(1, 5, 2));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.mInfo = new JButton(LOCALIZER.msg("info", "Info"), IconLoader.getInstance().getIconFromTheme("status", "dialog-information", 16));
        this.mInfo.addActionListener(e -> {
            Object selection = this.getSelection();
            if (selection instanceof PluginProxy) {
                this.showInfoDialog((PluginProxy)selection);
            } else if (selection instanceof InternalPluginProxyIf) {
                this.showInfoDialog((InternalPluginProxyIf)selection);
            } else if (selection instanceof TvDataServiceProxy) {
                this.showInformation((TvDataServiceProxy)selection);
            }
        });
        this.mConfigure = new JButton(LOCALIZER.msg("configure", "Configure"), TVBrowserIcons.preferences(16));
        this.mConfigure.addActionListener(e -> {
            Object selection = this.getSelection();
            if (selection instanceof PluginProxy) {
                this.configurePlugin((PluginProxy)selection);
            } else if (selection instanceof InternalPluginProxyIf) {
                this.mSettingsDialog.showSettingsTab(((InternalPluginProxyIf)selection).getSettingsId());
            } else if (selection instanceof TvDataServiceProxy) {
                this.configureService((TvDataServiceProxy)selection);
            }
        });
        builder.addButton((JComponent)this.mInfo);
        builder.addRelatedGap();
        builder.addButton((JComponent)this.mConfigure);
        builder.addRelatedGap();
        builder.addGlue();
        builder.addRelatedGap();
        this.mRemove = new JButton(Localizer.getLocalization("i18n_delete"), TVBrowserIcons.delete(16));
        this.mRemove.addActionListener(e -> {
            if (this.getSelection() instanceof PluginProxy) {
                this.removePlugin((PluginProxy)this.getSelection());
            } else {
                this.removeService((TvDataServiceProxy)this.getSelection());
            }
        });
        builder.addButton((JComponent)this.mRemove);
        contentPanel.add((Component)builder.getPanel(), cc.xyw(1, 7, 2));
        this.mTable.getSelectionModel().addListSelectionListener(e -> this.updateBtns());
        this.updateBtns();
        return contentPanel;
    }

    private Object getSelection() {
        int rowIndex = this.mTable.getSelectedRow();
        if (rowIndex >= 0) {
            Object proxy = this.mTableModel.getValueAt(rowIndex, 1);
            this.mTable.scrollRectToVisible(this.mTable.getCellRect(rowIndex, 0, true));
            return proxy;
        }
        return null;
    }

    private JPopupMenu createContextMenu(InternalPluginProxyIf plugin) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem configureMI = new JMenuItem(LOCALIZER.msg("configure", ""), TVBrowserIcons.preferences(16));
        configureMI.addActionListener(e -> this.mSettingsDialog.showSettingsTab(plugin.getSettingsId()));
        menu.add(configureMI);
        JMenuItem helpMI = new JMenuItem(LOCALIZER.msg("pluginHelp", "Online help"), IconLoader.getInstance().getIconFromTheme("apps", "help-browser", 16));
        helpMI.addActionListener(e -> {
            String url = PluginInfo.getHelpUrl(plugin.getId());
            Launch.openURL(url);
        });
        menu.add(helpMI);
        return menu;
    }

    private JPopupMenu createContextMenu(InfoIf plugin) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem infoMI = new JMenuItem(LOCALIZER.msg("info", "Info"), IconLoader.getInstance().getIconFromTheme("status", "dialog-information", 16));
        infoMI.setFont(infoMI.getFont().deriveFont(1));
        infoMI.addActionListener(e -> {
            if (plugin instanceof PluginProxy) {
                this.showInfoDialog((PluginProxy)plugin);
            } else if (plugin instanceof TvDataServiceProxy) {
                this.showInformation((TvDataServiceProxy)plugin);
            }
        });
        menu.add(infoMI);
        JMenuItem configureMI = new JMenuItem(LOCALIZER.msg("configure", "Configure"), TVBrowserIcons.preferences(16));
        configureMI.addActionListener(e -> {
            if (plugin instanceof PluginProxy) {
                this.configurePlugin((PluginProxy)plugin);
            } else if (plugin instanceof TvDataServiceProxy) {
                this.configureService((TvDataServiceProxy)plugin);
            }
        });
        menu.add(configureMI);
        if (plugin instanceof PluginProxy) {
            JMenuItem reset;
            JMenuItem enableMI;
            if (((PluginProxy)plugin).isActivated()) {
                enableMI = new JMenuItem(LOCALIZER.msg("deactivate", "Deactivate"), IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
            } else {
                enableMI = new JMenuItem(LOCALIZER.msg("activate", "Activate"), TVBrowserIcons.refresh(16));
                enableMI.setEnabled(!Settings.Plugins.BLOCKED_ARRAY.isBlocked((PluginProxy)plugin));
            }
            enableMI.addActionListener(e -> {
                int row = this.mTable.getSelectedRow();
                if (row >= 0) {
                    this.mTableModel.setValueAt((Boolean)this.mTableModel.getValueAt(row, 0) == false, row, 0);
                }
            });
            menu.add(enableMI);
            if (Settings.Plugins.RESET_IDS.containsItem(plugin.getId())) {
                reset = new JMenuItem(LOCALIZER.msg("unreset", "Don't reset settings"), TVBrowserIcons.redo(16));
                reset.addActionListener(e -> {
                    Settings.Plugins.RESET_IDS.removeItem(plugin.getId());
                    Settings.setRestartInfo(plugin.getId(), false);
                });
            } else {
                reset = new JMenuItem(LOCALIZER.msg("reset", "Reset settings"), TVBrowserIcons.reset(16));
                reset.addActionListener(e -> {
                    DontShowAgainOptionBox.showOptionDialog("pluginSettingsResetMsg", UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("resetInfo", "The settings of '{0}' will be reset when you restart TV-Browser.\n\nNOTE: TV-Browser will only delete the settings that are handled by it.\nShould '{0}' handle settings by itself the settings will not be reset.", plugin.getInfo().getName()));
                    Settings.Plugins.RESET_IDS.addItem(plugin.getId());
                    Settings.setRestartInfo(plugin.getId(), true);
                });
            }
            menu.add(reset);
        }
        if (plugin instanceof PluginProxy || plugin instanceof TvDataServiceProxy) {
            JMenuItem deleteMI = new JMenuItem(LOCALIZER.msg("remove", "Remove"), TVBrowserIcons.delete(16));
            deleteMI.addActionListener(e -> {
                if (plugin instanceof PluginProxy) {
                    this.removePlugin((PluginProxy)plugin);
                } else {
                    this.removeService((TvDataServiceProxy)plugin);
                }
            });
            menu.add(deleteMI);
        }
        JMenuItem helpMI = new JMenuItem(LOCALIZER.msg("pluginHelp", "Online help"), IconLoader.getInstance().getIconFromTheme("apps", "help-browser", 16));
        helpMI.addActionListener(e -> {
            String url = PluginInfo.getHelpUrl(plugin.getId());
            Launch.openURL(url);
        });
        menu.add(helpMI);
        menu.addSeparator();
        JMenuItem refreshMI = new JMenuItem(LOCALIZER.msg("updateInstallPlugin", "Update/Install Plugins"), IconLoader.getInstance().getIconFromTheme("actions", "web-search", 16));
        refreshMI.addActionListener(e -> MainFrame.getInstance().showUpdatePluginsDlg(false));
        menu.add(refreshMI);
        return menu;
    }

    private void removePlugin(PluginProxy plugin) {
        if (plugin == null) {
            return;
        }
        File undeletable = PluginLoader.getInstance().getUndeletablePluginFile(plugin);
        if (undeletable != null) {
            JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), LOCALIZER.msg("noaccess", "The plugin '{0}' is installed outside of user space.\nTo delete the plugin close TV-Browser and (ask the\nadministrator to) delete  the file:\n\n'{1}'", plugin.getInfo().getName(), undeletable.getAbsolutePath()));
        } else {
            String text = LOCALIZER.msg("deletePlugin", "Really delete the Plugin \"{0}\" ?", plugin.toString());
            int result = JOptionPane.showConfirmDialog(this.mSettingsDialog.getDialog(), text, Localizer.getLocalization("i18n_delete") + "?", 0);
            if (result == 0) {
                if (PluginLoader.getInstance().deletePlugin(plugin)) {
                    JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), LOCALIZER.msg("successfully", "Deletion was succesfully"));
                } else {
                    JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), LOCALIZER.msg("failed", "Deletion failed"));
                }
                this.populatePluginList();
                this.mSettingsDialog.createPluginTreeItems();
                this.mTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void removeService(TvDataServiceProxy service) {
        Object text;
        if (service == null) {
            return;
        }
        File undeletable = PluginLoader.getInstance().getUndeletableDataServiceFile(service);
        int channelCount = 0;
        Channel[] subscribed = ChannelList.getSubscribedChannels();
        ArrayList<Channel> keepChannels = new ArrayList<Channel>();
        for (Channel element : subscribed) {
            if (!(element instanceof DummyChannel) && element.getDataServiceProxy().equals(service)) {
                ++channelCount;
                continue;
            }
            keepChannels.add(element);
        }
        if (undeletable != null) {
            text = LOCALIZER.msg("noaccess", "The plugin '{0}' is installed outside of user space.\nTo delete the plugin close TV-Browser and (ask the\nadministrator to) delete  the file:\n\n'{1}'", service.getInfo().getName(), undeletable.getAbsolutePath());
            if (channelCount > 0) {
                text = (String)text + LOCALIZER.msg("noaccess.channels", "\n\nNOTE: If you delete the plugin '{0}' it will remove {1} of your subscribed channels.", service.getInfo().getName(), channelCount);
            }
            JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), text);
        } else {
            int result;
            text = LOCALIZER.msg("deleteService", "Really delete the data plugin \"{0}\"?", service.getInfo().getName());
            if (channelCount > 0) {
                text = LOCALIZER.msg("deleteServiceCount", "Really delete the data plugin \"{0}\"?\nThis will remove {1} of your subscribed channels.", service.getInfo().getName(), channelCount);
            }
            if ((result = JOptionPane.showConfirmDialog(this.mSettingsDialog.getDialog(), text, Localizer.getLocalization("i18n_delete") + "?", 0)) == 0) {
                if (PluginLoader.getInstance().deleteDataService(service)) {
                    JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), LOCALIZER.msg("dataservice.successfully", "Deletion was succesfully"));
                    ChannelsSettingsTab.saveChannels(keepChannels.toArray(new Channel[keepChannels.size()]), false);
                } else {
                    JOptionPane.showMessageDialog(this.mSettingsDialog.getDialog(), LOCALIZER.msg("failed", "Deletion failed"));
                }
                this.populatePluginList();
                this.mTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void showInfoDialog(PluginProxy plugin) {
        if (plugin == null) {
            return;
        }
        ActionMenu actionMenu = plugin.getButtonAction();
        Action action = null;
        if (actionMenu != null) {
            action = actionMenu.getAction();
        }
        Icon ico = null;
        if (action != null) {
            ico = (Icon)action.getValue("SmallIcon");
        }
        if (ico == null) {
            ico = plugin.getMarkIcon();
        }
        if (ico == null) {
            ico = new ImageIconEnhanced("imgs/Jar16.gif");
        }
        PluginInfoDialog dialog = new PluginInfoDialog(this.mSettingsDialog.getDialog(), ico, plugin.getInfo());
        UiUtilities.centerAndShow(dialog);
    }

    private void showInfoDialog(InternalPluginProxyIf plugin) {
        JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), LOCALIZER.msg("internalPlugin", "This is an internal plugin which cannot be disabled."), LOCALIZER.msg("internalPluginTitle", "Internal plugin"), 1);
    }

    private void showInformation(TvDataServiceProxy service) {
        if (service == null) {
            return;
        }
        PluginInfoDialog dialog = new PluginInfoDialog(this.mSettingsDialog.getDialog(), null, service.getInfo());
        UiUtilities.centerAndShow(dialog);
    }

    private void configurePlugin(PluginProxy plugin) {
        if (plugin == null) {
            return;
        }
        this.mSettingsDialog.showSettingsTab(plugin.getId());
    }

    private void configureService(TvDataServiceProxy service) {
        if (service == null) {
            return;
        }
        this.mSettingsDialog.showSettingsTab(service.getId());
    }

    private void populatePluginList() {
        while (this.mTableModel.getRowCount() > 0) {
            this.mTableModel.removeRow(0);
        }
        Object test = this.mFilterBox.getSelectedItem();
        SoftwareUpdateDlg.FilterItem filterItem = null;
        String filterName = this.mFilterName.getText().strip().toLowerCase();
        filterItem = test == null ? new SoftwareUpdateDlg.FilterItem("all") : (SoftwareUpdateDlg.FilterItem)test;
        ArrayList<SoftwareUpdateDlg.FilterItem> filterItemList = new ArrayList<SoftwareUpdateDlg.FilterItem>();
        InternalPluginProxyIf[] internalPluginProxies = InternalPluginProxyList.getInstance().getAvailableProxys();
        Arrays.sort(internalPluginProxies, new InternalPluginProxyIf.Comparator());
        for (InternalPluginProxyIf internalPluginProxy : internalPluginProxies) {
            if (!filterItem.accept(internalPluginProxy) || !internalPluginProxy.getName().toLowerCase().contains(filterName)) continue;
            this.mTableModel.addRow(new Object[]{true, internalPluginProxy});
            if (this.mFilterBox.getItemCount() >= 1) continue;
            int index = 0;
            for (int i = 0; i < filterItemList.size(); ++i) {
                int compareValue = ((SoftwareUpdateDlg.FilterItem)filterItemList.get(i)).compareTo(internalPluginProxy.getPluginCategory());
                if (compareValue == 0) {
                    index = -1;
                    break;
                }
                if (compareValue >= 0) continue;
                index = i + 1;
            }
            if (index == -1) continue;
            filterItemList.add(index, new SoftwareUpdateDlg.FilterItem(internalPluginProxy.getPluginCategory()));
        }
        PluginProxy[] pluginList = PluginProxyManager.getInstance().getAllPlugins();
        TvDataServiceProxy[] services = TvDataServiceProxyManager.getInstance().getDataServices();
        InfoIf[] infoArr = new InfoIf[pluginList.length + services.length];
        System.arraycopy(pluginList, 0, infoArr, 0, pluginList.length);
        System.arraycopy(services, 0, infoArr, pluginList.length, services.length);
        Arrays.sort(infoArr, new PluginAndDataServiceComparator());
        for (InfoIf info : infoArr) {
            if (!filterItem.accept(info) || !info.getInfo().getName().toLowerCase().contains(filterName)) continue;
            this.mTableModel.addRow(new Object[]{info instanceof PluginProxy ? ((PluginProxy)info).isActivated() : true, info});
            if (this.mFilterBox.getItemCount() >= 1) continue;
            int index = 0;
            for (int i = 0; i < filterItemList.size(); ++i) {
                int compareValue = ((SoftwareUpdateDlg.FilterItem)filterItemList.get(i)).compareTo(info.getPluginCategory());
                if (compareValue == 0) {
                    index = -1;
                    break;
                }
                if (compareValue >= 0) continue;
                index = i + 1;
            }
            if (index == -1) continue;
            filterItemList.add(index, new SoftwareUpdateDlg.FilterItem(info.getPluginCategory()));
        }
        if (this.mFilterBox.getItemCount() < 1) {
            if (!filterItemList.contains(new SoftwareUpdateDlg.FilterItem("all"))) {
                filterItemList.add(0, new SoftwareUpdateDlg.FilterItem("all"));
            }
            for (SoftwareUpdateDlg.FilterItem item : filterItemList) {
                this.mFilterBox.addItem(item);
            }
        }
    }

    private void updateBtns() {
        int rowIndex = this.mTable.getSelectedRow();
        Object plugin = null;
        if (rowIndex >= 0) {
            plugin = this.mTable.getValueAt(rowIndex, 1);
        }
        this.mInfo.setEnabled(plugin != null && (plugin instanceof PluginProxy || plugin instanceof TvDataServiceProxy));
        this.mRemove.setEnabled(plugin != null && (plugin instanceof PluginProxy || plugin instanceof TvDataServiceProxy));
        this.mConfigure.setEnabled(plugin != null);
    }

    private void onStartStopBtnClicked(PluginProxy plugin) {
        if (plugin != null) {
            try {
                if (plugin.isActivated()) {
                    PluginProxyManager.getInstance().deactivatePlugin(plugin);
                } else {
                    PluginProxyManager.getInstance().activatePlugin(plugin, true);
                    try {
                        PluginProxyManager.getInstance().fireTvBrowserStartFinished(plugin);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "A not catched error occured in 'fireTvBrowserStartFinishedThread' of Plugin '" + plugin + "'.", t);
                    }
                }
            }
            catch (TvBrowserException exc) {
                ErrorHandler.handle(exc);
            }
            this.mTable.repaint();
            this.updateBtns();
            this.mSettingsDialog.invalidateTree();
            this.mSettingsDialog.createPluginTreeItems();
            MainFrame.getInstance().getToolbar().updatePluginButtons();
        }
        String[] deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds();
        Settings.Plugins.DEACTIVATED.setStringArray(deactivatedPlugins);
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public Icon getIcon() {
        return TVBrowserIcons.plugin(16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("plugins", "Plugins");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (column == 0) {
            Cursor oldCursor = this.mTable.getCursor();
            this.mTable.setCursor(Cursor.getPredefinedCursor(3));
            Object plugin = this.mTableModel.getValueAt(row, 1);
            if (plugin instanceof PluginProxy) {
                this.onStartStopBtnClicked((PluginProxy)plugin);
            }
            this.mTable.setCursor(oldCursor);
        }
    }
}

