/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.PluginInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import util.browserlauncher.Launch;
import util.i18n.Localizer;
import util.ui.ImageIconEnhanced;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.html.ExtendedHTMLDocument;
import util.ui.html.ExtendedHTMLEditorKit;
import util.ui.html.HTMLTextHelper;

public class PluginInfoDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(PluginInfoDialog.class);
    private PluginInfo mPluginInfo;
    private Icon mPluginIcon;

    public PluginInfoDialog(JDialog dialog, PluginInfo pluginInfo) {
        this(dialog, null, pluginInfo);
    }

    public PluginInfoDialog(JDialog dialog, Icon icon, PluginInfo pluginInfo) {
        super((Dialog)dialog, true);
        this.setTitle(pluginInfo.getName());
        this.mPluginInfo = pluginInfo;
        if (icon == null) {
            icon = new ImageIconEnhanced("imgs/Jar16.gif");
        }
        this.mPluginIcon = icon;
        this.initGui();
    }

    private void initGui() {
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(Borders.DLU4);
        panel.setLayout((LayoutManager)new FormLayout("fill:default:grow, default", "fill:default:grow, 3dlu, default"));
        CellConstraints cc = new CellConstraints();
        JEditorPane infoPanel = new JEditorPane();
        infoPanel.setEditorKit(new ExtendedHTMLEditorKit());
        ExtendedHTMLDocument doc = (ExtendedHTMLDocument)infoPanel.getDocument();
        infoPanel.setEditable(false);
        UiUtilities.updateHtmlHelpTextArea(infoPanel, this.generateHtml(doc), UIManager.getColor("EditorPane.background"));
        infoPanel.addHyperlinkListener(evt -> {
            URL url;
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = evt.getURL()) != null) {
                Launch.openURL(url.toString());
            }
        });
        panel.add((Component)new JScrollPane(infoPanel), cc.xyw(1, 1, 2));
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(e -> this.close());
        panel.add((Component)ok, cc.xy(2, 3));
        Settings.layoutWindow("pluginInfoDialog", this, new Dimension(700, 500));
        UiUtilities.registerForClosing(this);
    }

    private String generateHtml(ExtendedHTMLDocument doc) {
        StringBuilder html = new StringBuilder(1024);
        html.append("<html><style type=\"text/css\" media=\"screen\"><!--body {font-size:12px;font-family:Dialog;}h1 {font-size:12px;font-family:Dialog;font-weight:bold;}--></style><body>");
        html.append("<table><tr><td valign=\"top\">");
        html.append(doc.createCompTag(new JLabel(this.mPluginIcon)));
        html.append("</td><td valign=\"top\"><b>").append(this.mPluginInfo.getName()).append("</b></td></tr></table>");
        html.append("<i>").append(LOCALIZER.msg("version", "Version")).append(' ').append(this.mPluginInfo.getVersion()).append("</i><br>");
        html.append("<h1>").append(LOCALIZER.msg("author", "Author")).append("</h1>");
        html.append(HTMLTextHelper.convertTextToHtml(this.mPluginInfo.getAuthor(), true));
        if (StringUtils.isNotEmpty((CharSequence)this.mPluginInfo.getLicense())) {
            html.append("<h1>").append(LOCALIZER.msg("licence", "Licence")).append("</h1>");
            html.append(this.mPluginInfo.getLicense().toLowerCase().startsWith("<html>") ? this.mPluginInfo.getLicense() : HTMLTextHelper.convertTextToHtml(this.mPluginInfo.getLicense(), true));
        }
        html.append("<h1>").append(LOCALIZER.msg("description", "Description")).append("</h1>");
        html.append(HTMLTextHelper.convertTextToHtml(this.mPluginInfo.getDescription(), true));
        if (this.mPluginInfo.getHelpUrl() != null) {
            html.append("<br><br><a href=\"").append(this.mPluginInfo.getHelpUrl()).append("</a>");
        }
        html.append("</body></html>");
        return html.toString();
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

