/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import devplugin.AbstractTvDataService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvdataservice.SettingsPanel;
import util.ui.UiUtilities;

public class DataServiceConfigDlg
implements ActionListener {
    private JDialog mDialog;
    private JButton cancelBtn;
    private JButton okBtn;
    private SettingsPanel configPanel;

    public DataServiceConfigDlg(Component parent, AbstractTvDataService dataService) {
        this.mDialog = UiUtilities.createDialog(parent, true);
        this.mDialog.setTitle("Configure " + dataService.getInfo().getName());
        JPanel contentPane = (JPanel)this.mDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.configPanel = dataService.getSettingsPanel();
        if (this.configPanel != null) {
            contentPane.add((Component)this.configPanel, "North");
        } else {
            contentPane.add((Component)new JLabel("no config pane available"), "Center");
        }
        JPanel pushButtonPanel = new JPanel();
        if (this.configPanel != null) {
            this.okBtn = new JButton("OK");
            this.okBtn.addActionListener(this);
            pushButtonPanel.add(this.okBtn);
            this.mDialog.getRootPane().setDefaultButton(this.okBtn);
        }
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        pushButtonPanel.add(this.cancelBtn);
        contentPane.add((Component)pushButtonPanel, "South");
        this.mDialog.pack();
    }

    public void centerAndShow() {
        UiUtilities.centerAndShow(this.mDialog);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            this.configPanel.ok();
        } else if (e.getSource() == this.cancelBtn) {
            this.mDialog.dispose();
        }
    }
}

