/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import devplugin.CancelableSettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.ui.settings.AbstractSettingsTab;
import tvbrowser.ui.settings.PluginInfoPanel;
import tvdataservice.SettingsPanel;
import util.i18n.Localizer;
import util.ui.ImageIconEnhanced;

public class ConfigDataServiceSettingsTab
extends AbstractSettingsTab
implements CancelableSettingsTab {
    private TvDataServiceProxy mDataService;
    private SettingsPanel mSettingsPanel;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ConfigDataServiceSettingsTab.class);

    public ConfigDataServiceSettingsTab(TvDataServiceProxy dataService) {
        this.mDataService = dataService;
        this.mSettingsPanel = this.mDataService.getSettingsPanel();
    }

    @Override
    public JPanel createSettingsPanel() {
        JPanel mainPn = new JPanel(new BorderLayout());
        mainPn.setBorder(Borders.DIALOG);
        PluginInfoPanel infoPn = new PluginInfoPanel(this.mSettingsPanel != null);
        infoPn.setDefaultBorder(false);
        infoPn.setPluginInfo(this.mDataService.getInfo());
        mainPn.add((Component)infoPn, "North");
        if (this.mSettingsPanel != null) {
            mainPn.add((Component)this.mSettingsPanel, "Center");
        } else {
            JPanel centerPn = new JPanel(new BorderLayout());
            centerPn.add((Component)this.createEmptyPanel(LOCALIZER.msg("noSettings", "No settings"), LOCALIZER.msg("noSettings.text", "This plugin has no settings.")), "North");
            mainPn.add((Component)centerPn, "Center");
        }
        return mainPn;
    }

    @Override
    public void saveSettings() {
        if (this.mSettingsPanel != null) {
            this.mSettingsPanel.ok();
        }
    }

    @Override
    public Icon getIcon() {
        return new ImageIconEnhanced("imgs/Jar16.gif");
    }

    @Override
    public String getTitle() {
        return this.mDataService.getInfo().getName();
    }

    @Override
    public void cancel() {
        if (this.mSettingsPanel != null) {
            this.mSettingsPanel.cancel();
        }
    }
}

