/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.finder.calendar;

import devplugin.Date;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import tvbrowser.core.TvDataBase;
import tvbrowser.ui.finder.calendar.CalendarTableModel;

public final class CalendarTableCellRenderer
implements TableCellRenderer {
    private static JPanel mPanel;
    private static JLabel mLabel;
    private static Font mBoldFont;
    private static Font mPlainFont;
    private static Font mItalicFont;
    private static DashedBorder mDashedBorder;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (mPanel == null) {
            mPanel = new JPanel();
            mPanel.setLayout(new GridLayout(0, 1));
            mPanel.setOpaque(true);
            mLabel = new JLabel();
            mLabel.setHorizontalAlignment(0);
            mPanel.add(mLabel);
            int fontSize = mLabel.getFont().getSize() - 2;
            mBoldFont = new Font("Dialog", 1, fontSize + 2);
            mPlainFont = new Font("Dialog", 0, fontSize);
            mItalicFont = new Font("Dialog", 2, fontSize);
            mDashedBorder = new DashedBorder();
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            if (isSelected) {
                mPanel.setBorder(mDashedBorder);
            } else {
                mPanel.setBorder(null);
            }
            boolean enabled = TvDataBase.getInstance().dataAvailable(date);
            mLabel.setText(String.valueOf(date.getDayOfMonth()));
            mLabel.setEnabled(enabled);
            CalendarTableModel tableModel = (CalendarTableModel)table.getModel();
            Date today = new Date();
            if (date.equals(today)) {
                mLabel.setFont(mBoldFont);
            } else if (date.compareTo(today) < 0) {
                mLabel.setFont(mItalicFont);
            } else {
                mLabel.setFont(mPlainFont);
            }
            if (date.equals(tableModel.getCurrentDate())) {
                mPanel.setBackground(UIManager.getColor("List.selectionBackground"));
                mLabel.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                mPanel.setBackground(table.getBackground());
                mLabel.setForeground(table.getForeground());
            }
        } else {
            mPanel.setBackground(table.getBackground());
            if (value != null) {
                mLabel.setText(value.toString());
                mLabel.setEnabled(true);
            }
        }
        return mPanel;
    }

    private static class DashedBorder
    implements Border {
        static final int THICKNESS = 1;
        Color color;
        int dashWidth;
        int dashHeight;

        public DashedBorder() {
            this(Color.black, 2, 2);
        }

        public DashedBorder(Color c, int width, int height) {
            if (width < 1) {
                throw new IllegalArgumentException("Invalid width: " + width);
            }
            if (height < 1) {
                throw new IllegalArgumentException("Invalid height: " + height);
            }
            this.color = c;
            this.dashWidth = width;
            this.dashHeight = height;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int startPoint;
            int i;
            Insets insets = this.getBorderInsets(c);
            g.setColor(this.color);
            int numWide = width / this.dashWidth;
            int numHigh = height / this.dashHeight;
            for (i = 0; i <= numWide; i += 2) {
                startPoint = x + this.dashWidth * i;
                g.fillRect(startPoint, y, this.dashWidth, 1);
                g.fillRect(startPoint, y + height - insets.bottom, this.dashWidth, 1);
            }
            for (i = 0; i <= numHigh; i += 2) {
                startPoint = x + this.dashHeight * i;
                g.fillRect(x, startPoint, 1, this.dashHeight);
                g.fillRect(x + width - insets.right, startPoint, 1, this.dashHeight);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

