/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import devplugin.Program;
import devplugin.ProgramFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.ui.filter.dlgs.FilterComponentsDlg;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import util.i18n.Localizer;
import util.ui.ProgramPanel;
import util.ui.SendToPluginDialog;
import util.ui.UiUtilities;

public class FilterButtons
implements ActionListener {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(FilterButtons.class);
    private JMenuItem mEditFilterMI;
    private JMenuItem mEditFilterComponentsMI;
    private JMenuItem mSendFilterMI;

    private FilterButtons(JMenu filterMenu, MainFrame mainFrame) {
        this.createFilterMenuItems(filterMenu, mainFrame);
    }

    public static void createFilterButtons(JMenu filterMenu, MainFrame mainFrame) {
        new FilterButtons(filterMenu, mainFrame);
    }

    private void createFilterMenuItems(JMenu filterMenu, MainFrame mainFrame) {
        ProgramFilter curFilter = mainFrame.getProgramFilter();
        this.mEditFilterMI = new JMenuItem(LOCALIZER.ellipsisMsg("createFilter", "Edit filter"));
        this.mEditFilterMI.addActionListener(this);
        filterMenu.add(this.mEditFilterMI);
        this.mEditFilterComponentsMI = new JMenuItem(FilterComponentsDlg.LOCALIZER.ellipsisMsg("title", "Edit filter components"));
        this.mEditFilterComponentsMI.addActionListener(this);
        filterMenu.add(this.mEditFilterComponentsMI);
        if (curFilter != null && !(curFilter instanceof ShowAllFilter)) {
            this.mSendFilterMI = new JMenuItem(LOCALIZER.msg("sendPrograms", "Send visible Programs to another Plugin"));
            this.mSendFilterMI.addActionListener(this);
            filterMenu.add(this.mSendFilterMI);
        }
        filterMenu.addSeparator();
        FilterList.getInstance().createFilterMenu(filterMenu, curFilter);
        this.mEditFilterMI.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.mEditFilterComponentsMI.setAccelerator(KeyStroke.getKeyStroke(75, 128));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mEditFilterMI) {
            MainFrame.getInstance().showFilterDialog();
        } else if (e.getSource() == this.mEditFilterComponentsMI) {
            new FilterComponentsDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
        } else if (e.getSource() == this.mSendFilterMI) {
            this.sendPrograms();
        }
    }

    private void sendPrograms() {
        Program[] prgs = this.collectPrograms();
        SendToPluginDialog sendTo = new SendToPluginDialog(null, MainFrame.getInstance(), prgs);
        sendTo.setVisible(true);
    }

    private Program[] collectPrograms() {
        ArrayList<Program> array = new ArrayList<Program>();
        DefaultProgramTableModel model = MainFrame.getInstance().getProgramTableModel();
        int columnCount = model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            int rowCount = model.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = model.getProgramPanel(col, row);
                array.add(panel.getProgram());
            }
        }
        Program[] prg = new Program[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            prg[i] = (Program)array.get(i);
        }
        return prg;
    }
}

