/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.LimitationsWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;

public class NotificationWizardStep
extends AbstractWizardStep {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(NotificationWizardStep.class);
    private JCheckBox mReminderCb;
    private JCheckBox mCheckOnUpdateCb;
    private Program mProgram;
    private WizardStep mCaller;

    public NotificationWizardStep(WizardStep caller, Program prog) {
        this.mProgram = prog;
        this.mCaller = caller;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Notification");
    }

    @Override
    public JPanel createContent(WizardHandler handler) {
        EnhancedPanelBuilder panelBuilder = new EnhancedPanelBuilder(new FormLayout("default"));
        panelBuilder.border(Borders.DLU4);
        panelBuilder.addLabelRow(false, LOCALIZER.msg("mainQuestion", "Wollen Sie automatisch auf diese Sendung hingewiesen werden?"), 1);
        this.mReminderCb = new JCheckBox(LOCALIZER.msg("option.remind", "Automatisch an diese Sendung erinnern."));
        panelBuilder.addRow(this.mReminderCb, 1);
        this.mCheckOnUpdateCb = new JCheckBox(LOCALIZER.msg("option.checkAfterUpdate", "Sofort alarmieren, wenn die Sendung nach einer Aktualisierung gefunden wird."));
        panelBuilder.addRow(this.mCheckOnUpdateCb, 1);
        this.mReminderCb.setSelected(FavoritesPlugin.getInstance().isAutoSelectingReminder());
        JPanel result = panelBuilder.getPanel();
        result.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                NotificationWizardStep.this.mReminderCb.requestFocusInWindow();
            }
        });
        return result;
    }

    @Override
    public Object createDataObject(Object obj) {
        Favorite fav = (Favorite)obj;
        fav.setRemindAfterDownload(this.mCheckOnUpdateCb.isSelected());
        if (this.mReminderCb.isSelected()) {
            fav.getReminderConfiguration().setReminderServices(new String[]{"window"});
        } else {
            fav.getReminderConfiguration().setReminderServices(new String[0]);
        }
        return fav;
    }

    @Override
    public WizardStep next() {
        return new LimitationsWizardStep(this, this.mProgram);
    }

    @Override
    public WizardStep back() {
        return this.mCaller;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4, 3, 1};
    }
}

