/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FilterFavorite;
import tvbrowser.extras.favoritesplugin.core.PendingFilterLoader;
import tvbrowser.ui.filter.dlgs.SelectFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.SearchForm;
import util.ui.SearchFormSettings;
import util.ui.UiUtilities;
import util.ui.WrapperFilter;

public class AdvancedFavorite
extends Favorite
implements PendingFilterLoader {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(AdvancedFavorite.class);
    public static final String TYPE_ID = "advanced";
    private ProgramFilter mFilter;
    private String mFilterName;
    private String mPendingFilterName = null;

    private AdvancedFavorite() {
    }

    public AdvancedFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super(in);
        boolean useFilter;
        int version = in.readInt();
        this.mSearchFormSettings = new SearchFormSettings(in);
        if (version > 1 && (useFilter = in.readBoolean())) {
            this.mPendingFilterName = (String)in.readObject();
            FavoritesPlugin.getInstance().addPendingFavorite(this);
        }
    }

    public AdvancedFavorite(String searchText) {
        this.mSearchFormSettings = new SearchFormSettings(searchText);
        this.mSearchFormSettings.setUserDefaultFieldTypes(FavoritesPlugin.getInstance().getDefaultProgramFieldTypeSelection());
        if (searchText.contains(" OR ") || searchText.contains(" AND ") || searchText.contains(" NOT ")) {
            this.mSearchFormSettings.setSearcherType(4);
            this.mSearchFormSettings.setSearchIn(2);
        }
    }

    public AdvancedFavorite(String searchText, int searchIn, int searcherType, boolean useDefaultSearchFieldTypes) {
        this.mSearchFormSettings = new SearchFormSettings(searchText);
        this.mSearchFormSettings.setSearchIn(searchIn);
        this.mSearchFormSettings.setSearcherType(searcherType);
        if (useDefaultSearchFieldTypes) {
            this.mSearchFormSettings.setUserDefaultFieldTypes(FavoritesPlugin.getInstance().getDefaultProgramFieldTypeSelection());
        }
        if (searchText.contains(" OR ") || searchText.contains(" AND ") || searchText.contains(" NOT ")) {
            this.mSearchFormSettings.setSearcherType(4);
        }
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public String getName() {
        if (super.getName() != null) {
            return super.getName();
        }
        return this.mSearchFormSettings.getSearchText();
    }

    @Override
    public FavoriteConfigurator createConfigurator() {
        return new Configurator();
    }

    @Override
    protected void internalWriteData(ObjectOutputStream out) throws IOException {
        out.writeInt(2);
        this.mSearchFormSettings.writeData(out);
        out.writeBoolean(this.mFilter != null || this.mPendingFilterName != null);
        if (this.mFilter != null) {
            out.writeObject(this.mFilter.getName());
        } else if (this.mPendingFilterName != null) {
            out.writeObject(this.mPendingFilterName);
        }
    }

    public static AdvancedFavorite loadOldFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        AdvancedFavorite favorite = new AdvancedFavorite();
        favorite.readOldFavorite(in);
        return favorite;
    }

    private void readOldFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version <= 2) {
            String term = (String)in.readObject();
            in.readBoolean();
            boolean searchInText = in.readBoolean();
            int searchMode = in.readInt();
            this.mSearchFormSettings.setSearchText(term);
            if (searchInText) {
                this.mSearchFormSettings.setSearchIn(2);
            } else {
                this.mSearchFormSettings.setSearchIn(1);
            }
            switch (searchMode) {
                case 1: {
                    this.mSearchFormSettings.setSearcherType(1);
                    break;
                }
                case 2: {
                    this.mSearchFormSettings.setSearcherType(2);
                    break;
                }
                case 3: {
                    this.mSearchFormSettings.setSearcherType(3);
                    break;
                }
                default: {
                    this.mSearchFormSettings.setSearcherType(1);
                    break;
                }
            }
        } else {
            this.mSearchFormSettings = new SearchFormSettings(in);
        }
        if (version >= 5) {
            super.setName((String)in.readObject());
        } else {
            super.setName(this.mSearchFormSettings.getSearchText());
        }
        boolean useCertainChannel = in.readBoolean();
        if (version < 6) {
            String certainChannelId;
            String certainChannelServiceClassName = (String)in.readObject();
            Channel ch = Channel.getChannel(certainChannelServiceClassName, null, null, certainChannelId = version == 1 ? Integer.toString(in.readInt()) : (String)in.readObject());
            if (ch != null) {
                this.getLimitationConfiguration().setChannels(new Channel[]{ch});
            }
        } else if (useCertainChannel) {
            int cnt = in.readInt();
            ArrayList<Channel> list = new ArrayList<Channel>();
            for (int i = 0; i < cnt; ++i) {
                String certainChannelId;
                String certainChannelServiceClassName = (String)in.readObject();
                Channel channel = Channel.getChannel(certainChannelServiceClassName, null, null, certainChannelId = version == 1 ? Integer.toString(in.readInt()) : (String)in.readObject());
                if (channel == null) continue;
                list.add(channel);
            }
            this.getLimitationConfiguration().setChannels(list.toArray(new Channel[list.size()]));
        }
        boolean useCertainTimeOfDay = in.readBoolean();
        int certainFromTime = in.readInt();
        int certainToTime = in.readInt();
        if (useCertainTimeOfDay) {
            this.getLimitationConfiguration().setTime(certainFromTime, certainToTime);
        }
        int size = in.readInt();
        ArrayList<Program> programList = new ArrayList<Program>(size);
        for (int i = 0; i < size; ++i) {
            Date date = Date.readData(in);
            String progID = (String)in.readObject();
            Program program = Plugin.getPluginManager().getProgram(date, progID);
            if (program == null) continue;
            programList.add(program);
        }
        Program[] mProgramArr = new Program[programList.size()];
        programList.toArray(mProgramArr);
        if (version >= 4) {
            boolean useFilter = in.readBoolean();
            this.mFilterName = this.mPendingFilterName = (String)in.readObject();
            if (useFilter) {
                FavoritesPlugin.getInstance().addPendingFavorite(this);
            } else {
                this.mPendingFilterName = null;
            }
        } else {
            this.mFilter = null;
            this.mFilterName = null;
        }
        if (version >= 7) {
            size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Date.readData(in);
                in.readObject();
            }
        }
        this.getReminderConfiguration().setReminderServices(new String[0]);
        try {
            this.updatePrograms();
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle("Could not update favorites.", exc);
        }
    }

    private static ProgramFilter getFilterByName(String name) {
        ProgramFilter[] flist;
        for (ProgramFilter filter : flist = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
            if (filter == null || !filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    @Override
    protected Program[] internalSearchForPrograms() throws TvBrowserException {
        Program[] progArr = super.internalSearchForPrograms();
        if (this.mFilter != null) {
            ArrayList<Program> list = new ArrayList<Program>();
            for (Program element : progArr) {
                if (!this.mFilter.accept(element)) continue;
                list.add(element);
            }
            return list.toArray(new Program[list.size()]);
        }
        return progArr;
    }

    @Override
    public boolean matches(Program p) throws TvBrowserException {
        return super.matches(p) && (this.mFilter == null || this.mFilter.accept(p));
    }

    @Override
    public void loadPendingFilter() {
        if (this.mPendingFilterName != null) {
            try {
                this.mFilter = AdvancedFavorite.getFilterByName(this.mPendingFilterName);
                if (this.mFilter != null) {
                    this.mPendingFilterName = null;
                    if (!FilterFavorite.filterIsAcceptable(this.mFilter)) {
                        this.mFilter = null;
                    }
                } else {
                    FavoritesPlugin.LOG.severe("Error on loading pending filter '" + this.mPendingFilterName + "' for Favorite: '" + this.getName() + "'. Filter was not found.");
                }
            }
            catch (Exception e) {
                ErrorHandler.handle("Error on loading pending filter '" + this.mPendingFilterName + "' for Favorite: '" + this.getName() + "'", e);
            }
        }
    }

    @Override
    public boolean isValidSearch() {
        return true;
    }

    public boolean updateFilter(ProgramFilter filter, boolean updatePrograms) {
        boolean result;
        boolean bl = result = filter != null && (this.mFilter != null && this.mFilter.equals(filter) || this.mFilterName != null && this.mFilterName.equals(filter.getName()));
        if (result) {
            this.mFilterName = filter.getName();
            this.mFilter = FilterFavorite.filterIsAcceptable(filter) ? filter : null;
        }
        boolean bl2 = result = this.updateFilterExclusion(filter, false) || result;
        if (result && updatePrograms) {
            try {
                this.updatePrograms();
            }
            catch (TvBrowserException tvBrowserException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean deleteFilter(ProgramFilter filter, boolean updatePrograms) {
        boolean result;
        boolean bl = result = filter != null && (this.mFilter != null && this.mFilter.equals(filter) || this.mFilterName != null && this.mFilterName.equals(filter.getName()));
        if (result) {
            this.mFilter = null;
            this.mFilterName = null;
        }
        boolean bl2 = result = this.deleteFilterExclusion(filter, false) || result;
        if (result && updatePrograms) {
            try {
                this.updatePrograms();
            }
            catch (TvBrowserException tvBrowserException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String getTypeName() {
        return LOCALIZER.msg("typeName", "Expert Favorite");
    }

    class Configurator
    implements FavoriteConfigurator {
        private SearchForm mSearchForm;
        private JCheckBox mFilterCheckbox;
        private JComboBox<WrapperFilter> mFilterCombo;
        private JButton mEditFilter;

        Configurator() {
        }

        @Override
        public JPanel createConfigurationPanel() {
            ProgramFilter[] availableFilter;
            this.mSearchForm = new SearchForm(true, false, false, 1, true);
            this.mSearchForm.setSearchFormSettings(AdvancedFavorite.this.mSearchFormSettings);
            EnhancedPanelBuilder panelBuilder = new EnhancedPanelBuilder(new FormLayout("pref:grow, 3dlu, pref:grow, 3dlu, default"));
            panelBuilder.addRowFull(false, (Component)this.mSearchForm);
            this.mFilterCheckbox = new JCheckBox(LOCALIZER.msg("useFilter", "Use filter:"));
            panelBuilder.addRow(this.mFilterCheckbox, 1);
            this.mFilterCombo = new JComboBox();
            panelBuilder.add(this.mFilterCombo, 3);
            for (ProgramFilter filter : availableFilter = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
                if (!FilterFavorite.filterIsAcceptable(filter)) continue;
                ((DefaultComboBoxModel)this.mFilterCombo.getModel()).addElement(new WrapperFilter(filter));
            }
            this.mEditFilter = new JButton(SelectFilterDlg.LOCALIZER.msg("title", "Edit Filters"));
            this.mEditFilter.addActionListener(e -> {
                SelectFilterDlg filterDlg = SelectFilterDlg.create(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
                filterDlg.setVisible(true);
                WrapperFilter selected = (WrapperFilter)this.mFilterCombo.getSelectedItem();
                ((DefaultComboBoxModel)this.mFilterCombo.getModel()).removeAllElements();
                ProgramFilter[] availableFilter1 = Plugin.getPluginManager().getFilterManager().getAvailableFilters();
                int selectedIndex = -1;
                int index = 0;
                for (ProgramFilter filter : availableFilter1) {
                    if (!FilterFavorite.filterIsAcceptable(filter)) continue;
                    if (selected.getFilter().equals(filter) || selected.getFilter().getName().equals(filter.getName())) {
                        selectedIndex = index;
                    }
                    ((DefaultComboBoxModel)this.mFilterCombo.getModel()).addElement(new WrapperFilter(filter));
                    ++index;
                }
                if (selectedIndex != -1) {
                    this.mFilterCombo.setSelectedIndex(selectedIndex);
                }
            });
            panelBuilder.add(this.mEditFilter, CC.xy((int)5, (int)3));
            if (AdvancedFavorite.this.mFilter != null) {
                this.mFilterCheckbox.setSelected(true);
                this.mFilterCombo.setSelectedItem(new WrapperFilter(AdvancedFavorite.this.mFilter));
            } else {
                this.mFilterCombo.setEnabled(false);
                this.mEditFilter.setEnabled(false);
            }
            this.mFilterCheckbox.addActionListener(e -> {
                this.mFilterCombo.setEnabled(this.mFilterCheckbox.isSelected());
                this.mEditFilter.setEnabled(this.mFilterCheckbox.isSelected());
            });
            return panelBuilder.getPanel();
        }

        @Override
        public void save() {
            SearchFormSettings settings = this.mSearchForm.getSearchFormSettings();
            AdvancedFavorite.this.mSearchFormSettings.setCaseSensitive(settings.getCaseSensitive());
            AdvancedFavorite.this.mSearchFormSettings.setNrDays(settings.getNrDays());
            AdvancedFavorite.this.mSearchFormSettings.setSearcherType(settings.getSearcherType());
            AdvancedFavorite.this.mSearchFormSettings.setSearchIn(settings.getSearchIn());
            AdvancedFavorite.this.mSearchFormSettings.setSearchText(settings.getSearchText());
            AdvancedFavorite.this.mSearchFormSettings.setUserDefinedFieldTypes(settings.getUserDefinedFieldTypes());
            FavoritesPlugin.getInstance().setDefaultProgramFieldTypeSelection(settings.getUserDefaultFieldTypes());
            if (this.mFilterCheckbox.isSelected()) {
                AdvancedFavorite.this.mFilter = ((WrapperFilter)this.mFilterCombo.getSelectedItem()).getFilter();
                AdvancedFavorite.this.mFilterName = AdvancedFavorite.this.mFilter.getName();
                if (!FilterFavorite.filterIsAcceptable(AdvancedFavorite.this.mFilter)) {
                    AdvancedFavorite.this.mFilter = null;
                    AdvancedFavorite.this.mFilterName = null;
                }
            } else {
                AdvancedFavorite.this.mFilter = null;
                AdvancedFavorite.this.mFilterName = null;
            }
        }

        @Override
        public boolean check() {
            if (this.mSearchForm.getSearchFormSettings().getSearchText().equals("")) {
                JOptionPane.showMessageDialog(this.mSearchForm, LOCALIZER.msg("missingSearchText.message", "Please specify a search text for the favorite!"), LOCALIZER.msg("missingSearchText.title", "Invalid search options"), 2);
                return false;
            }
            return true;
        }
    }
}

