/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.common;

import devplugin.Channel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import tvbrowser.core.Settings;
import tvbrowser.extras.common.ChannelItem;
import util.i18n.Localizer;

public class LimitationConfiguration {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(LimitationConfiguration.class);
    public static final int DAYLIMIT_DAILY = -1;
    public static final int DAYLIMIT_WEEKEND = -2;
    public static final int DAYLIMIT_WEEKDAY = -3;
    public static final int DAYLIMIT_SUNDAY = 1;
    public static final int DAYLIMIT_MONDAY = 2;
    public static final int DAYLIMIT_TUESDAY = 3;
    public static final int DAYLIMIT_WEDNESDAY = 4;
    public static final int DAYLIMIT_THURSDAY = 5;
    public static final int DAYLIMIT_FRIDAY = 6;
    public static final int DAYLIMIT_SATURDAY = 7;
    public static final DayLimitValue[] DAYLIMIT_VALUE_ARRAY = new DayLimitValue[10];
    private int mFrom;
    private int mTo;
    private Channel[] mChannelArr;
    private ArrayList<ChannelItem> mChannelItemList = new ArrayList();
    private boolean mIsLimitedByChannel;
    private boolean mIsLimitedByTime;
    private int mDayLimit;

    public LimitationConfiguration(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.mIsLimitedByTime = in.readBoolean();
        if (this.mIsLimitedByTime) {
            this.mFrom = in.readInt();
            this.mTo = in.readInt();
        }
        this.mIsLimitedByChannel = in.readBoolean();
        if (this.mIsLimitedByChannel) {
            int cnt = in.readInt();
            ArrayList<Channel> list = new ArrayList<Channel>();
            for (int i = 0; i < cnt; ++i) {
                ChannelItem item = new ChannelItem(in, version);
                this.mChannelItemList.add(item);
                if (item.getChannel() == null) continue;
                list.add(item.getChannel());
            }
            this.mChannelArr = list.toArray(new Channel[0]);
        }
        this.mDayLimit = in.readInt();
    }

    public LimitationConfiguration() {
        this.mDayLimit = -1;
    }

    public void store(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeBoolean(this.mIsLimitedByTime);
        if (this.mIsLimitedByTime) {
            out.writeInt(this.mFrom);
            out.writeInt(this.mTo);
        }
        out.writeBoolean(this.mIsLimitedByChannel);
        if (this.mIsLimitedByChannel) {
            out.writeInt(this.mChannelItemList.size());
            for (int i = 0; i < this.mChannelItemList.size(); ++i) {
                this.mChannelItemList.get(i).saveItem(out);
            }
        }
        out.writeInt(this.mDayLimit);
    }

    public void setTime(int from, int to) {
        this.mFrom = from;
        this.mTo = to;
        this.mIsLimitedByTime = true;
    }

    public int getTimeFrom() {
        return this.mFrom;
    }

    public int getTimeTo() {
        return this.mTo;
    }

    public void setChannels(Channel[] ch) {
        this.mChannelItemList.clear();
        for (Channel element : ch) {
            this.mChannelItemList.add(new ChannelItem(element));
        }
        this.mChannelArr = ch;
        this.mIsLimitedByChannel = true;
    }

    public Channel[] getChannels() {
        return this.mChannelArr;
    }

    public boolean isLimitedByChannel() {
        return this.mIsLimitedByChannel;
    }

    public boolean isLimitedByTime() {
        return this.mIsLimitedByTime;
    }

    public void setIsLimitedByChannel(boolean b) {
        this.mIsLimitedByChannel = b;
    }

    public void setIsLimitedByTime(boolean b) {
        this.mIsLimitedByTime = b;
    }

    public void setDayLimit(int daylimit) {
        this.mDayLimit = daylimit;
    }

    public int getDayLimit() {
        return this.mDayLimit;
    }

    public DayLimitValue getDayLimitValue() {
        return new DayLimitValue(this.mDayLimit);
    }

    public void reValidateChannels() {
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        for (ChannelItem item : this.mChannelItemList) {
            item.reValidate();
            if (item.isNullChannel()) continue;
            channelList.add(item.getChannel());
        }
        this.mChannelArr = channelList.toArray(new Channel[channelList.size()]);
    }

    public static String getDayString(int dayOfWeek) {
        String str;
        switch (dayOfWeek) {
            case -1: {
                str = LOCALIZER.msg("day.daily", "Daily");
                break;
            }
            case -3: {
                str = LOCALIZER.msg("day.weekday", "weekday");
                break;
            }
            case -2: {
                str = LOCALIZER.msg("day.weekend", "weekend");
                break;
            }
            case 2: {
                str = LOCALIZER.msg("day.monday", "monday");
                break;
            }
            case 3: {
                str = LOCALIZER.msg("day.tuesday", "tuesday");
                break;
            }
            case 4: {
                str = LOCALIZER.msg("day.wednesday", "wednesday");
                break;
            }
            case 5: {
                str = LOCALIZER.msg("day.thursday", "thursday");
                break;
            }
            case 6: {
                str = LOCALIZER.msg("day.friday", "friday");
                break;
            }
            case 7: {
                str = LOCALIZER.msg("day.saturday", "saturday");
                break;
            }
            case 1: {
                str = LOCALIZER.msg("day.sunday", "sunday");
                break;
            }
            default: {
                str = "<unknown>";
            }
        }
        return str;
    }

    static {
        LimitationConfiguration.DAYLIMIT_VALUE_ARRAY[0] = new DayLimitValue(-1);
        LimitationConfiguration.DAYLIMIT_VALUE_ARRAY[1] = new DayLimitValue(-2);
        LimitationConfiguration.DAYLIMIT_VALUE_ARRAY[2] = new DayLimitValue(-3);
        ArrayList<DayLimitValue> dayList = new ArrayList<DayLimitValue>(7);
        dayList.add(new DayLimitValue(1));
        dayList.add(new DayLimitValue(2));
        dayList.add(new DayLimitValue(3));
        dayList.add(new DayLimitValue(4));
        dayList.add(new DayLimitValue(5));
        dayList.add(new DayLimitValue(6));
        dayList.add(new DayLimitValue(7));
        int firstDayOfWeek = Settings.Locales.FIRST_DAY_OF_WEEK.getInt() - 1;
        int index = 3;
        while (dayList.size() > firstDayOfWeek) {
            LimitationConfiguration.DAYLIMIT_VALUE_ARRAY[index++] = (DayLimitValue)dayList.remove(firstDayOfWeek);
        }
        for (DayLimitValue day : dayList) {
            LimitationConfiguration.DAYLIMIT_VALUE_ARRAY[index++] = day;
        }
    }

    public static final class DayLimitValue {
        private final int mDay;
        private final String mText;

        public DayLimitValue(int day) {
            this.mDay = day;
            this.mText = LimitationConfiguration.getDayString(day);
        }

        public int getDay() {
            return this.mDay;
        }

        public String toString() {
            return this.mText;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DayLimitValue) {
                return ((DayLimitValue)obj).mDay == this.mDay;
            }
            return super.equals(obj);
        }
    }
}

