/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.settings;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import tvbrowser.core.Settings;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;

public final class PluginSettings {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(PluginSettings.class);
    private static final Logger LOG = Logger.getLogger(PluginSettings.class.getName());

    private static boolean readDataInternal(File file, Data data, boolean throwError) throws TvBrowserException {
        boolean result;
        block7: {
            result = false;
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), 16384));){
                data.readData(in);
                result = true;
            }
            catch (Throwable thr) {
                if (!throwError) break block7;
                throw new TvBrowserException(data.getClass(), "error.data.load", "Loading data for plugin {0} failed.\n({1})", (Object)data.toString(), (Object)file.getAbsolutePath(), thr);
            }
        }
        return result;
    }

    public static void readData(Data data) throws TvBrowserException {
        boolean dataBackupExists;
        File userDirectory = new File(Settings.getUserSettingsDirName());
        File datFile = new File(userDirectory, data.getBaseFileName() + ".dat");
        File datFileBackup = new File(userDirectory, data.getBaseFileName() + ".dat_old");
        boolean dataExists = datFile.isFile() && datFile.length() > 0L;
        boolean bl = dataBackupExists = datFileBackup.isFile() && datFileBackup.length() > 0L;
        if (dataExists) {
            if (!PluginSettings.readDataInternal(datFile, data, !dataBackupExists) && dataBackupExists) {
                LOG.severe("Data file '" + datFile.getAbsolutePath() + "' could not be read. Read old file instead: '" + datFileBackup.getAbsolutePath() + "'.");
                PluginSettings.readDataInternal(datFileBackup, data, true);
            }
        } else if (dataBackupExists) {
            PluginSettings.readDataInternal(datFileBackup, data, true);
        }
    }

    public static void writeData(Data data, boolean log) throws TvBrowserException {
        File userDirectory = new File(Settings.getUserSettingsDirName());
        if (!userDirectory.isDirectory()) {
            userDirectory.mkdirs();
        }
        if (log) {
            LOG.info("Storing plugin settings for " + data.toString() + "...");
        }
        File tmpDatFile = new File(userDirectory, data.getBaseFileName() + ".dat.temp");
        File oldDatFile = new File(userDirectory, data.getBaseFileName() + ".dat_old");
        if (tmpDatFile.isFile()) {
            tmpDatFile.delete();
        }
        boolean success = false;
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(tmpDatFile));){
            data.writeData(out);
            success = true;
        }
        catch (Throwable thr) {
            throw new TvBrowserException(data.getClass(), "error.data.write", "Saving data for plugin {0} failed.\n({1})", (Object)data.toString(), (Object)tmpDatFile.getAbsolutePath(), thr);
        }
        if (success && tmpDatFile.isFile()) {
            File datFile = new File(userDirectory, data.getBaseFileName() + ".dat");
            if (oldDatFile.isFile()) {
                oldDatFile.delete();
            }
            if (datFile.isFile()) {
                datFile.renameTo(oldDatFile);
            }
            tmpDatFile.renameTo(datFile);
        }
    }

    private static String getExtensionFor(Preferences settings) {
        String result = ".prop";
        if (settings instanceof TvDataServiceProxy) {
            result = ".service";
        }
        return result;
    }

    public static boolean storeSettings(Preferences settings) {
        boolean result = false;
        Properties prop = settings.storeSettings();
        if (prop != null) {
            String dir = Settings.getUserSettingsDirName();
            File propFile = new File(dir);
            if (!propFile.exists()) {
                propFile.mkdir();
            }
            propFile = new File(dir, settings.getBaseFileName() + PluginSettings.getExtensionFor(settings));
            File oldPropFile = new File(propFile.getAbsolutePath() + "_old");
            File tmpPropFile = new File(propFile.getAbsolutePath() + "_temp");
            if (tmpPropFile.isFile()) {
                tmpPropFile.delete();
            }
            boolean success = false;
            try (FileOutputStream outputStream = new FileOutputStream(tmpPropFile);){
                prop.store(outputStream, "Settings for plugin " + settings.toString());
                success = true;
            }
            catch (IOException exc) {
                String msg = LOCALIZER.msg("error.write", "Saving settings for plugin {0} failed!\n({1})", settings.toString(), propFile.getAbsolutePath(), exc);
                ErrorHandler.handle(msg, exc);
            }
            if (success && tmpPropFile.isFile() && tmpPropFile.length() > 0L) {
                result = true;
                if (oldPropFile.isFile()) {
                    oldPropFile.delete();
                }
                if (propFile.isFile()) {
                    propFile.renameTo(oldPropFile);
                }
                tmpPropFile.renameTo(propFile);
            }
        }
        return result;
    }

    public static void loadSettings(Preferences settings) {
        boolean propBackupExists;
        File propFile = new File(Settings.getUserSettingsDirName(), settings.getBaseFileName() + PluginSettings.getExtensionFor(settings));
        File oldPropFile = new File(propFile.getAbsolutePath() + "_old");
        boolean propExists = propFile.exists() && propFile.length() > 0L;
        boolean bl = propBackupExists = oldPropFile.exists() && oldPropFile.length() > 0L;
        if (propExists) {
            if (PluginSettings.loadProperties(propFile, settings, !propBackupExists) == null && propBackupExists) {
                PluginSettings.loadProperties(oldPropFile, settings, true);
            }
        } else if (propBackupExists) {
            PluginSettings.loadProperties(oldPropFile, settings, true);
        } else {
            settings.loadSettings(new Properties());
        }
    }

    private static Properties loadProperties(File file, Preferences settings, boolean handleError) {
        Properties p;
        block8: {
            p = new Properties();
            try {
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 4096);){
                    p.load(in);
                }
                settings.loadSettings(p);
            }
            catch (IOException exc) {
                p = null;
                if (!handleError) break block8;
                String msg = LOCALIZER.msg("error.load", "Loading settings for plugin {0} failed!\n({1})", settings.toString(), file.getAbsolutePath(), exc);
                ErrorHandler.handle(msg, exc);
            }
        }
        return p;
    }

    public static interface Data {
        public boolean hasToSaveSettings();

        public void readData(ObjectInputStream var1) throws IOException, ClassNotFoundException;

        public void writeData(ObjectOutputStream var1) throws IOException;

        public String getBaseFileName();

        public String toString();
    }

    public static interface Preferences {
        public void loadSettings(Properties var1);

        public Properties storeSettings();

        public String getBaseFileName();

        public String toString();

        public boolean hasToSaveSettings();
    }
}

