/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.i18n.Localizer;
import util.ui.DefaultMarkingPrioritySelectionPanel;
import util.ui.MarkPriorityComboBoxRenderer;

public class ProgramMarkingPriorityFilterComponent
extends AbstractFilterComponent {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramMarkingPriorityFilterComponent.class);
    private int mMarkPriority = 0;
    private JComboBox<String> mValueSelection;

    public ProgramMarkingPriorityFilterComponent() {
        this("", "");
    }

    public ProgramMarkingPriorityFilterComponent(String name, String desc) {
        super(name, desc);
    }

    @Override
    public boolean accept(Program program) {
        return program.getMarkPriorityMax() == this.mMarkPriority;
    }

    @Override
    public JPanel getSettingsPanel() {
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)new FormLayout("default", "pref"));
        String[] values = DefaultMarkingPrioritySelectionPanel.getMarkingColorNames(false);
        this.mValueSelection = new JComboBox<String>(values);
        this.mValueSelection.setSelectedIndex(this.mMarkPriority);
        this.mValueSelection.setRenderer(new MarkPriorityComboBoxRenderer());
        p.add(this.mValueSelection, cc.xy(1, 1));
        return p;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mMarkPriority = in.readInt();
    }

    @Override
    public void saveSettings() {
        if (this.mValueSelection != null) {
            this.mMarkPriority = this.mValueSelection.getSelectedIndex();
        }
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mMarkPriority);
    }

    public String toString() {
        return LOCALIZER.msg("name", "Marking priority");
    }
}

