/*
 * Decompiled with CFR 0.152.
 */
package newsplugin;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import newsplugin.News;
import newsplugin.NewsPlugin;
import util.browserlauncher.Launch;
import util.io.IOUtilities;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.html.ExtendedHTMLDocument;
import util.ui.html.ExtendedHTMLEditorKit;

public class NewsDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(NewsDialog.class);
    private static Icon mNewIcon;
    private JDialog mDialog;
    private JCheckBox mOnlyNewChB;
    private JComboBox mNewsTypeSelection;
    private JScrollPane mScrollPane;
    private JEditorPane mNewsPane;
    private JButton mCloseBn;
    private ArrayList<News> mNewsList;
    private int mNewNewsCount;
    private boolean mShowOnlyNew;
    private boolean mHasNews = false;
    private JCheckBox mSafeSettings;

    public NewsDialog(Window parent, ArrayList<News> newsList, int newNewsCount, boolean showOnlyNew, int newsTypeIndex) {
        this.mShowOnlyNew = showOnlyNew;
        this.mDialog = UiUtilities.createDialog((Component)parent, (boolean)false);
        this.mDialog.setDefaultCloseOperation(0);
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewsDialog.this.close();
            }
        });
        this.mNewsList = newsList;
        this.mNewNewsCount = newNewsCount;
        this.mDialog.setTitle(mLocalizer.msg("title", "News"));
        UiUtilities.registerForClosing((WindowClosingIf)this);
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(UiUtilities.DIALOG_BORDER);
        main.setPreferredSize(new Dimension(500, 350));
        this.mDialog.setContentPane(main);
        this.mNewsTypeSelection = new JComboBox();
        this.mNewsTypeSelection.addItem(mLocalizer.msg("type.all", "All"));
        this.mNewsTypeSelection.addItem(mLocalizer.msg("type.tvbrowser", "TV-Browser"));
        this.mNewsTypeSelection.addItem(mLocalizer.msg("type.desktop", "Only for TV-Browser for desktop"));
        this.mNewsTypeSelection.addItem(mLocalizer.msg("type.android", "Only for TV-Browser for Android"));
        this.mNewsTypeSelection.addItem(mLocalizer.msg("type.website", "Website"));
        this.mNewsTypeSelection.setSelectedIndex(newsTypeIndex);
        this.mNewsTypeSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewsDialog.this.updateNewsPane();
            }
        });
        this.mSafeSettings = new JCheckBox(mLocalizer.msg("safeSettings", "Save selection"), false);
        JPanel settings = new JPanel((LayoutManager)new FormLayout("default,3dlu,default:grow,default", "default,3dlu,default,3dlu,default,2dlu"));
        settings.add((Component)new JLabel(mLocalizer.msg("type", "News type:")), CC.xy((int)1, (int)1));
        settings.add((Component)this.mNewsTypeSelection, CC.xyw((int)3, (int)1, (int)2));
        settings.add((Component)this.mSafeSettings, CC.xy((int)4, (int)5));
        if (this.mNewNewsCount > 0) {
            String msg = mLocalizer.msg("onlyNew", "Show only new news");
            this.mOnlyNewChB = new JCheckBox(msg, showOnlyNew);
            this.mOnlyNewChB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewsDialog.this.mShowOnlyNew = NewsDialog.this.mOnlyNewChB.isSelected();
                    NewsDialog.this.updateNewsPane();
                }
            });
            settings.add((Component)this.mOnlyNewChB, CC.xyw((int)1, (int)3, (int)3));
        }
        main.add((Component)settings, "North");
        this.mNewsPane = new JEditorPane();
        this.mNewsPane.setEditorKit((EditorKit)new ExtendedHTMLEditorKit());
        this.mNewsPane.setEditable(false);
        this.mNewsPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = evt.getURL();
                    if (url != null) {
                        if (url.toString().startsWith("index.php")) {
                            try {
                                url = new URL("https://www.tvbrowser.org/" + url.toString());
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                        Launch.openURL((String)url.toString());
                    } else if (evt.getDescription() != null && evt.getDescription().startsWith("tvb://")) {
                        final String link = evt.getDescription();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                System.out.println(link);
                                Launch.openURL((String)link);
                            }
                        });
                        NewsDialog.this.close();
                    }
                }
            }
        });
        this.mNewsPane.setBackground(UIManager.getColor("List.background"));
        this.mScrollPane = new JScrollPane(this.mNewsPane);
        main.add((Component)this.mScrollPane, "Center");
        JPanel buttonPn = new JPanel(new FlowLayout(4));
        main.add((Component)buttonPn, "South");
        this.mCloseBn = new JButton(Localizer.getLocalization((String)"i18n_close"));
        this.mCloseBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewsDialog.this.close();
            }
        });
        buttonPn.add(this.mCloseBn);
        this.mDialog.getRootPane().setDefaultButton(this.mCloseBn);
        this.mCloseBn.requestFocusInWindow();
        NewsPlugin.getInstance().layoutWindow("newsDlg", this.mDialog);
        this.updateNewsPane();
    }

    private void updateNewsPane() {
        ExtendedHTMLDocument doc = (ExtendedHTMLDocument)this.mNewsPane.getDocument();
        this.mNewsPane.setText(this.createHtmlText(doc));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewsDialog.this.mScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    public void show() {
        this.mDialog.setVisible(true);
    }

    private String createHtmlText(ExtendedHTMLDocument doc) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        StringBuilder buf = new StringBuilder("<html><head><style type=\"text/css\" media=\"screen\"><!--body { font-family: Dialog; color: " + NewsDialog.getCssRgbColorEntry(UIManager.getColor("List.foreground")) + "; }" + "td.time { font-size: small; font-style: italic; }" + "td.title { font-weight: bold; }" + "td.author { text-align: right; font-style: italic; }" + "td.spacer { border-bottom: 1px solid black; }" + "--></style>" + "</head><body style=\"background:" + NewsDialog.getCssRgbColorEntry(UIManager.getColor("List.background")) + "\">");
        if (this.mNewsList.size() == 0) {
            buf.append("<p align=\"center\">");
            buf.append(mLocalizer.msg("no.news", "There are no news..."));
            buf.append("</p>");
        } else {
            if (mNewIcon == null) {
                mNewIcon = TVBrowserIcons.newIcon((int)22);
            }
            StringBuilder newsText = new StringBuilder();
            int newsCount = this.mNewsList.size();
            int i = 0;
            while (i < newsCount) {
                if (this.mOnlyNewChB != null && this.mOnlyNewChB.isSelected() && i >= this.mNewNewsCount) break;
                News news = this.mNewsList.get(i);
                String acceptedNewsType = "All";
                switch (this.mNewsTypeSelection.getSelectedIndex()) {
                    case 1: {
                        acceptedNewsType = "TV-Browser";
                        break;
                    }
                    case 2: {
                        acceptedNewsType = "Desktop";
                        break;
                    }
                    case 3: {
                        acceptedNewsType = "Android";
                        break;
                    }
                    case 4: {
                        acceptedNewsType = "Website";
                    }
                }
                if (news.isAcceptableType(acceptedNewsType)) {
                    if (i != 0) {
                        newsText.append("<hr>");
                    }
                    newsText.append("<table width=\"100%\">");
                    newsText.append("<tr>");
                    if (i < this.mNewNewsCount) {
                        newsText.append("<td rowspan=\"4\" width=\"30\" valign=\"top\">");
                        JLabel iconLabel = new JLabel(mNewIcon);
                        iconLabel.setToolTipText(mLocalizer.msg("newNews", "This news is new"));
                        newsText.append(doc.createCompTag((Component)iconLabel));
                        newsText.append("</td>");
                    }
                    newsText.append("<td class=\"time\">" + dateFormat.format(news.getTime()) + ":</td></tr>");
                    newsText.append("<tr><td class=\"title\">" + news.getTitle() + "</td></tr>");
                    String text = news.getText();
                    text = IOUtilities.replace((String)text, (String)"&lt;", (String)"<");
                    text = IOUtilities.replace((String)text, (String)"&gt;", (String)">");
                    text = IOUtilities.replace((String)text, (String)"/>", (String)">");
                    if (text.startsWith("<p>")) {
                        text = text.substring(3);
                    }
                    if (text.endsWith("</p>")) {
                        text = text.substring(0, text.length() - 3);
                    }
                    text = IOUtilities.replace((String)text, (String)"<p>", (String)"<br>");
                    text = IOUtilities.replace((String)text, (String)"</p>", (String)"<br>");
                    newsText.append("<tr><td class=\"text\">" + text + "</td></tr>");
                    newsText.append("<tr><td class=\"author\">" + news.getAuthor() + "</td></tr>");
                    newsText.append("</table>");
                }
                ++i;
            }
            buf.append((CharSequence)newsText);
            this.mHasNews = newsText.toString().trim().length() > 0;
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    public boolean hasNews() {
        return this.mHasNews;
    }

    public void close() {
        NewsPlugin.getInstance().saveMeInternal(this.mSafeSettings.isSelected(), this.mShowOnlyNew, this.mNewsTypeSelection.getSelectedIndex());
        this.mDialog.dispose();
    }

    public boolean isVisible() {
        return this.mDialog != null && this.mDialog.isVisible();
    }

    public JRootPane getRootPane() {
        return this.mDialog.getRootPane();
    }

    private static String getCssRgbColorEntry(Color c) {
        StringBuilder builder = new StringBuilder("rgb(");
        builder.append(c.getRed());
        builder.append(",");
        builder.append(c.getGreen());
        builder.append(",");
        builder.append(c.getBlue());
        builder.append(")");
        return builder.toString();
    }
}

