/*
 * Decompiled with CFR 0.152.
 */
package compat;

import devplugin.ProgramFilter;
import devplugin.Version;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import tvbrowser.TVBrowser;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import tvbrowser.ui.filter.dlgs.EditFilterComponentDlg;

public final class FilterCompat {
    private static FilterCompat INSTANCE;
    private ArrayList<FilterChangeListener> mListListeners;

    private FilterCompat() {
        INSTANCE = this;
        this.mListListeners = new ArrayList();
        try {
            String clazzName = null;
            if (TVBrowser.VERSION.compareTo(new Version(3, 34, true)) >= 0) {
                clazzName = "devplugin.FilterChangeListenerV2";
            } else if (TVBrowser.VERSION.compareTo(new Version(3, 33, true)) >= 0) {
                clazzName = "devplugin.FilterChangeListener";
            }
            if (clazzName != null) {
                Class<?> filterListenerClass = Class.forName(clazzName);
                Method addFilterListener = FilterManagerImpl.class.getDeclaredMethod("registerFilterChangeListener", filterListenerClass);
                Object filterListener = Proxy.newProxyInstance(filterListenerClass.getClassLoader(), new Class[]{filterListenerClass}, (InvocationHandler)new HandlerFilterListener(this));
                addFilterListener.invoke((Object)FilterManagerImpl.getInstance(), filterListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final synchronized FilterCompat getInstance() {
        if (INSTANCE == null) {
            new FilterCompat();
        }
        return INSTANCE;
    }

    public static String[] getChannelFilterComponentNames() {
        String[] result = new String[]{};
        if (TVBrowser.VERSION.compareTo(new Version(3, 21, true)) >= 0) {
            try {
                Method m = FilterManagerImpl.class.getDeclaredMethod("getChannelFilterComponentNames", new Class[0]);
                result = (String[])m.invoke((Object)FilterManagerImpl.getInstance(), new Object[0]);
            }
            catch (Exception exception) {}
        } else {
            result = FilterCompat.getChannelFilterComponentNamesCompat();
        }
        return result;
    }

    public static String addNewChannelFilterComponent() {
        String result = null;
        if (TVBrowser.VERSION.compareTo(new Version(3, 21, true)) >= 0) {
            try {
                Method m = FilterManagerImpl.class.getDeclaredMethod("addNewChannelFilterComponent", new Class[0]);
                result = (String)m.invoke((Object)FilterManagerImpl.getInstance(), new Object[0]);
            }
            catch (Exception exception) {}
        } else {
            result = FilterCompat.addNewChannelFilterComponentCompat();
        }
        return result;
    }

    public void registerFilterChangeListener(FilterChangeListener listener) {
        if (!this.mListListeners.contains(listener)) {
            this.mListListeners.add(listener);
        }
    }

    public void unregisterFilterChangeListener(FilterChangeListener listener) {
        this.mListListeners.remove(listener);
    }

    private void handleFilterEvent(String method, ProgramFilter filter) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!"filterAdded".equals(method)) break block4;
                        for (FilterChangeListener l : this.mListListeners) {
                            l.filterAdded(filter);
                        }
                        break block5;
                    }
                    if (!"filterRemoved".equals(method)) break block6;
                    for (FilterChangeListener l : this.mListListeners) {
                        l.filterRemoved(filter);
                    }
                    break block5;
                }
                if (!"filterTouched".equals(method)) break block7;
                for (FilterChangeListener l : this.mListListeners) {
                    l.filterTouched(filter);
                }
                break block5;
            }
            if (!"filterDefaultChanged".equals(method)) break block5;
            for (FilterChangeListener l : this.mListListeners) {
                l.filterDefaultChanged(filter);
            }
        }
    }

    private static String[] getChannelFilterComponentNamesCompat() {
        return FilterComponentList.getInstance().getChannelFilterNames();
    }

    private static String addNewChannelFilterComponentCompat() {
        EditFilterComponentDlg dlg = new EditFilterComponentDlg(null, null, ChannelFilterComponent.class);
        FilterComponent rule = dlg.getFilterComponent();
        if (rule == null) {
            return null;
        }
        if (!(rule instanceof ChannelFilterComponent)) {
            return null;
        }
        FilterComponentList.getInstance().add(rule);
        FilterComponentList.getInstance().store();
        return rule.getName();
    }

    public static interface FilterChangeListener {
        public void filterAdded(ProgramFilter var1);

        public void filterRemoved(ProgramFilter var1);

        public void filterTouched(ProgramFilter var1);

        public void filterDefaultChanged(ProgramFilter var1);
    }

    private static final class HandlerFilterListener
    implements InvocationHandler {
        private FilterCompat mFilterCompat;

        private HandlerFilterListener(FilterCompat filterCompat) {
            this.mFilterCompat = filterCompat;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method != null && args != null && args.length == 1) {
                this.mFilterCompat.handleFilterEvent(method.getName(), (ProgramFilter)args[0]);
            }
            return null;
        }
    }
}

