// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

using System.Runtime.Serialization;

namespace System.Management.Automation
{
    /// <summary>
    /// This is a wrapper for exception class
    /// <see cref="System.ArgumentOutOfRangeException"/>
    /// which provides additional information via
    /// <see cref="System.Management.Automation.IContainsErrorRecord"/>.
    /// </summary>
    /// <remarks>
    /// Instances of this exception class are usually generated by the
    /// PowerShell Engine.  It is unusual for code outside the PowerShell Engine
    /// to create an instance of this class.
    /// </remarks>
    public class PSArgumentOutOfRangeException
            : ArgumentOutOfRangeException, IContainsErrorRecord
    {
        #region ctor
        /// <summary>
        /// Constructor for class PSArgumentOutOfRangeException.
        /// </summary>
        /// <returns>Constructed object.</returns>
        public PSArgumentOutOfRangeException()
            : base()
        {
        }

        /// <summary>
        /// Initializes a new instance of the PSArgumentOutOfRangeException class.
        /// </summary>
        /// <param name="paramName"></param>
        /// <returns>Constructed object.</returns>
        /// <remarks>
        /// Per MSDN, the parameter is paramName and not message.
        /// I confirm this experimentally as well.
        /// </remarks>
        public PSArgumentOutOfRangeException(string paramName)
                : base(paramName)
        {
        }

        /// <summary>
        /// Initializes a new instance of the PSArgumentOutOfRangeException class.
        /// </summary>
        /// <param name="paramName"></param>
        /// <param name="actualValue"></param>
        /// <param name="message"></param>
        /// <returns>Constructed object.</returns>
        /// <remarks>
        /// ArgumentOutOfRangeException has this ctor form and we imitate it here.
        /// </remarks>
        public PSArgumentOutOfRangeException(string paramName, object actualValue, string message)
                : base(paramName, actualValue, message)
        {
        }

        #region Serialization
        /// <summary>
        /// Initializes a new instance of the PSArgumentOutOfRangeException class
        /// using data serialized via
        /// <see cref="System.Runtime.Serialization.ISerializable"/>
        /// </summary>
        /// <param name="info">Serialization information.</param>
        /// <param name="context">Streaming context.</param>
        /// <returns>Constructed object.</returns>
        [Obsolete("Legacy serialization support is deprecated since .NET 8", DiagnosticId = "SYSLIB0051")] 
        protected PSArgumentOutOfRangeException(SerializationInfo info,
                           StreamingContext context)
        {
            throw new NotSupportedException();
        }
        
        #endregion Serialization

        /// <summary>
        /// Initializes a new instance of the PSArgumentOutOfRangeException class.
        /// </summary>
        /// <param name="message"></param>
        /// <param name="innerException"></param>
        /// <returns>Constructed object.</returns>
        public PSArgumentOutOfRangeException(string message,
                                              Exception innerException)
                : base(message, innerException)
        {
        }
        #endregion ctor

        /// <summary>
        /// Additional information about the error.
        /// </summary>
        /// <value></value>
        /// <remarks>
        /// Note that ErrorRecord.Exception is
        /// <see cref="System.Management.Automation.ParentContainsErrorRecordException"/>.
        /// </remarks>
        public ErrorRecord ErrorRecord
        {
            get
            {
                _errorRecord ??= new ErrorRecord(
                    new ParentContainsErrorRecordException(this),
                    _errorId,
                    ErrorCategory.InvalidArgument,
                    null);

                return _errorRecord;
            }
        }

        private ErrorRecord _errorRecord;
        private readonly string _errorId = "ArgumentOutOfRange";
    }
}
