#include "Rivet/AnalysisHandler.hh"
#include "Rivet/Tools/RivetHepMC.hh"
#include <fstream>

using namespace std;

//int main(int argc, char* argv[]) {
int main() {
  //assert(argc > 1);

  Rivet::AnalysisHandler ah;
  Rivet::Log::setLevel("Rivet", Rivet::Log::DEBUG);

  // Specify the analyses to be used
  ah.addAnalysis("EXAMPLE");
  ah.addAnalyses({{ "MC_JETS", "EXAMPLE_CUTS", "EXAMPLE_SMEAR" }});

  auto reader = Rivet::RivetHepMC::deduce_reader("testAPI.hepmc");
  std::shared_ptr<Rivet::GenEvent> evt = make_shared<Rivet::GenEvent>();
  double sum_of_weights = 0.0;
  while ( Rivet::HepMCUtils::readEvent(reader, evt) ) {
    // Analyse current event
    ah.analyze(*evt);
    sum_of_weights += evt->weights()[0];
  }
  (void)sum_of_weights; // suppress unused variable warning

  ah.setCrossSection(make_pair(1.0, 0.1));

  ah.finalize();
  ah.writeData("out.yoda");

  return 0;
}
