// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief eta_c production at 7,8 TeV
  class LHCB_2015_I1316329 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(LHCB_2015_I1316329);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      declare(UnstableParticles(), "UFS");

      for (double eVal : allowedEnergies()) {
        const int en = round(eVal);
        if (isCompatibleWithSqrtS(eVal))  _sqs = en;

        int ih = int(en==8000)+1;
        for (size_t ix=0; ix<2; ++ix) {
          book(_h_etac[en+ix], ih+2*ix, 1, 1);
        }
      }
      raiseBeamErrorIf(_sqs==0);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {

      // Final state of unstable particles to get particle spectra
      const UnstableParticles& ufs = apply<UnstableParticles>(event, "UFS");

      for (const Particle& p : ufs.particles(Cuts::pid==441)) {
        // prompt/non-prompt
        bool nonPrompt = p.fromBottom();
        double absrap = p.absrap();
        double xp = p.perp();
        if (absrap>2. && absrap<4.5) {
          _h_etac[_sqs+nonPrompt]->fill(xp);
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      // 1/2 due rapidity folding +/-
      scale(_h_etac, 0.5*crossSection()/nanobarn/sumOfWeights());
    }

    /// @}


    /// @name Histograms
    /// @{
    map<int,Histo1DPtr> _h_etac;
    int _sqs = 0;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(LHCB_2015_I1316329);

}
