// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief Add a short analysis description here
  class BESIII_2024_I2824162 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BESIII_2024_I2824162);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      UnstableParticles ufs = UnstableParticles(Cuts::abspid==411);
      declare(ufs, "UFS");
      DecayedParticles DD(ufs);
      DD.addStable(PID::PI0);
      DD.addStable(PID::K0S);
      declare(DD, "DD");
      // histograms
      for (unsigned int ix=0; ix<2; ++ix) {
        book(_h[ix], 1, 1, 1+ix);
      }
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      DecayedParticles DD = apply<DecayedParticles>(event, "DD");
      // loop over particles
      for (unsigned int ix=0; ix<DD.decaying().size(); ++ix) {
      	int sign = DD.decaying()[ix].pid()/DD.decaying()[ix].abspid();
      	if ( !DD.modeMatches(ix,3,mode) && !DD.modeMatches(ix,3,modeCC)) continue;
        const Particles & K0S  = DD.decayProducts()[ix].at(PID::K0S);
        const Particle  & pip = DD.decayProducts()[ix].at( sign*211)[0];
        _h[0]->fill((K0S[0].mom()+K0S[1].mom()).mass2());
        _h[1]->fill((K0S[0].mom()+pip.mom()).mass2());
        _h[1]->fill((K0S[1].mom()+pip.mom()).mass2());
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      normalize(_h);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[2];
    const map<PdgId,unsigned int> mode   = { {PID::K0S,2}, { 211,1} };
    const map<PdgId,unsigned int> modeCC = { {PID::K0S,2}, {-211,1} };
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BESIII_2024_I2824162);

}
