/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import com.kreative.unicode.ttflib.NameEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameTable {
    private List<NameEntry> names;

    public NameTable(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public NameTable(byte[] byArray) throws IOException {
        this.read(byArray);
    }

    private void read(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        this.read(byteArrayOutputStream.toByteArray());
    }

    private void read(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.readData(dataInputStream);
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    private void readData(DataInputStream dataInputStream) throws IOException {
        this.names = new ArrayList<NameEntry>();
        dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            NameEntry nameEntry = new NameEntry();
            nameEntry.readHead(dataInputStream);
            this.names.add(nameEntry);
        }
        for (NameEntry nameEntry : this.names) {
            nameEntry.readBody(dataInputStream, n2);
        }
        this.names = Collections.unmodifiableList(this.names);
    }

    public List<NameEntry> getNames() {
        return this.names;
    }

    public String getName(int n) {
        String string = null;
        for (NameEntry nameEntry : this.names) {
            if (!nameEntry.isEnglish() || nameEntry.getNameId() != n || string != null && nameEntry.getName().length() >= string.length()) continue;
            string = nameEntry.getName();
        }
        return string;
    }
}

