/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import java.io.DataInputStream;
import java.io.IOException;

public class NameEntry {
    private int platformId;
    private int encodingId;
    private int languageId;
    private int nameId;
    private int length;
    private int offset;
    private byte[] data;
    private String name;

    NameEntry() {
    }

    void readHead(DataInputStream dataInputStream) throws IOException {
        this.platformId = dataInputStream.readUnsignedShort();
        this.encodingId = dataInputStream.readUnsignedShort();
        this.languageId = dataInputStream.readUnsignedShort();
        this.nameId = dataInputStream.readUnsignedShort();
        this.length = dataInputStream.readUnsignedShort();
        this.offset = dataInputStream.readUnsignedShort();
    }

    void readBody(DataInputStream dataInputStream, int n) throws IOException {
        dataInputStream.reset();
        dataInputStream.skipBytes(n + this.offset);
        byte[] byArray = new byte[this.length];
        dataInputStream.readFully(byArray);
        this.data = byArray;
        this.name = this.platformId == 0 || this.platformId == 2 || this.platformId == 10 ? new String(byArray, "UTF-16BE") : (this.platformId == 3 && (this.encodingId == 1 || this.encodingId == 10) ? new String(byArray, "UTF-16BE") : (this.platformId == 1 && this.encodingId == 0 ? new String(byArray, "MacRoman") : null));
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public int getEncodingId() {
        return this.encodingId;
    }

    public int getLanguageId() {
        return this.languageId;
    }

    public int getNameId() {
        return this.nameId;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnglish() {
        switch (this.platformId) {
            case 0: {
                return true;
            }
            case 1: {
                return this.encodingId == 0 && this.languageId == 0;
            }
            case 2: {
                return true;
            }
            case 3: {
                return (this.encodingId == 1 || this.encodingId == 10) && this.languageId == 1033;
            }
            case 10: {
                return true;
            }
        }
        return false;
    }
}

