/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import java.io.DataInputStream;
import java.io.IOException;

public class DfontResource {
    private int id;
    private int attributes;
    private int nameOffset;
    private int dataOffset;
    private String name;
    private byte[] data;

    DfontResource() {
    }

    void readHead(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readShort();
        this.nameOffset = dataInputStream.readShort();
        int n = dataInputStream.readInt();
        this.attributes = n >> 24;
        this.dataOffset = n & 0xFFFFFF;
        dataInputStream.readInt();
    }

    void readBody(DataInputStream dataInputStream, int n, int n2, int n3) throws IOException {
        byte[] byArray;
        int n4;
        if (this.nameOffset < 0) {
            this.name = null;
        } else {
            dataInputStream.reset();
            dataInputStream.skipBytes(n2 + n3 + this.nameOffset);
            n4 = dataInputStream.readUnsignedByte();
            byArray = new byte[n4];
            dataInputStream.readFully(byArray);
            this.name = new String(byArray, "MacRoman");
        }
        dataInputStream.reset();
        dataInputStream.skipBytes(n + this.dataOffset);
        n4 = dataInputStream.readInt();
        if (n4 < 0) {
            n4 = 0;
        }
        byArray = new byte[n4];
        dataInputStream.readFully(byArray);
        this.data = byArray;
    }

    public int getId() {
        return this.id;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }
}

