/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.Block;
import com.kreative.unicode.data.PuaaCache;
import com.kreative.unicode.data.UnicodeUtils;
import com.kreative.unicode.ttflib.PuaaEntry;
import com.kreative.unicode.ttflib.PuaaTable;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockList
extends AbstractList<Block> {
    private static BlockList instance = null;
    private final List<Block> blocks;

    public static BlockList instance() {
        if (instance == null) {
            instance = new BlockList();
        }
        return instance;
    }

    private BlockList() {
        String[] stringArray;
        TreeSet<Block> treeSet = new TreeSet<Block>();
        BlockList.readTextStream(BlockList.class.getResourceAsStream("roadmap.txt"), treeSet);
        BlockList.readPuaaTable(PuaaCache.getPuaaTable("unidata.ucd"), treeSet);
        for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            Font font = new Font(string, 0, 12);
            PuaaTable puaaTable = PuaaCache.getPuaaTable(font);
            if (puaaTable == null) continue;
            BlockList.readPuaaTable(puaaTable, treeSet);
        }
        BlockList.readDirectory(UnicodeUtils.getTableDirectory("Blocks"), treeSet);
        this.blocks = Arrays.asList(treeSet.toArray(new Block[treeSet.size()]));
    }

    private static void readDirectory(File file, Collection<Block> collection) {
        for (File file2 : file.listFiles()) {
            if (file2.getName().startsWith(".") || file2.getName().endsWith("\r")) continue;
            if (file2.isDirectory()) {
                BlockList.readDirectory(file2, collection);
                continue;
            }
            String string = file2.getName().toLowerCase();
            if (string.endsWith(".ucd") || string.endsWith(".ttf") || string.endsWith(".otf")) {
                BlockList.readPuaaTable(PuaaCache.getPuaaTable(file2), collection);
                continue;
            }
            if (!string.endsWith(".txt")) continue;
            try {
                BlockList.readTextStream(new FileInputStream(file2), collection);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void readTextStream(InputStream inputStream, Collection<Block> collection) {
        Scanner scanner = new Scanner(inputStream);
        while (scanner.hasNextLine()) {
            String[] stringArray;
            String string = scanner.nextLine().trim();
            if (string.length() <= 0 || string.charAt(0) == '#' || (stringArray = string.split(";")).length != 2) continue;
            String string2 = stringArray[1].trim();
            String[] stringArray2 = stringArray[0].split("[.]+");
            if (stringArray2.length != 2) continue;
            try {
                int n = Integer.parseInt(stringArray2[0], 16);
                int n2 = Integer.parseInt(stringArray2[1], 16);
                collection.add(new Block(n, n2, string2));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        scanner.close();
    }

    private static void readPuaaTable(PuaaTable puaaTable, Collection<Block> collection) {
        List<PuaaEntry> list;
        if (puaaTable != null && (list = puaaTable.getPropertyEntries("Block")) != null && list.size() > 0) {
            for (PuaaEntry puaaEntry : list) {
                int n = puaaEntry.getFirstCodePoint();
                int n2 = puaaEntry.getLastCodePoint();
                String string = puaaEntry.getPropertyString(n);
                collection.add(new Block(n, n2, string));
            }
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.blocks.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.blocks.containsAll(collection);
    }

    @Override
    public Block get(int n) {
        return this.blocks.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.blocks.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    @Override
    public Iterator<Block> iterator() {
        return this.blocks.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.blocks.lastIndexOf(object);
    }

    @Override
    public ListIterator<Block> listIterator() {
        return this.blocks.listIterator();
    }

    @Override
    public ListIterator<Block> listIterator(int n) {
        return this.blocks.listIterator(n);
    }

    @Override
    public int size() {
        return this.blocks.size();
    }

    @Override
    public List<Block> subList(int n, int n2) {
        return this.blocks.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.blocks.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.blocks.toArray(TArray);
    }
}

