/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.SbixEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SbixSubtable
extends ArrayList<SbixEntry> {
    private static final long serialVersionUID = 1L;
    public static final int DPI_DEFAULT = 72;
    public int ppem = 0;
    public int dpi = 72;

    private void compile(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeShort(this.ppem);
        dataOutputStream.writeShort(this.dpi);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n2 = 4 + (this.size() + 1) * 4;
        for (Object object : this) {
            dataOutputStream.writeInt(n2);
            byte[] byArray = ((SbixEntry)object).compile();
            arrayList.add(byArray);
            n2 += byArray.length;
        }
        dataOutputStream.writeInt(n2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (byte[])iterator.next();
            dataOutputStream.write((byte[])object);
        }
        while ((n2 & 3) != 0) {
            dataOutputStream.writeByte(0);
            ++n2;
        }
    }

    public byte[] compile(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.compile(dataOutputStream, n);
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void decompile(DataInputStream dataInputStream, int n, int n2) throws IOException {
        int n3;
        this.ppem = dataInputStream.readUnsignedShort();
        this.dpi = dataInputStream.readUnsignedShort();
        int[] nArray = new int[n2 + 1];
        for (n3 = 0; n3 <= n2; ++n3) {
            nArray[n3] = dataInputStream.readInt();
        }
        this.clear();
        for (n3 = 0; n3 < n2; ++n3) {
            dataInputStream.reset();
            dataInputStream.skipBytes(nArray[n3]);
            byte[] byArray = new byte[nArray[n3 + 1] - nArray[n3]];
            dataInputStream.readFully(byArray);
            SbixEntry sbixEntry = new SbixEntry();
            sbixEntry.decompile(byArray);
            this.add(sbixEntry);
        }
    }

    public void decompile(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.decompile(dataInputStream, byArray.length, n);
        dataInputStream.close();
        byteArrayInputStream.close();
    }
}

