/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnihanCodec
extends PuaaCodec {
    protected final String fileName;
    protected final List<String> propNames;

    protected AbstractUnihanCodec(String string, List<String> list) {
        this.fileName = string;
        this.propNames = list;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propNames.toArray(new String[this.propNames.size()]);
    }

    @Override
    public void compile(PuaaTable puaaTable, Scanner scanner) {
        Object object;
        List<PuaaSubtableEntry> list;
        HashMap hashMap = new HashMap();
        while (scanner.hasNextLine()) {
            String[] stringArray;
            list = scanner.nextLine().trim();
            if (((String)((Object)list)).length() == 0 || ((String)((Object)list)).startsWith("#") || (stringArray = ((String)((Object)list)).split("\\s+", 3)).length < 3) continue;
            try {
                Map<Integer, String> map;
                int n = Integer.parseInt(stringArray[0].replaceAll("^([Uu][+]|[0][Xx])", ""), 16);
                object = stringArray[1];
                String string = stringArray[2];
                if (hashMap.containsKey(object)) {
                    map = (Map)hashMap.get(object);
                    map.put(n, string);
                    continue;
                }
                map = new HashMap();
                map.put(n, string);
                hashMap.put(object, map);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = puaaTable.getOrCreateSubtable((String)entry.getKey());
            list = AbstractUnihanCodec.toDecimalEntries((Map)entry.getValue());
            if (list != null) {
                ((ArrayList)object).addAll(list);
                continue;
            }
            list = AbstractUnihanCodec.toHexadecimalEntries((Map)entry.getValue());
            if (list != null) {
                ((ArrayList)object).addAll(list);
                continue;
            }
            ((ArrayList)object).addAll(PuaaUtility.createEntriesFromNameMap((Map)entry.getValue()));
        }
    }

    @Override
    public void decompile(PuaaTable puaaTable, PrintWriter printWriter) {
        Object object;
        Object object2;
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (String object3 : this.propNames) {
            object2 = puaaTable.getSubtable(object3);
            if (object2 == null || ((ArrayList)object2).isEmpty()) continue;
            for (Map.Entry<Integer, String> entry : PuaaUtility.createMapFromEntries((List<? extends PuaaSubtableEntry>)object2).entrySet()) {
                if (treeMap.containsKey(entry.getKey())) {
                    object = (Map)treeMap.get(entry.getKey());
                    object.put(object3, entry.getValue());
                    continue;
                }
                object = new TreeMap<String, String>();
                object.put(object3, entry.getValue());
                treeMap.put(entry.getKey(), object);
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            object2 = "U+" + PuaaUtility.toHexString((Integer)entry.getKey());
            for (String string : this.propNames) {
                object = (String)((Map)entry.getValue()).get(string);
                if (object == null || ((String)object).length() == 0) continue;
                printWriter.println((String)object2 + "\t" + string + "\t" + (String)object);
            }
        }
    }

    private static List<PuaaSubtableEntry> toDecimalEntries(Map<Integer, String> map) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            try {
                int n = Integer.parseInt(entry.getValue(), 10);
                if (Integer.toString(n).equals(entry.getValue())) {
                    hashMap.put(entry.getKey(), n);
                    continue;
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return PuaaUtility.createEntriesFromDecimalMap(hashMap);
    }

    private static List<PuaaSubtableEntry> toHexadecimalEntries(Map<Integer, String> map) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            try {
                int n = Integer.parseInt(entry.getValue(), 16);
                if (PuaaUtility.toHexString(n).equals(entry.getValue())) {
                    hashMap.put(entry.getKey(), n);
                    continue;
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return PuaaUtility.createEntriesFromHexadecimalMap(hashMap);
    }
}

