/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.importer.NFNTBitmapFontImporter;
import com.kreative.bitsnpicas.mover.KeyboardFrame;
import com.kreative.bitsnpicas.mover.MoverFile;
import com.kreative.bitsnpicas.mover.MoverInfoPanel;
import com.kreative.bitsnpicas.mover.MoverTableModel;
import com.kreative.bitsnpicas.mover.ResourceBundle;
import com.kreative.bitsnpicas.mover.ResourceSelection;
import com.kreative.bitsnpicas.mover.SoundFrame;
import com.kreative.bitsnpicas.mover.TrueTypeFrame;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceFile;
import com.kreative.rsrc.MacResourceProvider;
import com.kreative.rsrc.SoundResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoverTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final MoverInfoPanel ip;

    public MoverTable(MoverTableModel moverTableModel, MoverInfoPanel moverInfoPanel) {
        super(moverTableModel);
        this.setColumnWidth(0, 40);
        this.setColumnWidth(2, 100);
        this.setColumnWidth(4, 100);
        this.setDefaultRenderer(ImageIcon.class, new MyIconRenderer());
        this.setDefaultRenderer(Integer.class, new MyCellRenderer());
        this.setDefaultRenderer(String.class, new MyCellRenderer());
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setRowHeight(19);
        this.ip = moverInfoPanel;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    MoverTable.this.doOpen();
                }
            }
        });
        InputMap inputMap = this.getInputMap();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        inputMap.put(KeyStroke.getKeyStroke(88, n), "Cut");
        inputMap.put(KeyStroke.getKeyStroke(67, n), "Copy");
        inputMap.put(KeyStroke.getKeyStroke(86, n), "Paste");
        inputMap.put(KeyStroke.getKeyStroke(127, n), "Clear");
        inputMap.put(KeyStroke.getKeyStroke(8, n), "Clear");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("Cut", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                MoverTable.this.doCut();
            }
        });
        actionMap.put("Copy", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                MoverTable.this.doCopy();
            }
        });
        actionMap.put("Paste", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                MoverTable.this.doPaste();
            }
        });
        actionMap.put("Clear", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                MoverTable.this.doClear();
            }
        });
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 1, new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                if (dragGestureEvent.getDragOrigin().x < 40) {
                    List<ResourceBundle> list = MoverTable.this.getSelectedItems();
                    if (list.isEmpty()) {
                        return;
                    }
                    dragGestureEvent.startDrag(null, new ResourceSelection(list));
                }
            }
        });
    }

    public void createDropTarget(JComponent jComponent) {
        new DropTarget(jComponent, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                block14: {
                    if (MoverTable.this.ip.readOnly()) {
                        return;
                    }
                    try {
                        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        DataFlavor dataFlavor = ResourceSelection.resourceFlavor;
                        if (transferable.isDataFlavorSupported(dataFlavor)) {
                            List list = (List)transferable.getTransferData(dataFlavor);
                            if (list != null && !list.isEmpty()) {
                                MoverTableModel moverTableModel = MoverTable.this.getMoverModel();
                                MoverFile moverFile = moverTableModel.getMoverFile();
                                for (Object e : list) {
                                    moverFile.add((ResourceBundle)e);
                                }
                                moverTableModel.refresh();
                                dropTargetDropEvent.dropComplete(true);
                            } else {
                                dropTargetDropEvent.dropComplete(false);
                            }
                            break block14;
                        }
                        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            if (list != null && !list.isEmpty()) {
                                for (Object e : list) {
                                    try {
                                        MoverTable.this.addFromFile(MacUtility.getResourceFork((File)e));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    try {
                                        MoverTable.this.addFromFile((File)e);
                                    }
                                    catch (Exception exception) {}
                                }
                                dropTargetDropEvent.dropComplete(true);
                                break block14;
                            }
                            dropTargetDropEvent.dropComplete(false);
                            break block14;
                        }
                        dropTargetDropEvent.dropComplete(false);
                    }
                    catch (Exception exception) {
                        dropTargetDropEvent.dropComplete(false);
                    }
                }
            }
        });
    }

    public MoverTableModel getMoverModel() {
        return (MoverTableModel)this.getModel();
    }

    public List<ResourceBundle> getSelectedItems() {
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        MoverFile moverFile = this.getMoverModel().getMoverFile();
        for (int n : this.getSelectedRows()) {
            arrayList.add(moverFile.get(n));
        }
        return arrayList;
    }

    public void addFromFile(File file) throws IOException {
        if (this.ip.readOnly()) {
            return;
        }
        MoverTableModel moverTableModel = this.getMoverModel();
        MoverFile moverFile = moverTableModel.getMoverFile();
        MacResourceFile macResourceFile = new MacResourceFile(file, "r", 0);
        MoverFile moverFile2 = new MoverFile((MacResourceProvider)macResourceFile);
        int n = moverFile2.size();
        for (int i = 0; i < n; ++i) {
            moverFile.add(moverFile2.get(i));
        }
        macResourceFile.close();
        moverTableModel.refresh();
    }

    public void doOpen() {
        List<ResourceBundle> list = this.getSelectedItems();
        if (list.isEmpty()) {
            return;
        }
        for (ResourceBundle resourceBundle : list) {
            if (resourceBundle.moverType.equals("ffil")) {
                try {
                    BitmapFont[] bitmapFontArray = new NFNTBitmapFontImporter(this.ip.getSelectedEncoding()).importFont(resourceBundle);
                    Main.openFonts(null, null, bitmapFontArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (resourceBundle.moverType.equals("tfil")) {
                for (MacResource macResource : resourceBundle.resources) {
                    try {
                        new TrueTypeFrame(macResource.data).setVisible(true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (FontFormatException fontFormatException) {
                        fontFormatException.printStackTrace();
                    }
                }
            }
            if (resourceBundle.moverType.equals("sfil")) {
                for (MacResource macResource : resourceBundle.resources) {
                    SoundResource soundResource = (SoundResource)macResource.shallowRecast(SoundResource.class);
                    new SoundFrame(soundResource).setVisible(true);
                }
            }
            if (!resourceBundle.moverType.equals("kfil")) continue;
            for (MacResource macResource : resourceBundle.resources) {
                if (macResource.type != 1262700626) continue;
                new KeyboardFrame(macResource, this.ip.getSelectedEncoding()).setVisible(true);
            }
        }
    }

    public void doCut() {
        if (this.ip.readOnly()) {
            return;
        }
        this.doCopy();
        this.doClear();
    }

    public void doCopy() {
        List<ResourceBundle> list = this.getSelectedItems();
        if (list.isEmpty()) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new ResourceSelection(list), new ClipboardOwner(){

            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        });
    }

    public void doPaste() {
        DataFlavor dataFlavor;
        if (this.ip.readOnly()) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(dataFlavor = ResourceSelection.resourceFlavor)) {
            try {
                List list = (List)clipboard.getData(dataFlavor);
                if (list == null || list.isEmpty()) {
                    return;
                }
                MoverTableModel moverTableModel = this.getMoverModel();
                MoverFile moverFile = moverTableModel.getMoverFile();
                for (Object e : list) {
                    moverFile.add((ResourceBundle)e);
                }
                moverTableModel.refresh();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void doClear() {
        if (this.ip.readOnly()) {
            return;
        }
        MoverTableModel moverTableModel = this.getMoverModel();
        MoverFile moverFile = moverTableModel.getMoverFile();
        for (ResourceBundle resourceBundle : this.getSelectedItems()) {
            moverFile.remove(resourceBundle);
        }
        moverTableModel.refresh();
    }

    private void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    private static class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final Border padding = BorderFactory.createEmptyBorder(0, 4, 0, 4);

        private MyCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jComponent instanceof JLabel) {
                ((JLabel)jComponent).setHorizontalAlignment(n2 == 2 ? 4 : 2);
            }
            jComponent.setBorder(BorderFactory.createCompoundBorder(jComponent.getBorder(), padding));
            return jComponent;
        }
    }

    private static class MyIconRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final Border padding = BorderFactory.createEmptyBorder(0, 12, 0, 0);

        private MyIconRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jComponent.setBorder(BorderFactory.createCompoundBorder(jComponent.getBorder(), padding));
            if (jComponent instanceof JLabel) {
                JLabel jLabel = (JLabel)jComponent;
                jLabel.setHorizontalAlignment(0);
                jLabel.setIcon((Icon)object);
                jLabel.setText(null);
            }
            return jComponent;
        }
    }
}

