/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontGlyphTransformer;
import com.kreative.bitsnpicas.GlyphPair;
import com.kreative.bitsnpicas.IDGenerator;
import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.PointSizeGenerator;
import com.kreative.bitsnpicas.main.BitmapInputFormat;
import com.kreative.bitsnpicas.main.BitmapInputOptions;
import com.kreative.bitsnpicas.main.BitmapOutputFormat;
import com.kreative.bitsnpicas.main.BitmapOutputOptions;
import com.kreative.bitsnpicas.transformer.BoldBitmapFontGlyphTransformer;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertBitmap {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray.length == 0) {
            ConvertBitmap.printHelp();
        } else {
            boolean bl = true;
            Options options = new Options();
            String string = null;
            String string2 = null;
            int n = 0;
            while (n < stringArray.length) {
                Object object;
                Object object2;
                String string3 = stringArray[n++];
                if (bl && string3.startsWith("-")) {
                    if (string3.equals("--")) {
                        bl = false;
                        continue;
                    }
                    if (string3.equals("-s") && n < stringArray.length) {
                        string = stringArray[n++];
                        if (string2 == null) continue;
                        options.nameSearchReplace.add(new SearchReplacePattern(string, string2));
                        string = null;
                        string2 = null;
                        continue;
                    }
                    if (string3.equals("-r") && n < stringArray.length) {
                        string2 = stringArray[n++];
                        if (string == null) continue;
                        options.nameSearchReplace.add(new SearchReplacePattern(string, string2));
                        string = null;
                        string2 = null;
                        continue;
                    }
                    if (string3.equals("-t") && n < stringArray.length) {
                        options.timestampCodepoint = ConvertBitmap.parseInt16(stringArray[n++]);
                        continue;
                    }
                    if (string3.equals("-sr") && n < stringArray.length) {
                        File file = new File(stringArray[n++]);
                        try {
                            Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "utf-8");
                            while (scanner.hasNextLine()) {
                                object2 = scanner.nextLine().trim();
                                int n2 = ((String)object2).indexOf(35);
                                if (n2 >= 0) {
                                    object2 = ((String)object2).substring(0, n2).trim();
                                }
                                if (((String)object2).length() == 0 || (object = ConvertBitmap.parseGlyphPair((String)object2)) == null) continue;
                                options.subsetRemap.add((GlyphPair)object);
                            }
                            scanner.close();
                        }
                        catch (IOException iOException) {
                            System.err.println("Failed to read subsetRemap: " + file.getName());
                        }
                        continue;
                    }
                    if (string3.equals("-d") && n < stringArray.length) {
                        Integer n3;
                        String string4;
                        String[] stringArray2;
                        object2 = (stringArray2 = (string4 = stringArray[n++]).split("-", 2)).length > 0 ? ConvertBitmap.parseInt16(stringArray2[0]) : null;
                        Integer n4 = n3 = stringArray2.length > 1 ? ConvertBitmap.parseInt16(stringArray2[1]) : null;
                        if (object2 != null && n3 != null) {
                            options.codePointsToRemove.set(Math.min((Integer)object2, n3), Math.max((Integer)object2, n3) + 1);
                            continue;
                        }
                        if (object2 != null) {
                            options.codePointsToRemove.set((Integer)object2);
                            continue;
                        }
                        if (n3 != null) {
                            options.codePointsToRemove.set(n3);
                            continue;
                        }
                        if (string4.length() <= 0) continue;
                        options.glyphNamesToRemove.add(string4);
                        continue;
                    }
                    if (string3.equals("-D") && n < stringArray.length) {
                        Integer n5;
                        String string5;
                        String[] stringArray3;
                        object2 = (stringArray3 = (string5 = stringArray[n++]).split("-", 2)).length > 0 ? ConvertBitmap.parseInt16(stringArray3[0]) : null;
                        Integer n6 = n5 = stringArray3.length > 1 ? ConvertBitmap.parseInt16(stringArray3[1]) : null;
                        if (object2 != null && n5 != null) {
                            options.codePointsToRemove.clear(Math.min((Integer)object2, n5), Math.max((Integer)object2, n5) + 1);
                            continue;
                        }
                        if (object2 != null) {
                            options.codePointsToRemove.clear((Integer)object2);
                            continue;
                        }
                        if (n5 != null) {
                            options.codePointsToRemove.clear(n5);
                            continue;
                        }
                        if (string5.length() <= 0) continue;
                        options.glyphNamesToRemove.remove(string5);
                        continue;
                    }
                    if (string3.equals("-c")) {
                        options.strictMonospace = true;
                        continue;
                    }
                    if (string3.equals("-C")) {
                        options.strictMonospace = false;
                        continue;
                    }
                    if (string3.equals("-n")) {
                        options.transform.clear();
                        continue;
                    }
                    if (string3.equals("-b")) {
                        options.transform.add(new BoldBitmapFontGlyphTransformer());
                        continue;
                    }
                    if (string3.equals("-o") && n < stringArray.length) {
                        options.dest = new File(stringArray[n++]);
                        continue;
                    }
                    if (string3.equals("-f") && n < stringArray.length) {
                        options.format = stringArray[n++];
                        continue;
                    }
                    if ((string3.equals("-w") || string3.equals("-x")) && n < stringArray.length) {
                        options.oo.xSize = ConvertBitmap.parseInt(stringArray[n++], 100);
                        continue;
                    }
                    if ((string3.equals("-h") || string3.equals("-y")) && n < stringArray.length) {
                        options.oo.ySize = ConvertBitmap.parseInt(stringArray[n++], 100);
                        continue;
                    }
                    if (string3.equals("-T")) {
                        options.oo.extendWinMetrics = false;
                        continue;
                    }
                    if (string3.equals("-Y")) {
                        options.oo.extendWinMetrics = true;
                        continue;
                    }
                    if (string3.equals("-p") && n < stringArray.length) {
                        String string6;
                        boolean bl2;
                        if (bl2 = ConvertBitmap.loadPreset(options, string6 = stringArray[n++])) continue;
                        System.err.println("Unknown preset: " + string6);
                        continue;
                    }
                    if (string3.equals("-i") && n < stringArray.length) {
                        int n7 = ConvertBitmap.parseInt(stringArray[n++], 0);
                        options.oo.idgen = new IDGenerator.Sequential(n7, 128, 32768);
                        continue;
                    }
                    if (string3.equals("-R")) {
                        options.oo.idgen = new IDGenerator.Random(128, 32768);
                        continue;
                    }
                    if (string3.equals("-H")) {
                        options.oo.idgen = new IDGenerator.HashCode(128, 32768);
                        continue;
                    }
                    if (string3.equals("-z") && n < stringArray.length) {
                        int n8 = ConvertBitmap.parseInt(stringArray[n++], 0);
                        options.oo.sizegen = new PointSizeGenerator.Fixed(n8);
                        continue;
                    }
                    if (string3.equals("-E")) {
                        options.oo.sizegen = new PointSizeGenerator.Automatic(4, 127);
                        continue;
                    }
                    if (string3.equals("-S")) {
                        options.oo.sizegen = new PointSizeGenerator.Standard(9, 10, 12, 14, 18, 24, 36, 48, 72);
                        continue;
                    }
                    if (string3.equals("-e") && n < stringArray.length) {
                        options.io.encodingName = options.oo.encodingName = stringArray[n++];
                        options.oo.fontxDoubleByte = false;
                        continue;
                    }
                    if (string3.equals("-ie") && n < stringArray.length) {
                        options.io.encodingName = stringArray[n++];
                        continue;
                    }
                    if (string3.equals("-oe") && n < stringArray.length) {
                        options.oo.encodingName = stringArray[n++];
                        options.oo.fontxDoubleByte = false;
                        continue;
                    }
                    if (string3.equals("-ee") && n < stringArray.length) {
                        options.io.fontxDoubleByteEncoding = options.oo.fontxDoubleByteEncoding = stringArray[n++];
                        options.oo.fontxDoubleByte = true;
                        continue;
                    }
                    if (string3.equals("-iee") && n < stringArray.length) {
                        options.io.fontxDoubleByteEncoding = stringArray[n++];
                        continue;
                    }
                    if (string3.equals("-oee") && n < stringArray.length) {
                        options.oo.fontxDoubleByteEncoding = stringArray[n++];
                        options.oo.fontxDoubleByte = true;
                        continue;
                    }
                    if (string3.equals("-le") && n < stringArray.length) {
                        options.io.psfLowEncoding = options.oo.psfLowEncoding = stringArray[n++];
                        options.oo.psfUseLowEncoding = options.oo.psfLowEncoding.length() > 0;
                        continue;
                    }
                    if (string3.equals("-he") && n < stringArray.length) {
                        options.io.psfHighEncoding = options.oo.psfHighEncoding = stringArray[n++];
                        options.oo.psfUseHighEncoding = options.oo.psfHighEncoding.length() > 0;
                        continue;
                    }
                    if (string3.equals("-ile") && n < stringArray.length) {
                        options.io.psfLowEncoding = stringArray[n++];
                        continue;
                    }
                    if (string3.equals("-ihe") && n < stringArray.length) {
                        options.io.psfHighEncoding = stringArray[n++];
                        continue;
                    }
                    if (string3.equals("-ole") && n < stringArray.length) {
                        options.oo.psfLowEncoding = stringArray[n++];
                        options.oo.psfUseLowEncoding = options.oo.psfLowEncoding.length() > 0;
                        continue;
                    }
                    if (string3.equals("-ohe") && n < stringArray.length) {
                        options.oo.psfHighEncoding = stringArray[n++];
                        options.oo.psfUseHighEncoding = options.oo.psfHighEncoding.length() > 0;
                        continue;
                    }
                    if (string3.equals("-pb") && n < stringArray.length) {
                        options.io.psfPuaBase = ConvertBitmap.parseInt16(stringArray[n++]);
                        continue;
                    }
                    if (string3.equals("-a") && n < stringArray.length) {
                        options.oo.u8mLoadAddress = ConvertBitmap.parseInt16(stringArray[n++]);
                        continue;
                    }
                    if (string3.equals("-m")) {
                        options.oo.geosMega = true;
                        continue;
                    }
                    if (string3.equals("-M")) {
                        options.oo.geosMega = false;
                        continue;
                    }
                    if (string3.equals("-k")) {
                        options.oo.geosKerning = true;
                        continue;
                    }
                    if (string3.equals("-K")) {
                        options.oo.geosKerning = false;
                        continue;
                    }
                    if (string3.equals("-u")) {
                        options.oo.geosUTF8 = true;
                        continue;
                    }
                    if (string3.equals("-U")) {
                        options.oo.geosUTF8 = false;
                        continue;
                    }
                    if (string3.equals("-pa")) {
                        options.oo.psfUseAllGlyphs = true;
                        continue;
                    }
                    if (string3.equals("-PA")) {
                        options.oo.psfUseAllGlyphs = false;
                        continue;
                    }
                    if (string3.equals("-pu")) {
                        options.oo.psfUnicodeTable = true;
                        continue;
                    }
                    if (string3.equals("-PU")) {
                        options.oo.psfUnicodeTable = false;
                        continue;
                    }
                    if (string3.equals("--help")) {
                        ConvertBitmap.printHelp();
                        continue;
                    }
                    System.err.println("Unknown option: " + string3);
                    continue;
                }
                try {
                    File file = new File(string3);
                    System.out.print("Converting " + file.getName() + "...");
                    BitmapInputFormat bitmapInputFormat = BitmapInputFormat.forFile(file);
                    if (bitmapInputFormat == null) {
                        System.out.println(" FAILED: Unknown input format.");
                        continue;
                    }
                    if (bitmapInputFormat.macResFork) {
                        file = MacUtility.getResourceFork(file);
                    }
                    if ((object2 = (BitmapFont[])bitmapInputFormat.createImporter(options.io).importFont(file)) == null || ((BitmapFont[])object2).length == 0) {
                        System.out.println(" FAILED: No fonts found.");
                        continue;
                    }
                    boolean bl3 = false;
                    object = object2;
                    int n9 = ((BitmapFont[])object).length;
                    for (int i = 0; i < n9; ++i) {
                        BitmapFont bitmapFont = object[i];
                        ConvertBitmap.transformFont(bitmapFont, options);
                        bitmapFont.contractGlyphs();
                        bitmapFont.autoFillNames();
                        String string7 = bitmapFont.getName(bitmapInputFormat.nameType);
                        boolean bl4 = ConvertBitmap.exportFont(bitmapFont, string7, options);
                        if (!bl4) continue;
                        bl3 = true;
                    }
                    if (bl3) {
                        System.out.println(" DONE");
                        continue;
                    }
                    System.out.println(" FAILED: Unknown output format.");
                }
                catch (IOException iOException) {
                    System.out.println(" FAILED: " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                }
            }
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  java -jar BitsNPicas.jar convertbitmap <options> <files>");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -s <regexp>   Regular expression to search for in the font name.");
        System.out.println("  -r <string>   Replacement text for <regexp> in the font name.");
        System.out.println("  -t <codept>   Generate a timestamp glyph at the specified code point.");
        System.out.println("  -sr <path>    Create a subset/remap glyphs according to a mapping file.");
        System.out.println("  -d <range>    Do not include characters in the specified range.");
        System.out.println("  -D <range>    Include characters in the specified range.");
        System.out.println("  -c            Strict monospace: remove glyphs not the width of a space.");
        System.out.println("  -C            Loose monospace or proportional; the opposite of -c.");
        System.out.println("  -n            Do not transform the font (the default).");
        System.out.println("  -b            Transform the font using faux bold.");
        System.out.println("  -o <path>     Write output to the specified file or directory.");
        System.out.println("  -f <format>   Set the output format. One of:");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BitmapOutputFormat bitmapOutputFormat : BitmapOutputFormat.values()) {
            for (String string : bitmapOutputFormat.ids) {
                arrayList.add(string);
            }
        }
        ConvertBitmap.printHelpList(arrayList);
        System.out.println("  -w <number>   Pixel width in em units (for ttf). Default: 100.");
        System.out.println("  -h <number>   Pixel height in em units (for ttf). Default: 100.");
        System.out.println("  -T            Use typo metrics for winAscent/winDescent (for ttf).");
        System.out.println("                (Force line height; more compatible. The default.)");
        System.out.println("  -Y            Use yMin/yMax for winAscent/winDescent (for ttf).");
        System.out.println("                (Prevent clipping; more conformant to the TT/OT spec.)");
        System.out.println("  -p <preset>   Use a preset for -s, -r, -w, and -h. One of:");
        System.out.println("                    none, apple2, apple2-40col, apple2-80col,");
        System.out.println("                    apple2-hgr, apple2-dhr, lisa, lisa-raw, lisa-2x3y,");
        System.out.println("                    iigs-320, iigs-640, iigs-320h, iigs-640h, atari,");
        System.out.println("                    atari-40col, atari-80col, commodore, commodore-20col,");
        System.out.println("                    commodore-40col, commodore-80col, trs80, trs80-64col,");
        System.out.println("                    trs80-32col, trs80-m1, trs80-m1-64col, trs80-m1-32col,");
        System.out.println("                    trs80-m2, trs80-m3, trs80-m3-64col, trs80-m3-32col,");
        System.out.println("                    trs80-m4, trs80-m4-64col, trs80-m4-32col,");
        System.out.println("                    trs80-m4-80col, trs80-m4-40col");
        System.out.println("  -i <number>   Font ID number (for nfnt or geos).");
        System.out.println("  -R            Use random ID number (for nfnt or geos).");
        System.out.println("  -H            Use ID number derived from font name (for nfnt or geos).");
        System.out.println("  -z <number>   Font point size (for nfnt or geos).");
        System.out.println("  -E            Use any point size (for nfnt or geos).");
        System.out.println("  -S            Use only standard point sizes (for nfnt or geos).");
        System.out.println("                    (9, 10, 12, 14, 18, 24, 36, 48, and 72 for nfnt,)");
        System.out.println("                    (9, 10, 12, 14, 18, 24, 36, 48, and 60 for geos.)");
        System.out.println("  -m / -M       Generate a MEGA / standard font (for geos).");
        System.out.println("  -k / -K       Generate / don't generate kerning tables (for geos).");
        System.out.println("  -u / -U       Generate / don't generate UTF-8 tables (for geos).");
        System.out.println("  -a <addr>     Add a loading address to the file (for u8m).");
        System.out.println("  -e <enc>      Use the specified encoding (for nfnt, fzx, sbf). One of:");
        System.out.println("  -ie <enc>     Use the specified encoding for reading only. One of:");
        System.out.println("  -oe <enc>     Use the specified encoding for writing only. One of:");
        ArrayList arrayList2 = new ArrayList();
        for (GlyphList glyphList : EncodingList.instance().glyphLists()) {
            arrayList2.add(glyphList.getName());
        }
        ConvertBitmap.printHelpList(arrayList2);
        System.out.println("  -ee <enc>     Use the specified double-byte encoding (for fontx).");
        System.out.println("  -iee <enc>    Use the specified double-byte encoding for reading only.");
        System.out.println("  -oee <enc>    Use the specified double-byte encoding for writing only.");
        System.out.println("  -le <enc>     Use the specified encoding for chars 000-0FF (for psf).");
        System.out.println("  -he <enc>     Use the specified encoding for chars 100-1FF (for psf).");
        System.out.println("  -ile <enc>    Use the specified encoding for chars 000-0FF for reading.");
        System.out.println("  -ihe <enc>    Use the specified encoding for chars 100-1FF for reading.");
        System.out.println("  -ole <enc>    Use the specified encoding for chars 000-0FF for writing.");
        System.out.println("  -ohe <enc>    Use the specified encoding for chars 100-1FF for writing.");
        System.out.println("  -pb <cp>      Read all glyphs in order starting at code point (for psf).");
        System.out.println("  -pa / -PA     Write / don't write other characters (for psf).");
        System.out.println("  -pu / -PU     Write / don't write Unicode mapping table (for psf).");
        System.out.println("  --            Process remaining arguments as file names.");
        System.out.println();
    }

    private static void printHelpList(List<String> list) {
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String string = " " + list.get(i);
            if (i < n2 - 1) {
                string = string + ",";
            }
            if (n + string.length() > 78) {
                System.out.println();
                n = 0;
            }
            if (n == 0) {
                System.out.print("                   ");
                n = 19;
            }
            System.out.print(string);
            n += string.length();
        }
        System.out.println();
    }

    private static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private static Integer parseInt16(String string) {
        try {
            if (string.startsWith("U+") || string.startsWith("u+")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.startsWith("0x") || string.startsWith("0X")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.startsWith("$")) {
                return Integer.parseInt(string.substring(1), 16);
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static GlyphPair parseGlyphPair(String string) {
        String[] stringArray = string.trim().split("\\s+");
        Integer n = ConvertBitmap.parseInt16(stringArray[0]);
        if (n != null) {
            if (stringArray.length > 1) {
                Integer n2 = ConvertBitmap.parseInt16(stringArray[1]);
                if (n2 != null) {
                    return new GlyphPair(n, n2);
                }
                if (stringArray[1].length() > 0) {
                    return new GlyphPair(n, stringArray[1]);
                }
            }
            return new GlyphPair(n, n);
        }
        if (stringArray[0].length() > 0) {
            if (stringArray.length > 1) {
                Integer n3 = ConvertBitmap.parseInt16(stringArray[1]);
                if (n3 != null) {
                    return new GlyphPair(stringArray[0], n3);
                }
                if (stringArray[1].length() > 0) {
                    return new GlyphPair(stringArray[0], stringArray[1]);
                }
            }
            return new GlyphPair(stringArray[0], stringArray[0]);
        }
        return null;
    }

    private static boolean loadPreset(Options options, String string) {
        if ((string = string.toLowerCase()).equals("") || string.equals("none")) {
            options.nameSearchReplace.clear();
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("apple2") || string.equals("apple2-40col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Apple II", "Print Char 21"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("apple2-80col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Apple II", "PR Number 3"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("apple2-hgr")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("II", "II HGR"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("apple2-dhr")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("II", "II DHR"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("lisa") || string.equals("lisa-2x3y")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "2X3Y"));
            options.oo.xSize = 80;
            options.oo.ySize = 120;
            return true;
        }
        if (string.equals("lisa-raw")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("2X3Y", "Raw"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("iigs-320")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Shaston", "Shaston 320"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("iigs-640")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Shaston", "Shaston 640"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("iigs-320h")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Shaston", "Shaston Hi 320"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("iigs-640h")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Shaston", "Shaston Hi 640"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("atari") || string.equals("atari-40col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Colleen", "Candy"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("atari-80col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Candy", "Colleen"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("commodore") || string.equals("commodore-40col")) {
            options.nameSearchReplace.clear();
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("commodore-20col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Pet.*$", "$0 2X"));
            options.oo.xSize = 200;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("commodore-80col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Pet.*$", "$0 2Y"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("trs80") || string.equals("trs80-64col") || string.equals("trs80-m1") || string.equals("trs80-m1-64col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "64C 2X3Y"));
            options.oo.xSize = 80;
            options.oo.ySize = 120;
            return true;
        }
        if (string.equals("trs80-32col") || string.equals("trs80-m1-32col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "32C 4X3Y"));
            options.oo.xSize = 160;
            options.oo.ySize = 120;
            return true;
        }
        if (string.equals("trs80-m2")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "2Y"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("trs80-m3") || string.equals("trs80-m3-64col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "64C"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("trs80-m3-32col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "32C"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        if (string.equals("trs80-m4") || string.equals("trs80-m4-64col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "64C"));
            options.oo.xSize = 100;
            options.oo.ySize = 160;
            return true;
        }
        if (string.equals("trs80-m4-32col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "32C"));
            options.oo.xSize = 100;
            options.oo.ySize = 80;
            return true;
        }
        if (string.equals("trs80-m4-80col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "80C"));
            options.oo.xSize = 100;
            options.oo.ySize = 200;
            return true;
        }
        if (string.equals("trs80-m4-40col")) {
            options.nameSearchReplace.clear();
            options.nameSearchReplace.add(new SearchReplacePattern("Raw", "40C"));
            options.oo.xSize = 100;
            options.oo.ySize = 100;
            return true;
        }
        return false;
    }

    private static void transformFont(BitmapFont bitmapFont, Options options) {
        if (!options.nameSearchReplace.isEmpty()) {
            for (Map.Entry entry : bitmapFont.names(true).entrySet()) {
                String string = (String)entry.getValue();
                for (SearchReplacePattern bitmapFontGlyphArray : options.nameSearchReplace) {
                    string = bitmapFontGlyphArray.replaceAll(string);
                }
                bitmapFont.setName((Integer)entry.getKey(), string);
            }
        }
        if (options.timestampCodepoint != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2) + 1;
            int n3 = gregorianCalendar.get(5);
            BitmapFontGlyph[] bitmapFontGlyphArray = new BitmapFontGlyph[]{(BitmapFontGlyph)bitmapFont.getCharacter(1113920 + n / 1000 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1113936 + n / 100 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1113952 + n / 10 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1113968 + n / 1 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1113984 + n2 / 10 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1114000 + n2 / 1 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1114016 + n3 / 10 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1114032 + n3 / 1 % 10), (BitmapFontGlyph)bitmapFont.getCharacter(1114048)};
            BitmapFontGlyph bitmapFontGlyph = BitmapFontGlyph.compose(bitmapFontGlyphArray);
            if (bitmapFontGlyph != null) {
                bitmapFont.putCharacter(options.timestampCodepoint, bitmapFontGlyph);
            }
        }
        if (!options.subsetRemap.isEmpty()) {
            bitmapFont.subsetRemap(options.subsetRemap);
        }
        if (!options.codePointsToRemove.isEmpty()) {
            int n = options.codePointsToRemove.nextSetBit(0);
            while (n >= 0) {
                bitmapFont.removeCharacter(n);
                n = options.codePointsToRemove.nextSetBit(n + 1);
            }
        }
        if (!options.glyphNamesToRemove.isEmpty()) {
            for (String string : options.glyphNamesToRemove) {
                bitmapFont.removeNamedGlyph(string);
            }
        }
        if (options.strictMonospace) {
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(32);
            int n = bitmapFontGlyph != null ? bitmapFontGlyph.getCharacterWidth() : 0;
            for (Map.Entry entry : bitmapFont.characters(true).entrySet()) {
                if (((BitmapFontGlyph)entry.getValue()).getCharacterWidth() == n) continue;
                bitmapFont.removeCharacter(entry.getKey());
            }
            for (Map.Entry entry : bitmapFont.namedGlyphs(true).entrySet()) {
                if (((BitmapFontGlyph)entry.getValue()).getCharacterWidth() == n) continue;
                bitmapFont.removeNamedGlyph((String)entry.getKey());
            }
        }
        for (BitmapFontGlyphTransformer bitmapFontGlyphTransformer : options.transform) {
            bitmapFont.transform(bitmapFontGlyphTransformer);
        }
    }

    private static boolean exportFont(BitmapFont bitmapFont, String string, Options options) throws IOException {
        String string2 = options.format.toLowerCase();
        for (BitmapOutputFormat bitmapOutputFormat : BitmapOutputFormat.values()) {
            for (String string3 : bitmapOutputFormat.ids) {
                if (!string2.equals(string3)) continue;
                File file = ConvertBitmap.getOutputFile(options.dest, string, bitmapOutputFormat.suffix);
                System.out.print(" to " + file.getName() + "...");
                BitmapFontExporter bitmapFontExporter = bitmapOutputFormat.createExporter(options.oo);
                if (bitmapOutputFormat.macResFork) {
                    file.createNewFile();
                    File file2 = MacUtility.getResourceFork(file);
                    bitmapFontExporter.exportFontToFile(bitmapFont, file2);
                } else {
                    bitmapFontExporter.exportFontToFile(bitmapFont, file);
                }
                bitmapOutputFormat.postProcess(file);
                return true;
            }
        }
        return false;
    }

    private static File getOutputFile(File file, String string, String string2) {
        if (file == null || file.isDirectory()) {
            string2 = ConvertBitmap.normalizeExtension(string2);
        } else {
            string = file.getName();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string2 = string.substring(n);
                string = string.substring(0, n);
            } else {
                string2 = "";
            }
            file = file.getParentFile();
        }
        File file2 = new File(file, string + string2);
        if (file2.exists()) {
            int n = 2;
            while ((file2 = new File(file, string + "-" + n++ + string2)).exists()) {
            }
        }
        return file2;
    }

    private static String normalizeExtension(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("") || string.startsWith(".")) {
            return string;
        }
        return "." + string;
    }

    private static class SearchReplacePattern {
        private final Pattern searchPattern;
        private final String replacePattern;

        public SearchReplacePattern(String string, String string2) {
            Pattern pattern;
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = Pattern.compile(Pattern.quote(string));
            }
            this.searchPattern = pattern;
            this.replacePattern = string2;
        }

        public String replaceAll(String string) {
            return this.searchPattern.matcher(string).replaceAll(this.replacePattern);
        }
    }

    private static class Options {
        public final BitmapInputOptions io = new BitmapInputOptions();
        public final BitmapOutputOptions oo = new BitmapOutputOptions();
        public List<SearchReplacePattern> nameSearchReplace = new ArrayList<SearchReplacePattern>();
        public Integer timestampCodepoint = null;
        public Set<GlyphPair> subsetRemap = new HashSet<GlyphPair>();
        public BitSet codePointsToRemove = new BitSet();
        public Set<String> glyphNamesToRemove = new HashSet<String>();
        public boolean strictMonospace = false;
        public List<BitmapFontGlyphTransformer> transform = new ArrayList<BitmapFontGlyphTransformer>();
        public File dest = null;
        public String format = "ttf";

        private Options() {
        }
    }
}

