/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.GlyphPair;
import com.kreative.bitsnpicas.PathExtensions;
import com.kreative.bitsnpicas.VectorFont;
import com.kreative.bitsnpicas.VectorFontGlyph;
import com.kreative.bitsnpicas.VectorFontImporter;
import com.kreative.bitsnpicas.VectorInstruction;
import com.kreative.bitsnpicas.VectorPath;
import com.kreative.bitsnpicas.XMLUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KpcaxVectorFontImporter
implements VectorFontImporter {
    private static final Pattern PATH_TOKEN = Pattern.compile("(ZZ|[A-Z])|([+-]?([0-9]+([.][0-9]*)?|[.][0-9]+)(E[+-]?[0-9]+)?)", 2);

    public VectorFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        VectorFont vectorFont = KpcaxVectorFontImporter.parse("<byte[]>", byteArrayInputStream);
        byteArrayInputStream.close();
        return new VectorFont[]{vectorFont};
    }

    public VectorFont[] importFont(InputStream inputStream) throws IOException {
        VectorFont vectorFont = KpcaxVectorFontImporter.parse("<InputStream>", inputStream);
        return new VectorFont[]{vectorFont};
    }

    public VectorFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        VectorFont vectorFont = KpcaxVectorFontImporter.parse(file.getName(), fileInputStream);
        fileInputStream.close();
        return new VectorFont[]{vectorFont};
    }

    private static VectorFont parse(String string, InputStream inputStream) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(XMLUtility.entityResolver("BitsNPicasVector", "kpcax.dtd", KpcaxVectorFontImporter.class));
            documentBuilder.setErrorHandler(XMLUtility.errorHandler(string));
            Document document = documentBuilder.parse(new InputSource(inputStream));
            return KpcaxVectorFontImporter.parseDocument(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    private static VectorFont parseDocument(Node node) throws IOException {
        String string = node.getNodeName();
        if (string.equalsIgnoreCase("#document")) {
            for (Node node2 : XMLUtility.getChildren(node)) {
                String string2 = node2.getNodeName();
                if (string2.equalsIgnoreCase("kpcas")) {
                    if (!node2.hasAttributes() && !node2.hasChildNodes()) continue;
                    return KpcaxVectorFontImporter.parseKpcas(node2);
                }
                throw new IOException("Unknown element: " + string2);
            }
            throw new IOException("Empty document.");
        }
        throw new IOException("Unknown element: " + string);
    }

    private static VectorFont parseKpcas(Node node) throws IOException {
        VectorFont vectorFont = new VectorFont();
        for (Node node2 : XMLUtility.getChildren(node)) {
            Object object;
            Object object2;
            String string = node2.getNodeName();
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (string.equalsIgnoreCase("prop")) {
                object2 = XMLUtility.parseString(namedNodeMap, "id");
                object = XMLUtility.parseDouble(namedNodeMap, "value");
                if ("emAscent".equalsIgnoreCase((String)object2) && object != null) {
                    vectorFont.setEmAscent2D((Double)object);
                }
                if ("emDescent".equalsIgnoreCase((String)object2) && object != null) {
                    vectorFont.setEmDescent2D((Double)object);
                }
                if ("lineAscent".equalsIgnoreCase((String)object2) && object != null) {
                    vectorFont.setLineAscent2D((Double)object);
                }
                if ("lineDescent".equalsIgnoreCase((String)object2) && object != null) {
                    vectorFont.setLineDescent2D((Double)object);
                }
                if ("lineGap".equalsIgnoreCase((String)object2) && object != null) {
                    vectorFont.setLineGap2D((Double)object);
                }
                if ("xHeight".equalsIgnoreCase((String)object2) && object != null) {
                    vectorFont.setXHeight2D((Double)object);
                }
                if (!"capHeight".equalsIgnoreCase((String)object2) || object == null) continue;
                vectorFont.setCapHeight2D((Double)object);
                continue;
            }
            if (string.equalsIgnoreCase("name")) {
                object2 = XMLUtility.parseInt(namedNodeMap, "id");
                object = XMLUtility.parseString(namedNodeMap, "value");
                if (object2 == null || object == null) continue;
                vectorFont.setName((Integer)object2, (String)object);
                continue;
            }
            if (string.equalsIgnoreCase("g")) {
                object2 = XMLUtility.parseInt(namedNodeMap, "u");
                object = XMLUtility.parseString(namedNodeMap, "n");
                if (object2 != null) {
                    vectorFont.putCharacter((Integer)object2, KpcaxVectorFontImporter.parseGlyph(namedNodeMap));
                }
                if (object == null) continue;
                vectorFont.putNamedGlyph((String)object, KpcaxVectorFontImporter.parseGlyph(namedNodeMap));
                continue;
            }
            if (!string.equalsIgnoreCase("k") || (object2 = XMLUtility.parseInt(namedNodeMap, "o")) == null) continue;
            object = XMLUtility.parseInt(namedNodeMap, "lu");
            String string2 = XMLUtility.parseString(namedNodeMap, "ln");
            Integer n = XMLUtility.parseInt(namedNodeMap, "ru");
            String string3 = XMLUtility.parseString(namedNodeMap, "rn");
            if (object != null) {
                if (n != null) {
                    vectorFont.setKernPair(new GlyphPair((Integer)object, n), (Integer)object2);
                }
                if (string3 != null) {
                    vectorFont.setKernPair(new GlyphPair((Integer)object, string3), (Integer)object2);
                }
            }
            if (string2 == null) continue;
            if (n != null) {
                vectorFont.setKernPair(new GlyphPair(string2, n), (Integer)object2);
            }
            if (string3 == null) continue;
            vectorFont.setKernPair(new GlyphPair(string2, string3), (Integer)object2);
        }
        return vectorFont;
    }

    private static VectorFontGlyph parseGlyph(NamedNodeMap namedNodeMap) throws IOException {
        Double d;
        VectorFontGlyph vectorFontGlyph = new VectorFontGlyph();
        String string = XMLUtility.parseString(namedNodeMap, "d");
        if (string != null && string.length() > 0) {
            KpcaxVectorFontImporter.parseVectorData(vectorFontGlyph.getContours(), string);
        }
        vectorFontGlyph.setCharacterWidth2D((d = XMLUtility.parseDouble(namedNodeMap, "w")) == null ? 0.0 : d);
        return vectorFontGlyph;
    }

    public static void parseVectorData(Collection<VectorPath> collection, String string) {
        VectorPath vectorPath = null;
        int n = 77;
        ArrayList<Double> arrayList = null;
        Matcher matcher = PATH_TOKEN.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3 = matcher.group(1);
            if (string3 != null && string3.length() > 0) {
                if (arrayList != null) {
                    if (vectorPath == null) {
                        vectorPath = new VectorPath();
                    }
                    vectorPath.add(new VectorInstruction((char)n, arrayList));
                    arrayList = null;
                }
                if (string3.equalsIgnoreCase("ZZ")) {
                    if (vectorPath != null) {
                        collection.add(vectorPath);
                        vectorPath = null;
                    }
                } else {
                    n = string3.charAt(0);
                    arrayList = new ArrayList<Double>();
                }
            }
            if ((string2 = matcher.group(2)) == null || string2.length() <= 0) continue;
            if (vectorPath == null) {
                vectorPath = new VectorPath();
            }
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            try {
                arrayList.add(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (arrayList.size() < PathExtensions.getOperandCount((char)n)) continue;
            vectorPath.add(new VectorInstruction((char)n, arrayList));
            if (n == 77) {
                n = 76;
            }
            if (n == 109) {
                n = 108;
            }
            arrayList = null;
        }
        if (arrayList != null) {
            if (vectorPath == null) {
                vectorPath = new VectorPath();
            }
            vectorPath.add(new VectorInstruction((char)n, arrayList));
            arrayList = null;
        }
        if (vectorPath != null) {
            collection.add(vectorPath);
            vectorPath = null;
        }
    }
}

