/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CybikoBitmapFontImporter
implements BitmapFontImporter {
    private GlyphList encoding;

    public CybikoBitmapFontImporter() {
        this.encoding = null;
    }

    public CybikoBitmapFontImporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(byteArrayInputStream));
        byteArrayInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(inputStream));
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(fileInputStream));
        fileInputStream.close();
        String string = file.getName();
        if (string.toLowerCase().endsWith(".cyf")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.toLowerCase().endsWith(".fnt")) {
            string = string.substring(0, string.length() - 4);
        } else if (string.toLowerCase().endsWith(".fntz")) {
            string = string.substring(0, string.length() - 5);
        } else if (string.toLowerCase().endsWith(".fnty")) {
            string = string.substring(0, string.length() - 5);
        }
        bitmapFont.setName(1, string);
        return new BitmapFont[]{bitmapFont};
    }

    private BitmapFont importFontImpl(DataInputStream dataInputStream) throws IOException {
        int n;
        if (dataInputStream.readUnsignedByte() != 1) {
            throw new IOException("bad magic number");
        }
        int n2 = dataInputStream.readUnsignedByte();
        dataInputStream.readUnsignedByte();
        int n3 = n = dataInputStream.readUnsignedByte();
        BitmapFont bitmapFont = new BitmapFont(n, 0, n, 0, 0, 0, 0);
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            int n6 = dataInputStream.readUnsignedByte();
            int n7 = dataInputStream.readUnsignedByte();
            int n8 = dataInputStream.readUnsignedByte();
            int n9 = dataInputStream.readUnsignedByte();
            boolean bl = n6 > 0 || n7 > 0 || n8 > 1 || n9 > 1;
            byte[][] byArray = new byte[n9][n8];
            for (int j = 0; j < n9; ++j) {
                for (n5 = 0; n5 < n8; n5 += 8) {
                    n4 = dataInputStream.readUnsignedByte();
                    int n10 = 128;
                    for (int k = n5; n10 != 0 && k < n8; n10 >>= 1, ++k) {
                        if ((n4 & n10) == 0) continue;
                        bl = true;
                        byArray[j][k] = -1;
                    }
                }
            }
            if (!bl) continue;
            if (i == 0) {
                n3 = n7 + n9;
                bitmapFont.setEmAscent(n3);
                bitmapFont.setLineAscent(n3);
                bitmapFont.setEmDescent(n - n3);
                bitmapFont.setLineDescent(n - n3);
            }
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArray, n6, n8, n3 - n7);
            n5 = i + 32 & 0xFF;
            int n11 = n4 = this.encoding != null ? this.encoding.get(n5) : CybikoBitmapFontImporter.fromCybiko(n5);
            if (n4 < 0) continue;
            bitmapFont.putCharacter(n4, bitmapFontGlyph);
        }
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private static int fromCybiko(int n) {
        switch (n) {
            case 127: {
                return 8230;
            }
            case 128: {
                return 9829;
            }
            case 129: {
                return 9679;
            }
            case 130: {
                return 9654;
            }
            case 131: {
                return 9655;
            }
            case 132: {
                return 1047586;
            }
            case 133: {
                return 1047587;
            }
            case 134: {
                return 8224;
            }
            case 135: {
                return 8225;
            }
            case 136: {
                return 710;
            }
            case 137: {
                return 8240;
            }
            case 138: {
                return 352;
            }
            case 139: {
                return 8249;
            }
            case 140: {
                return 338;
            }
            case 141: {
                return 321;
            }
            case 142: {
                return 381;
            }
            case 143: {
                return 305;
            }
            case 144: {
                return 8364;
            }
            case 145: {
                return 8216;
            }
            case 146: {
                return 8217;
            }
            case 147: {
                return 8220;
            }
            case 148: {
                return 8221;
            }
            case 149: {
                return 8226;
            }
            case 150: {
                return 8211;
            }
            case 151: {
                return 8212;
            }
            case 152: {
                return 732;
            }
            case 153: {
                return 8482;
            }
            case 154: {
                return 353;
            }
            case 155: {
                return 8250;
            }
            case 156: {
                return 339;
            }
            case 157: {
                return 322;
            }
            case 158: {
                return 382;
            }
            case 159: {
                return 376;
            }
        }
        return n;
    }
}

