/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.UTF8StrikeEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTF8StrikeMap {
    public final UTF8StrikeEntry[] lowEntries = new UTF8StrikeEntry[32];
    public final SubMap[] highEntries = new SubMap[16];
    public final AstralMap[] astralEntries = new AstralMap[6];

    public void clear() {
        int n;
        for (n = 0; n < 32; ++n) {
            this.lowEntries[n] = null;
        }
        for (n = 0; n < 16; ++n) {
            this.highEntries[n] = null;
        }
        for (n = 0; n < 6; ++n) {
            this.astralEntries[n] = null;
        }
    }

    public List<UTF8StrikeEntry> entryList() {
        ArrayList<UTF8StrikeEntry> arrayList = new ArrayList<UTF8StrikeEntry>();
        for (UTF8StrikeEntry object : this.lowEntries) {
            if (object == null) continue;
            arrayList.add(object);
        }
        for (SubMap subMap : this.highEntries) {
            if (subMap == null) continue;
            arrayList.addAll(subMap.entryList());
        }
        for (AstralMap astralMap : this.astralEntries) {
            if (astralMap == null) continue;
            arrayList.addAll(astralMap.entryList());
        }
        return arrayList;
    }

    public UTF8StrikeEntry get(int n) {
        if (n < 2048) {
            return this.lowEntries[n >> 6];
        }
        if (n < 65536) {
            SubMap subMap = this.highEntries[n >> 12];
            if (subMap == null) {
                return null;
            }
            return subMap.entries[n >> 6 & 0x3F];
        }
        if (n < 0x180000) {
            AstralMap astralMap = this.astralEntries[n >> 18];
            if (astralMap == null) {
                return null;
            }
            SubMap subMap = astralMap.entries[n >> 12 & 0x3F];
            if (subMap == null) {
                return null;
            }
            return subMap.entries[n >> 6 & 0x3F];
        }
        return null;
    }

    public boolean isEmpty() {
        for (UTF8StrikeEntry object : this.lowEntries) {
            if (object == null) continue;
            return false;
        }
        for (SubMap subMap : this.highEntries) {
            if (subMap == null || subMap.isEmpty()) continue;
            return false;
        }
        for (AstralMap astralMap : this.astralEntries) {
            if (astralMap == null || astralMap.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void remap(Map<UTF8StrikeEntry, UTF8StrikeEntry> map) {
        for (int i = 0; i < 32; ++i) {
            if (!map.containsKey(this.lowEntries[i])) continue;
            this.lowEntries[i] = map.get(this.lowEntries[i]);
        }
        for (SubMap object : this.highEntries) {
            if (object == null) continue;
            object.remap(map);
        }
        for (AstralMap astralMap : this.astralEntries) {
            if (astralMap == null) continue;
            astralMap.remap(map);
        }
    }

    public void remove(int n) {
        if (n < 2048) {
            this.lowEntries[n >> 6] = null;
        } else if (n < 65536) {
            SubMap subMap = this.highEntries[n >> 12];
            if (subMap == null) {
                return;
            }
            subMap.entries[n >> 6 & 0x3F] = null;
            if (subMap.isEmpty()) {
                this.highEntries[n >> 12] = null;
            }
        } else if (n < 0x180000) {
            AstralMap astralMap = this.astralEntries[n >> 18];
            if (astralMap == null) {
                return;
            }
            SubMap subMap = astralMap.entries[n >> 12 & 0x3F];
            if (subMap == null) {
                return;
            }
            subMap.entries[n >> 6 & 0x3F] = null;
            if (subMap.isEmpty()) {
                astralMap.entries[n >> 12 & 0x3F] = null;
            }
            if (astralMap.isEmpty()) {
                this.astralEntries[n >> 18] = null;
            }
        }
    }

    public void set(int n, int n2, int n3, int n4) {
        if (n < 2048) {
            this.lowEntries[n >> 6] = new UTF8StrikeEntry(n2, n3, n4);
        } else if (n < 65536) {
            SubMap subMap = this.highEntries[n >> 12];
            if (subMap == null) {
                SubMap subMap2 = new SubMap();
                this.highEntries[n >> 12] = subMap2;
                subMap = subMap2;
            }
            subMap.entries[n >> 6 & 0x3F] = new UTF8StrikeEntry(n2, n3, n4);
        } else if (n < 0x180000) {
            SubMap subMap;
            AstralMap astralMap = this.astralEntries[n >> 18];
            if (astralMap == null) {
                AstralMap astralMap2 = new AstralMap();
                this.astralEntries[n >> 18] = astralMap2;
                astralMap = astralMap2;
            }
            if ((subMap = astralMap.entries[n >> 12 & 0x3F]) == null) {
                SubMap subMap3 = new SubMap();
                astralMap.entries[n >> 12 & 0x3F] = subMap3;
                subMap = subMap3;
            }
            subMap.entries[n >> 6 & 0x3F] = new UTF8StrikeEntry(n2, n3, n4);
        }
    }

    public void read(byte[] byArray, int n) {
        int n2;
        int n3;
        this.clear();
        for (n3 = 0; n3 < 32 && n + 4 <= byArray.length; ++n3) {
            n2 = byArray[n + 0] & 0xFF;
            int n4 = byArray[n + 1] & 0xFF;
            int n5 = byArray[n + 2] & 0xFF;
            if (n2 != 0 || n4 != 0 || (n5 |= (byArray[n + 3] & 0xFF) << 8) != 0) {
                this.lowEntries[n3] = new UTF8StrikeEntry(n2, n4, n5);
            }
            n += 4;
        }
        for (n3 = 0; n3 < 16 && n + 2 <= byArray.length; ++n3) {
            n2 = byArray[n + 0] & 0xFF;
            if ((n2 |= (byArray[n + 1] & 0xFF) << 8) != 0) {
                this.highEntries[n3] = new SubMap();
                this.highEntries[n3].read(byArray, n2);
            }
            n += 2;
        }
        for (n3 = 0; n3 < 6 && n + 2 <= byArray.length; ++n3) {
            n2 = byArray[n + 0] & 0xFF;
            if ((n2 |= (byArray[n + 1] & 0xFF) << 8) != 0) {
                this.astralEntries[n3] = new AstralMap();
                this.astralEntries[n3].read(byArray, n2);
            }
            n += 2;
        }
    }

    public byte[] write(int n) {
        int n2;
        int n3 = 172;
        byte[][] byArrayArray = new byte[16][];
        for (int i = 0; i < 16; ++i) {
            if (this.highEntries[i] == null) continue;
            byArrayArray[i] = this.highEntries[i].write();
            n3 += byArrayArray[i].length;
        }
        byte[][] byArrayArray2 = new byte[6][];
        for (int i = 0; i < 6; ++i) {
            if (this.astralEntries[i] == null) continue;
            byArrayArray2[i] = this.astralEntries[i].write(n + n3);
            n3 += byArrayArray2[i].length;
        }
        byte[] byArray = new byte[n3];
        int n4 = 172;
        int n5 = 0;
        int n6 = 0;
        while (n6 < 32) {
            if (this.lowEntries[n6] != null) {
                byArray[n5 + 0] = (byte)this.lowEntries[n6].recordIndex;
                byArray[n5 + 1] = (byte)this.lowEntries[n6].sectorIndex;
                byArray[n5 + 2] = (byte)this.lowEntries[n6].length;
                byArray[n5 + 3] = (byte)(this.lowEntries[n6].length >> 8);
            }
            ++n6;
            n5 += 4;
        }
        n5 = 128;
        n6 = 0;
        while (n6 < 16) {
            if (byArrayArray[n6] != null) {
                byArray[n5 + 0] = (byte)(n + n4);
                byArray[n5 + 1] = (byte)(n + n4 >> 8);
                for (n2 = 0; n2 < byArrayArray[n6].length; ++n2) {
                    byArray[n4] = byArrayArray[n6][n2];
                    ++n4;
                }
            }
            ++n6;
            n5 += 2;
        }
        n5 = 160;
        n6 = 0;
        while (n6 < 6) {
            if (byArrayArray2[n6] != null) {
                byArray[n5 + 0] = (byte)(n + n4);
                byArray[n5 + 1] = (byte)(n + n4 >> 8);
                for (n2 = 0; n2 < byArrayArray2[n6].length; ++n2) {
                    byArray[n4] = byArrayArray2[n6][n2];
                    ++n4;
                }
            }
            ++n6;
            n5 += 2;
        }
        return byArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AstralMap {
        public final SubMap[] entries = new SubMap[64];

        public void clear() {
            for (int i = 0; i < 64; ++i) {
                this.entries[i] = null;
            }
        }

        public List<UTF8StrikeEntry> entryList() {
            ArrayList<UTF8StrikeEntry> arrayList = new ArrayList<UTF8StrikeEntry>();
            for (SubMap subMap : this.entries) {
                if (subMap == null) continue;
                arrayList.addAll(subMap.entryList());
            }
            return arrayList;
        }

        public boolean isEmpty() {
            for (SubMap subMap : this.entries) {
                if (subMap == null || subMap.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public void remap(Map<UTF8StrikeEntry, UTF8StrikeEntry> map) {
            for (SubMap subMap : this.entries) {
                if (subMap == null) continue;
                subMap.remap(map);
            }
        }

        public void read(byte[] byArray, int n) {
            this.clear();
            for (int i = 0; i < 64 && n + 2 <= byArray.length; ++i) {
                int n2 = byArray[n + 0] & 0xFF;
                if ((n2 |= (byArray[n + 1] & 0xFF) << 8) != 0) {
                    this.entries[i] = new SubMap();
                    this.entries[i].read(byArray, n2);
                }
                n += 2;
            }
        }

        public byte[] write(int n) {
            int n2 = 128;
            byte[][] byArrayArray = new byte[64][];
            for (int i = 0; i < 64; ++i) {
                if (this.entries[i] == null) continue;
                byArrayArray[i] = this.entries[i].write();
                n2 += byArrayArray[i].length;
            }
            byte[] byArray = new byte[n2];
            int n3 = 128;
            int n4 = 0;
            int n5 = 0;
            while (n5 < 64) {
                if (byArrayArray[n5] != null) {
                    byArray[n4 + 0] = (byte)(n + n3);
                    byArray[n4 + 1] = (byte)(n + n3 >> 8);
                    for (int i = 0; i < byArrayArray[n5].length; ++i) {
                        byArray[n3] = byArrayArray[n5][i];
                        ++n3;
                    }
                }
                ++n5;
                n4 += 2;
            }
            return byArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SubMap {
        public final UTF8StrikeEntry[] entries = new UTF8StrikeEntry[64];

        public void clear() {
            for (int i = 0; i < 64; ++i) {
                this.entries[i] = null;
            }
        }

        public List<UTF8StrikeEntry> entryList() {
            ArrayList<UTF8StrikeEntry> arrayList = new ArrayList<UTF8StrikeEntry>();
            for (UTF8StrikeEntry uTF8StrikeEntry : this.entries) {
                if (uTF8StrikeEntry == null) continue;
                arrayList.add(uTF8StrikeEntry);
            }
            return arrayList;
        }

        public boolean isEmpty() {
            for (UTF8StrikeEntry uTF8StrikeEntry : this.entries) {
                if (uTF8StrikeEntry == null) continue;
                return false;
            }
            return true;
        }

        public void remap(Map<UTF8StrikeEntry, UTF8StrikeEntry> map) {
            for (int i = 0; i < 64; ++i) {
                if (!map.containsKey(this.entries[i])) continue;
                this.entries[i] = map.get(this.entries[i]);
            }
        }

        public void read(byte[] byArray, int n) {
            this.clear();
            for (int i = 0; i < 64 && n + 4 <= byArray.length; ++i) {
                int n2 = byArray[n + 0] & 0xFF;
                int n3 = byArray[n + 1] & 0xFF;
                int n4 = byArray[n + 2] & 0xFF;
                if (n2 != 0 || n3 != 0 || (n4 |= (byArray[n + 3] & 0xFF) << 8) != 0) {
                    this.entries[i] = new UTF8StrikeEntry(n2, n3, n4);
                }
                n += 4;
            }
        }

        public byte[] write() {
            byte[] byArray = new byte[256];
            int n = 0;
            int n2 = 0;
            while (n2 < 64) {
                if (this.entries[n2] != null) {
                    byArray[n + 0] = (byte)this.entries[n2].recordIndex;
                    byArray[n + 1] = (byte)this.entries[n2].sectorIndex;
                    byArray[n + 2] = (byte)this.entries[n2].length;
                    byArray[n + 3] = (byte)(this.entries[n2].length >> 8);
                }
                ++n2;
                n += 4;
            }
            return byArray;
        }
    }
}

