/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.IDGenerator;
import com.kreative.bitsnpicas.PointSizeGenerator;
import com.kreative.bitsnpicas.mover.FONDEntry;
import com.kreative.bitsnpicas.mover.FONDResource;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceArray;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class NFNTBitmapFontExporter
implements BitmapFontExporter {
    private IDGenerator idgen;
    private PointSizeGenerator sizegen;
    private GlyphList encoding;
    private static final int[] MACROMAN = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 8984, 10003, 9670, 63743, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232, 234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252, 8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216, 8734, 177, 8804, 8805, 165, 181, 8706, 8721, 8719, 960, 8747, 170, 186, 937, 230, 248, 191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339, 8211, 8212, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 8260, 8364, 8249, 8250, 64257, 64258, 8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212, 63743, 210, 218, 219, 217, 305, 710, 732, 175, 728, 729, 730, 184, 733, 731, 711};

    public NFNTBitmapFontExporter(IDGenerator iDGenerator, PointSizeGenerator pointSizeGenerator) {
        this.idgen = iDGenerator;
        this.sizegen = pointSizeGenerator;
        this.encoding = null;
    }

    public NFNTBitmapFontExporter(IDGenerator iDGenerator, PointSizeGenerator pointSizeGenerator, GlyphList glyphList) {
        this.idgen = iDGenerator;
        this.sizegen = pointSizeGenerator;
        this.encoding = glyphList;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = 0;
        int n9 = 0;
        int n10 = -bitmapFont.getLineDescent();
        int n11 = 0;
        int n12 = bitmapFont.getLineAscent() + bitmapFont.getLineDescent();
        int n13 = bitmapFont.getLineAscent();
        int n14 = bitmapFont.getLineDescent();
        int n15 = bitmapFont.getLineGap();
        int n16 = 0;
        for (n4 = 0; n4 < 256; ++n4) {
            n3 = this.encoding != null ? this.encoding.get(n4) : MACROMAN[n4];
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n3);
            if (bitmapFontGlyph == null) continue;
            if (n4 < n6) {
                n6 = n4;
            }
            if (n4 > n7) {
                n7 = n4;
            }
            if (bitmapFontGlyph.getCharacterWidth() > n8) {
                n8 = bitmapFontGlyph.getCharacterWidth();
            }
            if (bitmapFontGlyph.getGlyphOffset() < n9) {
                n9 = bitmapFontGlyph.getGlyphOffset();
            }
            if (bitmapFontGlyph.getGlyphOffset() + bitmapFontGlyph.getGlyphWidth() - n9 > n11) {
                n11 = bitmapFontGlyph.getGlyphOffset() + bitmapFontGlyph.getGlyphWidth() - n9;
            }
            n16 += bitmapFontGlyph.getGlyphWidth();
        }
        int n17 = (n16 + 15) / 16;
        int n18 = 5 + n17 * n12 + (n7 - n6 + 3);
        byte[][] byArray = new byte[n12][n17 * 16];
        short[] sArray = new short[n7 - n6 + 3];
        byte[] byArray2 = new byte[n7 - n6 + 2];
        byte[] byArray3 = new byte[n7 - n6 + 2];
        n4 = 0;
        n3 = n6;
        for (int i = 0; n3 <= n7 && i < byArray2.length; ++n3, ++i) {
            n2 = this.encoding != null ? this.encoding.get(n3) : MACROMAN[n3];
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n2);
            if (bitmapFontGlyph != null) {
                byte[][] byArray4 = bitmapFontGlyph.getGlyph();
                n = 0;
                for (int j = bitmapFont.getLineAscent() - bitmapFontGlyph.getGlyphAscent(); n < byArray4.length && j < byArray.length; ++n, ++j) {
                    if (j < 0) continue;
                    int n19 = 0;
                    for (int k = n4; n19 < byArray4[n].length && k < byArray[j].length; ++n19, ++k) {
                        byArray[j][k] = byArray4[n][n19];
                    }
                }
                sArray[i] = (short)n4;
                byArray2[i] = (byte)(bitmapFontGlyph.getGlyphOffset() - n9);
                byArray3[i] = (byte)bitmapFontGlyph.getCharacterWidth();
                n4 += bitmapFontGlyph.getGlyphWidth();
                continue;
            }
            sArray[i] = (short)n4;
            byArray2[i] = -1;
            byArray3[i] = -1;
        }
        Object object = (BitmapFontGlyph)bitmapFont.getCharacter(-1);
        if (object != null) {
            byte[][] byArray5 = ((BitmapFontGlyph)object).getGlyph();
            n2 = 0;
            for (int i = bitmapFont.getLineAscent() - ((BitmapFontGlyph)object).getGlyphAscent(); n2 < byArray5.length && i < byArray.length; ++n2, ++i) {
                if (i < 0) continue;
                int n20 = 0;
                for (n = n4; n20 < byArray5[n2].length && n < byArray[i].length; ++n20, ++n) {
                    byArray[i][n] = byArray5[n2][n20];
                }
            }
            sArray[n7 - n6 + 1] = (short)n4;
            byArray2[n7 - n6 + 1] = (byte)(((BitmapFontGlyph)object).getGlyphOffset() - n9);
            byArray3[n7 - n6 + 1] = (byte)((BitmapFontGlyph)object).getCharacterWidth();
            n4 += ((BitmapFontGlyph)object).getGlyphWidth();
        } else {
            sArray[n7 - n6 + 1] = (short)n4;
            byArray2[n7 - n6 + 1] = -1;
            byArray3[n7 - n6 + 1] = -1;
        }
        sArray[n7 - n6 + 2] = (short)n4;
        object = new byte[n12][n17 * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n21 = 0;
            for (n2 = 0; n2 < ((Object)object[i]).length && n21 < byArray[i].length; ++n2) {
                for (int j = 0; n21 < byArray[i].length && j < 8; ++n21, ++j) {
                    Object object2 = object[i];
                    int n22 = n2;
                    object2[n22] = (byte)(object2[n22] << 1);
                    if ((byArray[i][n21] & 0xFF) < 128) continue;
                    Object object3 = object[i];
                    int n23 = n2;
                    object3[n23] = (byte)(object3[n23] | 1);
                }
            }
        }
        bitmapFont.autoFillNames();
        String string = bitmapFont.getName(1);
        int n24 = this.idgen.generateID(bitmapFont);
        int n25 = this.sizegen.generatePointSize(bitmapFont);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(n5);
        dataOutputStream.writeShort(n6);
        dataOutputStream.writeShort(n7);
        dataOutputStream.writeShort(n8);
        dataOutputStream.writeShort(n9);
        dataOutputStream.writeShort(n10);
        dataOutputStream.writeShort(n11);
        dataOutputStream.writeShort(n12);
        dataOutputStream.writeShort(n18);
        dataOutputStream.writeShort(n13);
        dataOutputStream.writeShort(n14);
        dataOutputStream.writeShort(n15);
        dataOutputStream.writeShort(n17);
        for (Object object4 : object) {
            dataOutputStream.write((byte[])object4);
        }
        for (Object object5 : (Object)sArray) {
            dataOutputStream.writeShort((int)object5);
        }
        for (int i = 0; i < byArray2.length && i < byArray3.length; ++i) {
            dataOutputStream.writeByte(byArray2[i]);
            dataOutputStream.writeByte(byArray3[i]);
        }
        FONDResource fONDResource = new FONDResource(string, n24);
        fONDResource.entries.add(new FONDEntry(n25, bitmapFont.getMacStyle(), n24));
        MacResourceArray macResourceArray = new MacResourceArray();
        macResourceArray.add(new MacResource(1179602500, (short)n24, string, fONDResource.toByteArray()));
        macResourceArray.add(new MacResource(1313230420, (short)n24, string, byteArrayOutputStream.toByteArray()));
        return macResourceArray.getBytes();
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ((OutputStream)fileOutputStream).write(this.exportFontToBytes(bitmapFont));
        ((OutputStream)fileOutputStream).close();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        outputStream.write(this.exportFontToBytes(bitmapFont));
    }
}

