/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class HMZKBitmapFontExporter
implements BitmapFontExporter {
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFont(bitmapFont, new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFont(bitmapFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFont(bitmapFont, new DataOutputStream(fileOutputStream));
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        dataOutputStream.writeInt(1213028939);
        dataOutputStream.writeInt(0x1FFFFFF);
        dataOutputStream.writeInt(-1);
        dataOutputStream.writeShort(65535);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        for (Map.Entry entry : bitmapFont.characters(false).entrySet()) {
            ++n;
            int n2 = entry.getKey();
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)entry.getValue();
            int n3 = bitmapFontGlyph.getX();
            int n4 = bitmapFontGlyph.getY();
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)((n2 & 0xFF00) >> 8));
            byte[][] byArray = bitmapFontGlyph.getGlyph();
            int n5 = 16 - n4;
            for (int i = 0; i < 16; ++i) {
                int n6;
                if (i < n5 || i - n5 >= byArray.length) {
                    byteArrayOutputStream2.write(0);
                    byteArrayOutputStream2.write(0);
                    continue;
                }
                byte[] byArray2 = byArray[i - n5];
                int n7 = 0;
                if (n3 < 8) {
                    for (n6 = 0; n6 < 8 && n6 < byArray2.length; ++n6) {
                        if (byArray2[n6] == 0) continue;
                        n7 = (byte)(n7 | 1 << 7 - n6 - n3);
                    }
                }
                byteArrayOutputStream2.write(n7);
                n7 = 0;
                if (n3 < 16) {
                    for (n6 = 8; n6 < 16 && n6 < byArray2.length; ++n6) {
                        if (byArray2[n6] == 0) continue;
                        n7 = (byte)(n7 | 1 << 15 - n6 - n3);
                    }
                }
                byteArrayOutputStream2.write(n7);
            }
        }
        dataOutputStream.writeShort(Short.reverseBytes((short)(n * 2)));
        byteArrayOutputStream.writeTo(dataOutputStream);
        byteArrayOutputStream2.writeTo(dataOutputStream);
    }
}

