/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.importer;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.importer.DualEncodingSelectionImporter;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DualEncodingSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public DualEncodingSelectionPanel(String string, String string2, final File file, final DualEncodingSelectionImporter dualEncodingSelectionImporter) {
        final JComboBox<Object> jComboBox = new JComboBox<Object>(EncodingList.instance().glyphLists().toArray());
        jComboBox.setEditable(false);
        jComboBox.setSelectedItem(EncodingList.instance().getGlyphList(string));
        final JComboBox<Object> jComboBox2 = new JComboBox<Object>(Charset.availableCharsets().keySet().toArray());
        jComboBox2.setEditable(false);
        jComboBox2.setSelectedItem(string2);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel.add(new JLabel("Single-Byte Encoding:"));
        jPanel.add(new JLabel("Double-Byte Encoding:"));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel2.add(jComboBox);
        jPanel2.add(jComboBox2);
        JPanel jPanel3 = new JPanel(new BorderLayout(8, 8));
        jPanel3.add((Component)jPanel, "Before");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(12, 12));
        jPanel4.add((Component)new JLabel("Select an encoding for " + file.getName() + "."), "First");
        jPanel4.add((Component)jPanel3, "Center");
        JButton jButton = new JButton("Open");
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(jButton);
        JPanel jPanel6 = new JPanel(new BorderLayout(12, 12));
        jPanel6.add((Component)jPanel4, "Center");
        jPanel6.add((Component)jPanel5, "Last");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(jPanel6);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GlyphList glyphList = (GlyphList)jComboBox.getSelectedItem();
                    String string = (String)jComboBox2.getSelectedItem();
                    Font[] fontArray = dualEncodingSelectionImporter.createImporter(glyphList, string).importFont(file);
                    if (fontArray != null && fontArray.length > 0) {
                        Main.openFonts(file, null, fontArray);
                    } else {
                        JOptionPane.showMessageDialog(null, "The selected file did not contain any fonts.", "Open", 0);
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "An error occurred while reading the selected file.", "Open", 0);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    JOptionPane.showMessageDialog(null, "The selected file requires KSFL, but KSFL is not in the classpath.", "Open", 0);
                }
            }
        });
    }
}

