/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.GlyphComponent;
import com.kreative.bitsnpicas.edit.GlyphEditPanel;
import com.kreative.bitsnpicas.edit.SaveManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphEditMenuBar<G extends FontGlyph>
extends JMenuBar {
    private static final long serialVersionUID = 1L;

    public GlyphEditMenuBar(Frame frame, SaveManager saveManager, Font<G> font, GlyphEditPanel<G> glyphEditPanel, Class<G> clazz) {
        this.add(new FileMenu(frame, saveManager, font));
        this.add(new ViewMenu<G>(frame, glyphEditPanel, clazz));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NextDefinedGlyphMenuItem<G extends FontGlyph>
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public NextDefinedGlyphMenuItem(final Frame frame, final GlyphEditPanel<G> glyphEditPanel) {
            super("Next Defined Glyph");
            this.setAccelerator(KeyStroke.getKeyStroke(93, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getNextDefined(), null);
                    frame.setTitle(glyphEditPanel.getGlyphLocator().toString());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PreviousDefinedGlyphMenuItem<G extends FontGlyph>
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public PreviousDefinedGlyphMenuItem(final Frame frame, final GlyphEditPanel<G> glyphEditPanel) {
            super("Previous Defined Glyph");
            this.setAccelerator(KeyStroke.getKeyStroke(91, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getPreviousDefined(), null);
                    frame.setTitle(glyphEditPanel.getGlyphLocator().toString());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NextGlyphMenuItem<G extends FontGlyph>
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public NextGlyphMenuItem(final Frame frame, final GlyphEditPanel<G> glyphEditPanel, final Class<G> clazz) {
            super("Next Glyph");
            this.setAccelerator(KeyStroke.getKeyStroke(93, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getNext(), clazz);
                    frame.setTitle(glyphEditPanel.getGlyphLocator().toString());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PreviousGlyphMenuItem<G extends FontGlyph>
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public PreviousGlyphMenuItem(final Frame frame, final GlyphEditPanel<G> glyphEditPanel, final Class<G> clazz) {
            super("Previous Glyph");
            this.setAccelerator(KeyStroke.getKeyStroke(91, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getPrevious(), clazz);
                    frame.setTitle(glyphEditPanel.getGlyphLocator().toString());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ShowBoundingBoxMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;

        public ShowBoundingBoxMenuItem(final GlyphComponent<?> glyphComponent) {
            super("Show Bounding Box");
            this.setAccelerator(KeyStroke.getKeyStroke(66, CommonMenuItems.SHORTCUT_KEY));
            this.setSelected(glyphComponent.getShowGlyphBounds());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphComponent.setShowGlyphBounds(ShowBoundingBoxMenuItem.this.isSelected());
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ZoomOutMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ZoomOutMenuItem(final GlyphComponent<?> glyphComponent, final FitToEmMenuItem fitToEmMenuItem) {
            super("Zoom Out");
            this.setAccelerator(KeyStroke.getKeyStroke(45, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphComponent.setFit(false);
                    fitToEmMenuItem.setSelected(false);
                    double d = glyphComponent.getScale() / 1.5;
                    if (d <= 0.0) {
                        d = 1.0;
                    }
                    if (d >= 1.0) {
                        d = Math.floor(d);
                    }
                    glyphComponent.setScale(d);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ZoomInMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ZoomInMenuItem(final GlyphComponent<?> glyphComponent, final FitToEmMenuItem fitToEmMenuItem) {
            super("Zoom In");
            this.setAccelerator(KeyStroke.getKeyStroke(61, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphComponent.setFit(false);
                    fitToEmMenuItem.setSelected(false);
                    double d = glyphComponent.getScale() * 1.5;
                    if (d <= 0.0) {
                        d = 1.0;
                    }
                    if (d >= 1.0) {
                        d = Math.ceil(d);
                    }
                    glyphComponent.setScale(d);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FitToEmMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;

        public FitToEmMenuItem(final GlyphComponent<?> glyphComponent) {
            super("Fit to Em");
            this.setAccelerator(KeyStroke.getKeyStroke(48, CommonMenuItems.SHORTCUT_KEY));
            this.setSelected(glyphComponent.getFit());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    glyphComponent.setFit(true);
                    FitToEmMenuItem.this.setSelected(true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ViewMenu<G extends FontGlyph>
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public ViewMenu(Frame frame, GlyphEditPanel<G> glyphEditPanel, Class<G> clazz) {
            super("View");
            GlyphComponent<G> glyphComponent = glyphEditPanel.getGlyphComponent();
            FitToEmMenuItem fitToEmMenuItem = new FitToEmMenuItem(glyphComponent);
            this.add(fitToEmMenuItem);
            this.add(new ZoomOutMenuItem(glyphComponent, fitToEmMenuItem));
            this.add(new ZoomInMenuItem(glyphComponent, fitToEmMenuItem));
            this.addSeparator();
            this.add(new ShowBoundingBoxMenuItem(glyphComponent));
            this.addSeparator();
            this.add(new PreviousGlyphMenuItem<G>(frame, glyphEditPanel, clazz));
            this.add(new NextGlyphMenuItem<G>(frame, glyphEditPanel, clazz));
            this.add(new PreviousDefinedGlyphMenuItem<G>(frame, glyphEditPanel));
            this.add(new NextDefinedGlyphMenuItem<G>(frame, glyphEditPanel));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public FileMenu(Frame frame, SaveManager saveManager, Font<?> font) {
            super("File");
            this.add(new CommonMenuItems.NewMenu());
            this.add(new CommonMenuItems.OpenMenuItem());
            this.add(new CommonMenuItems.CloseMenuItem(frame));
            this.addSeparator();
            this.add(new CommonMenuItems.SaveMenuItem(saveManager));
            this.add(new CommonMenuItems.SaveAsMenuItem(saveManager));
            this.addSeparator();
            this.add(new CommonMenuItems.FontInfoMenuItem(font, saveManager));
            if (!CommonMenuItems.IS_MAC_OS) {
                this.addSeparator();
                this.add(new CommonMenuItems.ExitMenuItem());
            }
        }
    }
}

