/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Scrollable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontInfoNamesPanel
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 1L;
    public static final Map<Integer, String> NAME_TYPE_NAMES;
    private final Map<Integer, JTextField> fields;

    public FontInfoNamesPanel() {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 4, 4));
        this.fields = new HashMap<Integer, JTextField>();
        for (Map.Entry<Integer, String> object2 : NAME_TYPE_NAMES.entrySet()) {
            jComponent = new JLabel(object2.getValue());
            JTextField jTextField = new JTextField();
            jPanel.add(jComponent);
            jPanel2.add(jTextField);
            this.fields.put(object2.getKey(), jTextField);
        }
        JButton jButton = new JButton("Auto Fill");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(jButton);
        jComponent = new JPanel(new BorderLayout(8, 8));
        jComponent.add((Component)jPanel, "Before");
        jComponent.add((Component)jPanel2, "Center");
        jComponent.add((Component)jPanel3, "Last");
        jComponent.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)jComponent, "First");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontInfoNamesPanel.this.autoFillNames();
            }
        });
    }

    public void readFrom(Font<?> font) {
        for (Map.Entry<Integer, JTextField> entry : this.fields.entrySet()) {
            entry.getValue().setText(font.getName(entry.getKey()));
        }
    }

    public void writeTo(Font<?> font) {
        for (Map.Entry<Integer, JTextField> entry : this.fields.entrySet()) {
            String string = entry.getValue().getText().trim();
            if (string.length() == 0) {
                font.removeName(entry.getKey());
                continue;
            }
            font.setName(entry.getKey(), string);
        }
    }

    public void autoFillNames() {
        BogusFont bogusFont = new BogusFont();
        this.writeTo(bogusFont);
        bogusFont.autoFillNames();
        this.readFrom(bogusFont);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.fields.get((Object)Integer.valueOf((int)0)).getPreferredSize().height + 4;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = this.fields.get((Object)Integer.valueOf((int)0)).getPreferredSize().height + 4;
        return rectangle.height / n3 * n3;
    }

    static {
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        linkedHashMap.put(4, "Font Family & Style Name");
        linkedHashMap.put(1, "Font Family Name");
        linkedHashMap.put(2, "Font Style Name");
        linkedHashMap.put(6, "PostScript Name");
        linkedHashMap.put(16, "Windows Family Name");
        linkedHashMap.put(17, "Windows Style Name");
        linkedHashMap.put(18, "Mac OS Family & Style Name");
        linkedHashMap.put(21, "WWS Family Name");
        linkedHashMap.put(22, "WWS Style Name");
        linkedHashMap.put(5, "Version Number");
        linkedHashMap.put(3, "Unique ID");
        linkedHashMap.put(20, "PostScript CID");
        linkedHashMap.put(0, "Copyright Notice");
        linkedHashMap.put(7, "Trademark Notice");
        linkedHashMap.put(10, "Description");
        linkedHashMap.put(8, "Manufacturer");
        linkedHashMap.put(11, "Vendor URL");
        linkedHashMap.put(9, "Designer");
        linkedHashMap.put(12, "Designer URL");
        linkedHashMap.put(13, "License Description");
        linkedHashMap.put(14, "License URL");
        linkedHashMap.put(19, "Sample Text");
        NAME_TYPE_NAMES = Collections.unmodifiableMap(linkedHashMap);
    }

    private static class BogusGlyph
    extends FontGlyph {
        private BogusGlyph() {
        }

        public int getGlyphOffset() {
            return 0;
        }

        public int getGlyphWidth() {
            return 0;
        }

        public int getGlyphHeight() {
            return 0;
        }

        public int getGlyphAscent() {
            return 0;
        }

        public int getGlyphDescent() {
            return 0;
        }

        public int getCharacterWidth() {
            return 0;
        }

        public double getGlyphOffset2D() {
            return 0.0;
        }

        public double getGlyphWidth2D() {
            return 0.0;
        }

        public double getGlyphHeight2D() {
            return 0.0;
        }

        public double getGlyphAscent2D() {
            return 0.0;
        }

        public double getGlyphDescent2D() {
            return 0.0;
        }

        public double getCharacterWidth2D() {
            return 0.0;
        }

        public void setCharacterWidth(int n) {
        }

        public void setCharacterWidth2D(double d) {
        }

        public double paint(Graphics graphics, double d, double d2, double d3) {
            return 0.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BogusFont
    extends Font<BogusGlyph> {
        private BogusFont() {
        }

        @Override
        public int getEmAscent() {
            return 0;
        }

        @Override
        public int getEmDescent() {
            return 0;
        }

        @Override
        public int getLineAscent() {
            return 0;
        }

        @Override
        public int getLineDescent() {
            return 0;
        }

        @Override
        public int getXHeight() {
            return 0;
        }

        @Override
        public int getCapHeight() {
            return 0;
        }

        @Override
        public int getLineGap() {
            return 0;
        }

        @Override
        public double getEmAscent2D() {
            return 0.0;
        }

        @Override
        public double getEmDescent2D() {
            return 0.0;
        }

        @Override
        public double getLineAscent2D() {
            return 0.0;
        }

        @Override
        public double getLineDescent2D() {
            return 0.0;
        }

        @Override
        public double getXHeight2D() {
            return 0.0;
        }

        @Override
        public double getCapHeight2D() {
            return 0.0;
        }

        @Override
        public double getLineGap2D() {
            return 0.0;
        }

        @Override
        public void setEmAscent(int n) {
        }

        @Override
        public void setEmDescent(int n) {
        }

        @Override
        public void setLineAscent(int n) {
        }

        @Override
        public void setLineDescent(int n) {
        }

        @Override
        public void setXHeight(int n) {
        }

        @Override
        public void setCapHeight(int n) {
        }

        @Override
        public void setLineGap(int n) {
        }

        @Override
        public void setEmAscent2D(double d) {
        }

        @Override
        public void setEmDescent2D(double d) {
        }

        @Override
        public void setLineAscent2D(double d) {
        }

        @Override
        public void setLineDescent2D(double d) {
        }

        @Override
        public void setXHeight2D(double d) {
        }

        @Override
        public void setCapHeight2D(double d) {
        }

        @Override
        public void setLineGap2D(double d) {
        }
    }
}

