/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.edit.BitmapTool;
import com.kreative.bitsnpicas.edit.BitmapToolHandler;
import com.kreative.bitsnpicas.edit.BitmapToolPanel;
import com.kreative.bitsnpicas.edit.GlyphComponent;
import com.kreative.bitsnpicas.edit.GlyphEditPanel;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitmapEditPanel
extends GlyphEditPanel<BitmapFontGlyph> {
    private static final long serialVersionUID = 1L;
    private final GlyphComponent<BitmapFontGlyph> glyphComponent = this.getGlyphComponent();
    private final BitmapToolPanel toolPanel = new BitmapToolPanel();
    private final BitmapToolHandler toolHandler = new BitmapToolHandler(this.toolPanel, this.glyphComponent);

    public BitmapEditPanel(GlyphLocator<BitmapFontGlyph> glyphLocator, GlyphList<BitmapFontGlyph> glyphList) {
        super(glyphLocator, glyphList);
        this.add((Component)this.toolPanel, "Before");
        this.glyphComponent.setFocusable(true);
        this.glyphComponent.addMouseListener(new MyMouseListener());
        this.glyphComponent.addKeyListener(new MyKeyListener());
    }

    public BitmapToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public BitmapToolHandler getToolHandler() {
        return this.toolHandler;
    }

    @Override
    public void setGlyph(GlyphLocator<BitmapFontGlyph> glyphLocator, Class<BitmapFontGlyph> clazz) {
        super.setGlyph(glyphLocator, clazz);
        this.toolHandler.clearHistory();
    }

    private void translateGlyph(boolean bl, int n, int n2) {
        if (bl) {
            this.toolHandler.pushUndoState(null);
        }
        BitmapFontGlyph bitmapFontGlyph = this.glyphComponent.getGlyph();
        bitmapFontGlyph.setXY(bitmapFontGlyph.getX() + n, bitmapFontGlyph.getY() - n2);
        this.glyphComponent.glyphChanged();
    }

    private void translateGlyphWidth(int n) {
        BitmapFontGlyph bitmapFontGlyph = this.glyphComponent.getGlyph();
        if ((n += bitmapFontGlyph.getCharacterWidth()) < 0) {
            n = 0;
        }
        bitmapFontGlyph.setCharacterWidth(n);
        this.glyphComponent.metricsChanged();
    }

    private void translateOpacity(int n) {
        if ((n += this.toolPanel.getOpacity()) < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        this.toolPanel.setOpacity(n);
    }

    private class MyKeyListener
    extends KeyAdapter {
        private boolean first = true;

        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        BitmapEditPanel.this.translateGlyph(this.first, 0, -1);
                        break;
                    }
                    case 40: {
                        BitmapEditPanel.this.translateGlyph(this.first, 0, 1);
                        break;
                    }
                    case 37: {
                        BitmapEditPanel.this.translateGlyph(this.first, -1, 0);
                        break;
                    }
                    case 39: {
                        BitmapEditPanel.this.translateGlyph(this.first, 1, 0);
                        break;
                    }
                    case 91: {
                        BitmapEditPanel.this.translateGlyphWidth(-1);
                        break;
                    }
                    case 93: {
                        BitmapEditPanel.this.translateGlyphWidth(1);
                        break;
                    }
                    case 66: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.PENCIL);
                        break;
                    }
                    case 80: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.PENCIL);
                        break;
                    }
                    case 69: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.ERASER);
                        break;
                    }
                    case 73: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.EYEDROPPER);
                        break;
                    }
                    case 76: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.LINE);
                        break;
                    }
                    case 82: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.RECTANGLE);
                        break;
                    }
                    case 70: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.FILLED_RECT);
                        break;
                    }
                    case 78: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.INVERT);
                        break;
                    }
                    case 77: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.MOVE);
                        break;
                    }
                    case 86: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.MOVE);
                        break;
                    }
                    case 72: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.GRABBER);
                        break;
                    }
                    case 32: {
                        BitmapEditPanel.this.toolPanel.setSelectedTool(BitmapTool.GRABBER);
                        break;
                    }
                    case 68: {
                        BitmapEditPanel.this.toolPanel.setOpacity(255);
                        break;
                    }
                    case 88: {
                        BitmapEditPanel.this.toolPanel.setOpacity(255 - BitmapEditPanel.this.toolPanel.getOpacity());
                        break;
                    }
                    case 192: {
                        BitmapEditPanel.this.toolPanel.setOpacity(0);
                        break;
                    }
                    case 49: {
                        BitmapEditPanel.this.toolPanel.setOpacity(25);
                        break;
                    }
                    case 50: {
                        BitmapEditPanel.this.toolPanel.setOpacity(51);
                        break;
                    }
                    case 51: {
                        BitmapEditPanel.this.toolPanel.setOpacity(76);
                        break;
                    }
                    case 52: {
                        BitmapEditPanel.this.toolPanel.setOpacity(102);
                        break;
                    }
                    case 53: {
                        BitmapEditPanel.this.toolPanel.setOpacity(127);
                        break;
                    }
                    case 54: {
                        BitmapEditPanel.this.toolPanel.setOpacity(153);
                        break;
                    }
                    case 55: {
                        BitmapEditPanel.this.toolPanel.setOpacity(178);
                        break;
                    }
                    case 56: {
                        BitmapEditPanel.this.toolPanel.setOpacity(204);
                        break;
                    }
                    case 57: {
                        BitmapEditPanel.this.toolPanel.setOpacity(229);
                        break;
                    }
                    case 48: {
                        BitmapEditPanel.this.toolPanel.setOpacity(255);
                        break;
                    }
                    case 45: {
                        BitmapEditPanel.this.translateOpacity(-1);
                        break;
                    }
                    case 61: {
                        BitmapEditPanel.this.translateOpacity(1);
                    }
                }
            }
            this.first = false;
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.first = true;
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BitmapEditPanel.this.glyphComponent.requestFocusInWindow();
        }
    }
}

