/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.PathExtensions;
import com.kreative.bitsnpicas.VectorInstruction;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorPath
extends AbstractList<VectorInstruction> {
    private final List<VectorInstruction> ops = new ArrayList<VectorInstruction>();

    public void append(GeneralPath generalPath) {
        this.append(generalPath, false);
    }

    public void append(GeneralPath generalPath, boolean bl) {
        double[] dArray = new double[8];
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    this.ops.add(new VectorInstruction(bl ? (char)'L' : 'M', dArray[0], dArray[1]));
                    bl = false;
                    break;
                }
                case 1: {
                    this.ops.add(new VectorInstruction('L', dArray[0], dArray[1]));
                    break;
                }
                case 2: {
                    this.ops.add(new VectorInstruction('Q', dArray[0], dArray[1], dArray[2], dArray[3]));
                    break;
                }
                case 3: {
                    this.ops.add(new VectorInstruction('C', dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
                    break;
                }
                case 4: {
                    this.ops.add(new VectorInstruction('Z', new Number[0]));
                }
            }
            pathIterator.next();
        }
    }

    public GeneralPath toGeneralPath() {
        PathExtensions pathExtensions = new PathExtensions();
        for (VectorInstruction vectorInstruction : this.ops) {
            pathExtensions.execute(vectorInstruction.getOperation(), vectorInstruction.getOperands());
        }
        return pathExtensions.getPath();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (VectorInstruction vectorInstruction : this.ops) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(vectorInstruction.toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean add(VectorInstruction vectorInstruction) {
        return this.ops.add(vectorInstruction);
    }

    @Override
    public void add(int n, VectorInstruction vectorInstruction) {
        this.ops.add(n, vectorInstruction);
    }

    @Override
    public boolean addAll(Collection<? extends VectorInstruction> collection) {
        return this.ops.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends VectorInstruction> collection) {
        return this.ops.addAll(n, collection);
    }

    @Override
    public void clear() {
        this.ops.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.ops.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.ops.containsAll(collection);
    }

    @Override
    public VectorInstruction get(int n) {
        return this.ops.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.ops.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.ops.isEmpty();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.ops.lastIndexOf(object);
    }

    @Override
    public boolean remove(Object object) {
        return this.ops.remove(object);
    }

    @Override
    public VectorInstruction remove(int n) {
        return this.ops.remove(n);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.ops.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.ops.retainAll(collection);
    }

    @Override
    public VectorInstruction set(int n, VectorInstruction vectorInstruction) {
        return this.ops.set(n, vectorInstruction);
    }

    @Override
    public int size() {
        return this.ops.size();
    }

    @Override
    public Object[] toArray() {
        return this.ops.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.ops.toArray(TArray);
    }
}

