/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends OutputStream {
    private final StringBuffer sb;
    private final OutputStream out;
    private final boolean pad;
    private int word = 0;
    private int count = 0;
    private static final char[] b64e = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public Base64OutputStream(StringBuffer stringBuffer) {
        this(stringBuffer, true);
    }

    public Base64OutputStream(OutputStream outputStream) {
        this(outputStream, true);
    }

    public Base64OutputStream(StringBuffer stringBuffer, boolean bl) {
        this.sb = stringBuffer;
        this.out = null;
        this.pad = bl;
    }

    public Base64OutputStream(OutputStream outputStream, boolean bl) {
        this.sb = null;
        this.out = outputStream;
        this.pad = bl;
    }

    public void write(int n) throws IOException {
        this.word <<= 8;
        this.word |= n & 0xFF;
        ++this.count;
        if (this.count >= 3) {
            this.writeWord();
            this.word = 0;
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        if (this.count > 0) {
            for (int i = this.count; i < 3; ++i) {
                this.word <<= 8;
            }
            this.writeWord();
        }
        this.word = 0;
        this.count = 0;
        if (this.out != null) {
            this.out.close();
        }
    }

    private void writeWord() throws IOException {
        int n = 18;
        for (int i = 0; i <= this.count; ++i) {
            char c = b64e[this.word >> n & 0x3F];
            if (this.sb != null) {
                this.sb.append(c);
            }
            if (this.out != null) {
                this.out.write(c);
            }
            n -= 6;
        }
        if (this.pad) {
            for (n = this.count; n < 3; ++n) {
                if (this.sb != null) {
                    this.sb.append('=');
                }
                if (this.out == null) continue;
                this.out.write(61);
            }
        }
    }
}

