//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//             progress.cpp - scan options and recovery                     //
//                                                                          //
//   Copyright (C) 1999-2002 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#pragma implementation "progress"
#include "progress.h"

#ifdef EBUG
extern ofstream dbug;
int 
Strcmp(const char *s1, const char *s2)
{
  int i = strcmp(s1, s2);

  // dbug << "STRCMP(" << s1 << "," << s2 << ") == " << i << ENTER;
  return i;
}
#else
#define Strcmp(a,b) strcmp(a,b)
#endif

extern void alloc_purge(void);

ProgressIndicator::ProgressIndicator(void)
{
  memset(xname, 0, SMALLB);
  memset(fname, 0, SMALLB);
  memset(confname, 0, SMALLB);
  memset(pidfile, 0, SMALLB);
  memset(progressfile, 0, SMALLB);
  memset(WebCgiFile, 0, SMALLB);
  strncpy(pidfile, PIDFILE, SMALLB);
  strncpy(progressfile, PROGRESS_FILE, SMALLB);
  strncpy(WebCgiFile, CGI_FILE, SMALLB);

  tstamp = time(NULL);
  fscan = -1;
  timeout = 5;
  pingonly = 0;
  stealth = 0;
  idle = 90;
#ifdef NSAT_PTHREADS
  maxproc = 4000;
#else
  maxproc = 200;
#endif
  maxlife = 180;
  dlog = 0;

  ipcur = 0;
  ipend = 0;
  fpos = 0;
  vhostip = 0;

  Foreground = 0;
  dist = 0;
  VerboseLogging = 0;
  ScanBackdoor = 0;
  ScanIcmp = 0;
  ScanNetstat = 0;
  ScanFtp = 0;
  ScanSsh = 0;
  ScanTelnet = 0;
  ScanSmtp = 0;
  ScanBind = 0;
  ScanFinger = 0;
  ScanPop2 = 0;
  ScanPop3 = 0;
  ScanRpc = 0;
  ScanNntp = 0;
  ScanSmb = 0;
  ScanImap = 0;
  ScanNlps = 0;
  ScanIrcd = 0;
  ScanXWin = 0;
  ScanNetBios = 0;
  ScanBackOrifice = 0;
  ScanOS = 0;
  ScanSnmp = 0;
  ScanWeb = 0;

  PortRange[0] = 0;
  PortRange[1] = 0;

  for (int i = 0; i < SMALLB; i++)
    Ports[i] = 0;
}

ProgressIndicator::~ProgressIndicator(void)
{
}

void 
ProgressIndicator::OldVerboseLevel(int lev)
{
  switch (lev)
    {
    case 0:
      VerboseLogging = 0;
      ScanBackdoor = 1;
      ScanIcmp = 0;
      ScanNetstat = 0;
      ScanFtp = 0;
      ScanSsh = 0;
      ScanTelnet = 0;
      ScanSmtp = 0;
      ScanBind = 1;
      ScanFinger = 0;
      ScanPop2 = 0;
      ScanPop3 = 1;
      ScanRpc = 1;
      ScanNntp = 0;
      ScanSmb = 1;
      ScanImap = 1;
      ScanNlps = 0;
      ScanIrcd = 0;
      ScanXWin = 0;
      ScanNetBios = 0;
      ScanBackOrifice = 0;
      ScanOS = 0;
      ScanSnmp = 0;
      ScanWeb = 1;
      Ports[0] = 1080;
      Ports[1] = 261;
      if (!stealth)
	cout << I_OLDV << 0 << ENTER;
      break;
    case 1:
      VerboseLogging = 1;
      ScanBackdoor = 0;
      ScanIcmp = 1;
      ScanNetstat = 1;
      ScanFtp = 1;
      ScanSsh = 1;
      ScanTelnet = 0;
      ScanSmtp = 2;
      ScanBind = 2;
      ScanFinger = 0;
      ScanPop2 = 1;
      ScanPop3 = 1;
      ScanRpc = 2;
      ScanNntp = 0;
      ScanSmb = 1;
      ScanImap = 1;
      ScanNlps = 0;
      ScanIrcd = 0;
      ScanXWin = 1;
      ScanNetBios = 1;
      ScanBackOrifice = 0;
      ScanOS = 1;
      ScanSnmp = 1;
      ScanWeb = 2;
      Ports[0] = 1080;
      Ports[1] = 261;
      Ports[2] = 19;
      Ports[3] = 515;
      Ports[4] = 666;
      Ports[5] = 1524;
      Ports[6] = 1114;
      if (!stealth)
	cout << I_OLDV << 1 << ENTER;
      break;
    case 2:
      VerboseLogging = 1;
      ScanBackdoor = 1;
      ScanIcmp = 1;
      ScanNetstat = 2;
      ScanFtp = 3;
      ScanSsh = 1;
      ScanTelnet = 1;
      ScanSmtp = 3;
      ScanBind = 2;
      ScanFinger = 1;
      ScanPop2 = 1;
      ScanPop3 = 1;
      ScanRpc = 2;
      ScanNntp = 1;
      ScanSmb = 1;
      ScanImap = 1;
      ScanNlps = 1;
      ScanIrcd = 1;
      ScanXWin = 1;
      ScanNetBios = 1;
      ScanBackOrifice = 1;
      ScanOS = 1;
      ScanSnmp = 1;
      ScanWeb = 2;
      Ports[0] = 1080;
      Ports[1] = 261;
      Ports[2] = 19;
      Ports[3] = 515;
      Ports[4] = 666;
      Ports[5] = 1524;
      Ports[6] = 1114;
      Ports[7] = 1;
      Ports[8] = 7;
      Ports[9] = 43;
      Ports[10] = 98;
      Ports[11] = 512;
      Ports[12] = 514;
      Ports[13] = 513;
      Ports[14] = 1525;
      Ports[15] = 8080;
      Ports[16] = 27665;
      if (!stealth)
	cout << I_OLDV << 2 << ENTER;
      break;
    case 3:
      VerboseLogging = 2;
      ScanBackdoor = 1;
      ScanIcmp = 2;
      ScanNetstat = 2;
      ScanFtp = 3;
      ScanSsh = 1;
      ScanTelnet = 3;
      ScanSmtp = 4;
      ScanBind = 2;
      ScanFinger = 2;
      ScanPop2 = 1;
      ScanPop3 = 1;
      ScanRpc = 4;
      ScanNntp = 1;
      ScanSmb = 1;
      ScanImap = 1;
      ScanNlps = 2;
      ScanIrcd = 2;
      ScanXWin = 2;
      ScanNetBios = 1;
      ScanBackOrifice = 1;
      ScanOS = 2;
      ScanSnmp = 1;
      ScanWeb = 2;
      Ports[0] = 1080;
      Ports[1] = 261;
      Ports[2] = 19;
      Ports[3] = 515;
      Ports[4] = 666;
      Ports[5] = 1524;
      Ports[6] = 1114;
      Ports[7] = 1;
      Ports[8] = 7;
      Ports[9] = 43;
      Ports[10] = 98;
      Ports[11] = 512;
      Ports[12] = 514;
      Ports[13] = 513;
      Ports[14] = 1525;
      Ports[15] = 8080;
      Ports[16] = 27665;
      if (!stealth)
	cout << I_OLDV << 3 << ENTER;
      break;
    default:
      if (!stealth)
	cout << "[*] Verbosity level " << lev << " unrecognized!\n";
    }
}

int ProgressIndicator::readconf(char *file)
{
  FILE *fp = fopen(file, "r");

  if (fp == NULL)
    {
      if (!stealth)
	cerr << "[*] config file not found: " << file << ENTER;
      exit(-1);
    }

  char rb[BUFSIZE];
  char *cp;

  memset(confname, 0, SMALLB);
  strncpy(confname, file, SMALLB);

  while (fgets(rb, BUFSIZE, fp) != NULL)
    {
      if (!isalpha(rb[0]))
	continue;
      if (rb[strlen(rb) - 1] == '\n')
	rb[strlen(rb) - 1] = '\0';
      strlower(rb);

      if ((cp = strtok(rb, " ")) == NULL)
	{
#ifndef PARANOID_CHECK
	  cerr << "Error parsing config line: " << rb << ENTER;
#else
	  cerr << "Error parsing config line!\n";
#endif
	  continue;
	}

      if (!Strcmp(cp, C_BD))
	{
	  ScanBackdoor = 1;
	  continue;
	}
      if (!Strcmp(cp, C_BIND1))
	{
	  ScanBind = 1;
	  continue;
	}
      if (!Strcmp(cp, C_BIND2))
	{
	  ScanBind = 2;
	  continue;
	}
      if (!Strcmp(cp, C_BO))
	{
	  ScanBackOrifice = 1;
	  continue;
	}
      if (!Strcmp(cp, C_FING1))
	{
	  ScanFinger = 1;
	  continue;
	}
      if (!Strcmp(cp, C_FING2))
	{
	  ScanFinger = 2;
	  continue;
	}
      if (!Strcmp(cp, C_FORE))
	{
	  Foreground = 1;
	  continue;
	}
      if (!Strcmp(cp, C_FTP1))
	{
	  ScanFtp = 1;
	  continue;
	}
      if (!Strcmp(cp, C_FTP2))
	{
	  ScanFtp = 2;
	  continue;
	}
      if (!Strcmp(cp, C_FTP3))
	{
	  ScanFtp = 3;
	  continue;
	}
      if (!Strcmp(cp, C_ICMP1))
	{
	  ScanIcmp = 1;
	  continue;
	}
      if (!Strcmp(cp, C_ICMP2))
	{
	  ScanIcmp = 2;
	  continue;
	}
      if (!Strcmp(cp, C_IMS))
	{
	  ScanImap = 1;
	  continue;
	}
      if (!Strcmp(cp, C_IRC1))
	{
	  ScanIrcd = 1;
	  continue;
	}
      if (!Strcmp(cp, C_IRC2))
	{
	  ScanIrcd = 2;
	  continue;
	}
      if (!Strcmp(cp, C_LS))
	{
	  stealth = 1;
	  continue;
	}
      if (!Strcmp(cp, C_NETBS))
	{
	  ScanNetBios = 1;
	  continue;
	}
      if (!Strcmp(cp, C_NLPS1))
	{
	  ScanNlps = 1;
	  continue;
	}
      if (!Strcmp(cp, C_NLPS2))
	{
	  ScanNlps = 2;
	  continue;
	}
      if (!Strcmp(cp, C_NNTPS))
	{
	  ScanNntp = 1;
	  continue;
	}
      if (!Strcmp(cp, C_NSTAT1))
	{
	  ScanNetstat = 1;
	  continue;
	}
      if (!Strcmp(cp, C_NSTAT2))
	{
	  ScanNetstat = 2;
	  continue;
	}
      if (!Strcmp(cp, C_PINGD))
	{
	  pingonly = 1;
	  continue;
	}
      if (!Strcmp(cp, C_POP2))
	{
	  ScanPop2 = 1;
	  continue;
	}
      if (!Strcmp(cp, C_POP3))
	{
	  ScanPop3 = 1;
	  continue;
	}
      if (!Strcmp(cp, C_RPC1))
	{
	  ScanRpc = 1;
	  continue;
	}
      if (!Strcmp(cp, C_RPC2))
	{
	  ScanRpc = 2;
	  continue;
	}
      if (!Strcmp(cp, C_RPC3))
	{
	  ScanRpc = 3;
	  continue;
	}
      if (!Strcmp(cp, C_RPC4))
	{
	  ScanRpc = 4;
	  continue;
	}
      if (!Strcmp(cp, C_SMBS))
	{
	  ScanSmb = 1;
	  continue;
	}
      if (!Strcmp(cp, C_SMTP1))
	{
	  ScanSmtp = 1;
	  continue;
	}
      if (!Strcmp(cp, C_SMTP2))
	{
	  ScanSmtp = 2;
	  continue;
	}
      if (!Strcmp(cp, C_SMTP3))
	{
	  ScanSmtp = 3;
	  continue;
	}
      if (!Strcmp(cp, C_SMTP4))
	{
	  ScanSmtp = 4;
	  continue;
	}
      if (!Strcmp(cp, C_SNMPS))
	{
	  ScanSnmp = 1;
	  continue;
	}
      if (!Strcmp(cp, C_SSHS))
	{
	  ScanSsh = 1;
	  continue;
	}
      if (!Strcmp(cp, C_TELNET1))
	{
	  ScanTelnet = 1;
	  continue;
	}
      if (!Strcmp(cp, C_TELNET2))
	{
	  ScanTelnet = 2;
	  continue;
	}
      if (!Strcmp(cp, C_TELNET3))
	{
	  ScanTelnet = 3;
	  continue;
	}
      if (!Strcmp(cp, C_TELNET4))
	{
	  ScanTelnet = 4;
	  continue;
	}
      if (!Strcmp(cp, C_WEB1))
	{
	  ScanWeb = 1;
	  continue;
	}
      if (!Strcmp(cp, C_WEB2))
	{
	  ScanWeb = 2;
	  continue;
	}
      if (!Strcmp(cp, C_WEB3))
	{
	  ScanWeb = 3;
	  continue;
	}
      if (!Strcmp(cp, C_WEB4))
	{
	  ScanWeb = 4;
	  continue;
	}
      if (!Strcmp(cp, C_WEB5))
	{
	  ScanWeb = 5;
	  continue;
	}
      if (!Strcmp(cp, C_XWIN1))
	{
	  ScanXWin = 1;
	  continue;
	}
      if (!Strcmp(cp, C_XWIN2))
	{
	  ScanXWin = 2;
	  continue;
	}
      if (!Strcmp(cp, C_LOGDIR))
	{
	  dlog = 1;
	  continue;
	}

      char cp2[SMALLB];

      strncpy(cp2, cp, SMALLB);

      if ((cp = strtok(NULL, " ")) == NULL)
	{
#ifndef PARANOID_CHECK
	  cerr << "Cannot parse parse config line (no value for option): " << rb << ENTER;
#else
	  cerr << "Cannot parse parse config line (no value for option)!\n";
#endif
	  continue;
	}

      if (!Strcmp(cp2, C_CT))
	{
	  timeout = atoi(cp);
	  continue;
	}
      if (!Strcmp(cp2, C_MLIFE))
	{
	  maxlife = atoi(cp);
	  continue;
	}
      if (!Strcmp(cp2, C_MPROC))
	{
	  maxproc = atoi(cp);
	  continue;
	}
      if (!Strcmp(cp2, C_OLDVERB))
	{
	  OldVerboseLevel(atoi(cp));
	  continue;
	}
      if (!Strcmp(cp2, C_LSI))
	{
	  idle = atoi(cp);
	  continue;
	}
      if (!Strcmp(cp2, C_CF))
	{
	  strncpy(WebCgiFile, cp, SMALLB);
	  continue;
	}
      if (!Strcmp(cp2, C_EXC))
	{
          FILE *xfp;
	  strncpy(xname, cp, SMALLB);
          xfp = fopen(xname, "r");
          if (xfp == NULL)
           {
            if (!stealth)
             cerr << "Cannot open exclude file!\n";
            continue;
           }
          while(exclude_parse(xfp));
          fclose(xfp);
	  continue;
	}
      if (!Strcmp(cp2, C_INPUT))
	{
	  strncpy(fname, cp, SMALLB);
	  continue;
	}
      if (!Strcmp(cp2, C_PIDF))
	{
	  strncpy(pidfile, cp, SMALLB);
	  continue;
	}
      if (!Strcmp(cp2, C_PROGRESS))
	{
	  strncpy(progressfile, cp, SMALLB);
	  continue;
	}
      if (!Strcmp(cp2, C_OS))
	{
	  ScanOS = atoi(cp);
	  continue;
	}
      if (!Strcmp(cp2, C_VHOST))
	{
	  vhostip = resolve(cp);
	  continue;
	}

      if (!Strcmp(cp2, C_PORT))
	{
	  for (int i = 0; i < SMALLB; i++)
	    if (Ports[i] == 0)
	      {
		Ports[i] = atoi(cp);
		break;
	      }
	  continue;
	}

      if (!Strcmp(cp2, C_PORTR))
	{
	  PortRange[0] = atoi(cp);
	  if ((cp = strtok(NULL, " -")) == NULL)
	    {
	      PortRange[0] = 0;
	      cerr << "Bad port range entry: " << rb << ENTER;
	    }
	  else
	    PortRange[1] = atoi(cp);
	  continue;
	}

#ifndef PARANOID_CHECK
      cerr << "Cannot parse parse config line (unknown option): " << rb << ENTER;
#else
      cerr << "Cannot parse parse config line (unknown option)!\n";
#endif

    }				// end while loop

  fclose(fp);
  return 1;
}

void
ProgressIndicator::update(long p)
{
  long now = time(NULL);

  if (fscan)
    fpos = p;
  else
    ipcur = p;
#ifdef EBUG
  dbug << "update. last store " << (now - tstamp) << "s ago\n";
#endif

  if (now - tstamp >= P_TIMER)
    {
      tstamp = now;
#ifdef EBUG
      dbug << "writing progress file...\n";
#endif
      store();
      alloc_purge();
    }
}

int
ProgressIndicator::store(void)
{
  FILE *fd;

#ifdef PARANOID_CHECK
  if (nicefile(progressfile))
    return (0);
#endif
  fd = fopen(progressfile, "w");
  if (fd == NULL)
    {
#ifdef EBUG
      dbug << "cannot write progress file: " << strerror(errno) << ENTER;
#endif
      return (0);
    }

  fprintf(fd, "%s\n%s\n%s\n%s\n",
	  confname, fname, WebCgiFile, pidfile);
  fprintf(fd, "%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%lu\n%ld\n%ld\n%ld\n%d\n%d",
	  tstamp, timeout, pingonly, stealth, idle, fscan, maxproc,
	  maxlife, Foreground, vhostip, ipcur, ipend, fpos, dist, dlog);

  fclose(fd);
  return (1);
}

int
ProgressIndicator::restore(void)
{
  FILE *fd;

#ifdef PARANOID_CHECK
  if (nicefile(progressfile))
    return (0);
#endif

  fd = fopen(progressfile, "r");
  if (fd == NULL)
    return (0);

  if (fgets(confname, SMALLB, fd) == NULL)
    goto dumb_trick;

  strchop(confname);
  if (confname[strlen(confname)-1] == '\n')
    confname[strlen(confname)-1] = '\0';
  readconf(confname);

  if (fgets(fname, SMALLB, fd) == NULL)
    goto dumb_trick;
  strchop(fname);
  if (confname[strlen(fname)-1] == '\n')
    confname[strlen(fname)-1] = '\0';

  if (fgets(WebCgiFile, SMALLB, fd) == NULL)
    goto dumb_trick;
  strchop(WebCgiFile);
  if (confname[strlen(WebCgiFile)-1] == '\n')
    confname[strlen(WebCgiFile)-1] = '\0';

  if (fgets(pidfile, SMALLB, fd) == NULL)
    goto dumb_trick;
  strchop(pidfile);
  if (confname[strlen(pidfile)-1] == '\n')
    confname[strlen(pidfile)-1] = '\0';

  if (fscanf(fd, "%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%lu\n%ld\n%ld\n%ld\n%d\n%d\n",
	     &tstamp, &timeout, &pingonly, &stealth, &idle, &fscan, &maxproc,
             &maxlife, &Foreground, &vhostip, &ipcur, &ipend, &fpos, &dist, &dlog) < 13)
    goto dumb_trick;

  fclose(fd);
  return (1);

dumb_trick:
  fclose(fd);
  cerr << "[*] error parsing recovery file\n";
  exit(-1);
  return (0);
}

void
ProgressIndicator::status(void)
{
  cout << "\n  [*]\t--  NSAT status information  --\n";
  cout << "  ping dependent: " << pingonly << "\tstealth: " << stealth << "\tsystem idle time: " << idle << "s\n";
  cout << "  timeout: " << timeout << "s\tmax. processes: " << maxproc << "\tmax. lifetime: " << maxlife << "s\n";

  if (fscan > 0)
    cout << "  scan type: file, input filename: " << fname << ENTER;
  else if (!fscan)
   {
    cout << "  scan type: ip range,\tstart: " << ntoa(ipcur);
    cout << "\tend: " << ntoa(ipend) << ENTER;
   }
  else
    cout << "  scan type: single host scan\n";

  cout << "  virtual host: " << (vhostip ? ntoa(vhostip) : "none") << "\tverbose logging: " << VerboseLogging << " port range: ";
  if (PortRange[0])
    cout << PortRange[0] << "-" << PortRange[1] << ENTER;
  else
    cout << "none\n";

  cout << "  targeted services/level:" << (ScanBackdoor ? " backdoor/1" : "") << (ScanSsh ? " ssh/1" : "") << (ScanPop2 ? " pop2/1" : "") << (ScanPop3 ? " pop3/1" : "") << (ScanNntp ? " nntp/1" : "") << (ScanSmb ? " smb/1" : "") << ENTER;
  cout << "  " << (ScanImap ? " imap/1" : "") << (ScanNetBios ? " netbios/1" : "") << (ScanBackOrifice ? " BO/1" : "") << (ScanSnmp ? " snmp/1" : "");
  if (ScanOS)
    cout << " remote-os/" << ScanOS;
  if (ScanIcmp)
    cout << " icmp/" << ScanIcmp;
  if (ScanNetstat)
    cout << " netstat/" << ScanNetstat;
  if (ScanFtp)
    cout << " ftp/" << ScanFtp;
  if (ScanBind)
    cout << " bind/" << ScanBind;
  cout << "\n  ";
  if (ScanFinger)
    cout << " finger/" << ScanFinger;
  if (ScanIrcd)
    cout << " ircd/" << ScanIrcd;
  if (ScanTelnet)
    cout << " telnet/" << ScanTelnet;
  if (ScanSmtp)
    cout << " smtp/" << ScanSmtp;
  if (ScanRpc)
    cout << " rpc/" << ScanRpc;
  if (ScanNlps)
    cout << " nlps/" << ScanNlps;
  if (ScanXWin)
    cout << " X11/" << ScanXWin;
  if (ScanWeb)
    cout << " http/" << ScanWeb;
  cout << ENTER;
  if (Ports[0])
    {
      cout << "  ports:";
      for (int i = 0; i < SMALLB; i++)
	{
	  if (!(Ports[i]))
	    break;
	  cout << " " << Ports[i];
	  if ((!(i % 10)) && (i))
	    cout << "\n   ";
	}
      cout << ENTER;
    }
  cout << "  [*] console output: " << Foreground << "\tlast update: " << time(NULL) - tstamp << "s ago\n\n";

  if (geteuid())
    cout << "\n\trunning as non-root (os scans and pings are disabled)\n";
}
