/* $Id: xprobe.h,v 1.1 2002/01/21 18:28:46 mixter Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef XPROBE_H
#define XPROBE_H

#include "../nsat.h"

#include <stdio.h>

#define IP_VERSION 4

#ifdef HAVE_STRING_H
#include <string.h>
#else /* ! STRING */
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#endif /* STRING */

#include <sys/param.h>

#ifndef bzero
#ifdef NOBZERO
#define bzero(x,y) memset((void *)x,(int)0,(size_t) y)
#define bcopy(x,y,z) memcpy((void *)y, (const void *)x, (size_t) z)
#endif /* NOBZERO */
#endif /* bzero*/

#include <stdlib.h>	
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <sys/time.h>
#ifdef __linux__ 
#define __FAVOR_BSD
#endif
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#ifndef __linux__
#include <netinet/ip_var.h>
#else /* __linux__ */
#include <sys/time.h>
#endif /* __linux__ */
#include <netinet/ip_icmp.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <net/if.h>
#include <net/ethernet.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <ctype.h>
#include <math.h>
#include <signal.h>

extern "C" {
#undef LITTLE_ENDIAN
#undef BIG_ENDIAN
#undef BYTE_ORDER
#include <pcap.h>
}

/* some types correction */
#if defined(__FreeBSD__) || defined(__linux__)
#define TIMEZONE_T struct timezone
#else
#define TIMEZONE_T unsigned long
#endif

typedef struct _rpack {
    ssize_t packsize;
    char *pkt;
    char *orig_pkt;
    struct ip *ip, *orig_ip;
    struct icmp *icmp;
} rpack_t;

/*
 * for portability reasons we maintain ipovly header here.
 */

typedef struct _ipovly {
        u_char  ih_x1[9];               /* (unused) */
        u_char  ih_pr;                  /* protocol */
        u_short ih_len;                 /* protocol length */
        struct  in_addr ih_src;         /* source internet address */
        struct  in_addr ih_dst;         /* destination internet address */
} ipovly_t;


typedef struct _interf {
    struct in_addr    addr;
    struct in_addr     net;
    struct in_addr netmask;
    char iname[IFNAMSIZ + 1];
} inter_t;

/* external vars */

extern char *optarg;
extern int optind;
extern inter_t interf;

/* locally defined external vars (for ref. from other modules */

extern char *iname; /* interface name we run on, could be NULL */
extern char verbose; /* verbosity flag */

/* function prototypes */

/* general use */
extern unsigned short in_cksum(unsigned short *,int);
struct in_addr get_iface_addr(char *);
unsigned short udp_cksum_calc(struct ip *, struct udphdr *, unsigned short );
void free_res(rpack_t **);

/* icmp routines */    
extern int wait_icmp(int , struct sockaddr_in *, unsigned char *, int );
extern int udp_find_closed(struct sockaddr_in);
extern rpack_t *send_udp(struct sockaddr_in);
extern rpack_t *send_icmpts_req(struct sockaddr_in);
extern rpack_t *send_icmpmaskreq_req(struct sockaddr_in);
extern rpack_t *send_icmpireq_req(struct sockaddr_in);
extern rpack_t *send_icmpecho_req(struct sockaddr_in);
rpack_t *send_icmpecho_var_req(struct sockaddr_in, int);
extern int do_logic(unsigned int);
void tree_message(const char *,...);
void fin_message(const char *);
void hexdump(unsigned char *, ssize_t);
int init_pcap(char *, char *);
unsigned char *next_pack(ssize_t *);
unsigned char *read_icmp(ssize_t  *, int, int);
void read_icmp_timeout(int sig);

/* packet test routines (pkt_exams.c) */
int udp_checksum_ver(rpack_t *);
int icmp_unreach_lencheck(rpack_t *);
int frag_bits_flipped(rpack_t *);
int ip_checksum_ok(rpack_t *);

#include "xp_defines.h"

extern Logging Logger;
extern ProgressIndicator pi;
#ifdef EBUG
extern ofstream dbug;
#endif

extern unsigned int xphost;

#endif /* XPROBE_H */
