/* $Id: xp_utils.c,v 1.1 2002/01/21 18:28:46 mixter Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "xprobe.h"

unsigned int xphost = 0;

/*
 * Checksum routine for Internet Protocol family headers (C Version)
 */
unsigned short
in_cksum(unsigned short *addr, int len)
{
	register int nleft = len;
	register unsigned short *w = addr;
	register unsigned short answer;
	register int sum = 0;

	/*
	 *  Our algorithm is simple, using a 32 bit accumulator (sum),
	 *  we add sequential 16 bit words to it, and at the end, fold
	 *  back all the carry bits from the top 16 bits into the lower
	 *  16 bits.
	 */
	while (nleft > 1)  {
		sum += *w++;
		nleft -= 2;
	}

	/* mop up an odd byte, if necessary */
	if (nleft == 1)
		sum += *(u_char *)w;

	/*
	 * add back carry outs from top 16 bits to low 16 bits
	 */
	sum = (sum >> 16) + (sum & 0xffff);	/* add hi 16 to low 16 */
	sum += (sum >> 16);			/* add carry */
	answer = ~sum;				/* truncate to 16 bits */
	return (answer);
}

void tree_message(const char *format,...) {
#ifdef EBUG
    va_list ap;
    
    va_start(ap, format);
    fprintf(stderr,"TREE: ");
    vfprintf(stderr, format, ap);
    fprintf(stderr,"\n");
    va_end(ap);
#endif
}

void fin_message(const char *message) {
	Logger.msg(L_OS, I_OS, ntoa(xphost), "- %s", message);
}

void hexdump(unsigned char *ptr, ssize_t len) {

    if (len<0 || !ptr) return;
#ifdef EBUG
    while(len--) 
        fprintf(stderr,"%02x%c", *ptr++ & 0xff,
        len % 16? ' ':'\n');
#endif
}

void free_res(rpack_t **rpack) {

    if (!*rpack) return;
    if ((*rpack)->orig_pkt) free((*rpack)->orig_pkt);
    if ((*rpack)->pkt)      free((*rpack)->pkt);
    free(*rpack);
    *rpack = NULL;

}

struct in_addr get_iface_addr(char *iname) {
    struct ifreq ifr;
    int sd;
    struct in_addr retval;
    struct sockaddr_in *sin;

    if((sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
        perror("socket");
    }

    strncpy(ifr.ifr_name, iname, sizeof(ifr.ifr_name));

    if (ioctl(sd, SIOCGIFADDR,(char *)&ifr) < 0) {
        perror("ioctl(SIOCGIFADDR)");
        close(sd);
    }
    close(sd);
    sin = (struct sockaddr_in *) &ifr.ifr_addr;
memcpy((void *)&retval, (void *)&(sin->sin_addr.s_addr), sizeof(retval));
    return retval;
}

/* udp packet checksum calculation.. length _SHOULD_ include udpheader
 * lenghth
 */
unsigned short udp_cksum_calc(struct ip *ip, struct udphdr *udp, unsigned short length) {
     ipovly_t  *ipov;
     unsigned char *buf;
     struct udphdr *ludp;
     unsigned short cksum;

     if((buf=(unsigned char *)calloc(sizeof(ipovly_t) + length, 1))== NULL) {
         perror("calloc");
         return 0;
     }
     memcpy((void *)(buf + sizeof(ipovly_t)), (void *)udp, length);
     ipov = (ipovly_t *)buf;
     ludp = (struct udphdr *)(ipov + 1);
     ipov->ih_src = ip->ip_src;
     ipov->ih_dst = ip->ip_dst;
     ipov->ih_pr  = ip->ip_p;
     ipov->ih_len = htons(length);
     ludp->uh_sum = 0;
     cksum = in_cksum((unsigned short *)buf, length);
     if (!cksum)
         cksum = 0xffff;
     return cksum;
}
