//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//                 www.h - minimal default cgi list                         //
//                                                                          //
//   Copyright (C) 1999-2001 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef NSAT_WWW_H

extern ProgressIndicator pi;

#ifdef EBUG
extern ofstream dbug;
#endif

typedef struct {
 char *n;
 int scan;
} htdirrec;

#define ACCESS_FORBIDDEN_MEANS_DIRS_EXIST

int counter, sock;
char whost[BUFSIZE];
void http_get(char *, char *, struct sockaddr_in *, int); int y2ksucks(char *);
void http_prescan_dir(htdirrec *d, char *whost, struct sockaddr_in *sin, int slen);

// variable list of directories and sub-directories to test
htdirrec www_cgidirs[] =
{
 {"/cgi-bin/", 0},
 {"/cgi-dos/", 0},
 {"/cgi-shl/", 0},
 {"/cgi-win/", 0},
 {"/cgi-bin/", 0},
 {"/bb-dnbd/", 0},
 {"/.html/", 0},
 {"/iisadmpwd/", 0},
 {"/iissamples/", 0},
 {"/samples/", 0},
 {"/scripts/", 0},
 {"/scripts/iisadmin/", 0},
 {"/scripts/samples/", 0},
 {"/scripts/tools/", 0},
 {"/siteserver/publishing/", 0},
 {"/sites/knowledge/membership/", 0},
 {"/sites/samples/knowledge/", 0},
 {"/msadc/", 0},
 {"/msads/samples/", 0},
 {"/include/", 0},
 {"/cfappman/", 0},
 {"/cfdocs/", 0},
 {"/cfusion/cfapps/forums/", 0},
 {"/_vti_bin/", 0},
 {"/PSUser/", 0},
 {"/orders/", 0},
 {"/photoads/", 0},
 {"/PDG_Cart/", 0},
 {"/piranha/secure/", 0},
 {"/admisapi/", 0},
 {"/_private/", 0},
 {"EOF", 0}
};

// small list of default cgi's...
// these are used if no CGI file is found
// lets try to keep this small but efficient

char *www_cgibin[] =
{
  "/.html/............/autoexec.bat",
  "/_vti_bin/shtml.dll",
  "/_vti_bin/shtml.exe",
  "/_vti_inf.html",
  "/cgi-bin/cachemgr.cgi",
  "/msadc/msadcs.dll",
  "/msadc/samples/selector/showcode.asp",
  "/scripts/samples/details.idc",
  "/scripts/tools/newdsn.exe",
  "/scripts/../../cmd.exe",
  "/secure/.htaccess",
  "/cfdocs/expeval/openfile.cfm",
  "/cgi-bin/architext_query.pl",
  "/cgi-bin/ax-admin.cgi",
  "/cgi-bin/bnbform.cgi",
  "/cgi-bin/campas",
  "/cgi-bin/Count.cgi",
  "/cgi-bin/finger.pl",
  "/cgi-bin/man.sh",
  "/cgi-bin/perl",
  "/cgi-bin/perl.exe",
  "/cgi-bin/perlshop.cgi",
  "/cgi-bin/pfdisplay.cgi",
  "/cgi-bin/phf",
  "/cgi-bin/php",
  "/cgi-bin/php.cgi",
  "/cgi-bin/tcsh",
  "/cgi-bin/w3-msql",
  "/cgi-bin/webdist.cgi",
  "/iisadmpwd/achg.htr",
  "/orders/order.log",
  "/publisher/|publisher",
  "/WebShop/logs/cc.txt",
  "EOF"
};

#define NSAT_WWW_H
#endif
