/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.Installer;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class Debug {
    public static final String DLOG = "LOG";
    public static final String DSTACKTRACE = "STACKTRACE";
    public static final String DTRACE = "TRACE";
    public static final String IZPACK_LOGFILE = "izpack.logfile";
    public static final int LOG_WITHOUT_DATE = 0;
    public static final int LOG_WITH_DATE = 1;
    public static final int LOG_WITH_TIME_STAMP = 2;
    public static final int LOG_WITH_TIME_AND_DATE = 3;
    private static boolean TRACE;
    private static boolean STACKTRACE;
    private static boolean LOG;
    public static String LOGFILE_PREFIX;
    public static String LOGFILE_EXTENSION;
    public static String LOGFILENAME;
    public static boolean LOG_TRACE_STATEMENTS;

    public static void trace(Object object) {
        if (TRACE) {
            if (LOG_TRACE_STATEMENTS) {
                Debug.log(object);
            }
            System.out.println(object);
            if (STACKTRACE && object instanceof Throwable) {
                ((Throwable)object).printStackTrace();
            }
            System.out.flush();
        }
    }

    public static void error(Object object) {
        Debug.trace(object);
        System.err.println(object);
        System.err.flush();
        Debug.log(object);
    }

    public static void log(Object object) {
        Debug.log(object, 3);
    }

    public static void log(Object object, int n) {
        if (LOG) {
            PrintWriter printWriter = Debug.getLogFile();
            if (printWriter == null) {
                printWriter = Debug.createLogFile();
            }
            if (printWriter != null) {
                if (object == null) {
                    object = "null";
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (Debug.logWithTimeStamp(n)) {
                    stringBuffer.append(System.currentTimeMillis());
                    stringBuffer.append(';');
                    stringBuffer.append(' ');
                }
                if (Debug.logWithDate(n)) {
                    stringBuffer.append(new Date());
                    stringBuffer.append(';');
                    stringBuffer.append(' ');
                }
                stringBuffer.append(object);
                printWriter.println(stringBuffer.toString());
                if (object instanceof Throwable) {
                    ((Throwable)object).printStackTrace(printWriter);
                }
                printWriter.flush();
            } else {
                System.err.println("Cannot write into logfile: (" + printWriter + ") <- '" + object + "'");
            }
        }
    }

    private static boolean logWithDate(int n) {
        return (n & 1) == 1;
    }

    private static boolean logWithTimeStamp(int n) {
        return (n & 1) == 1;
    }

    private static PrintWriter createLogFile() {
        PrintWriter printWriter;
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(string);
        try {
            file.mkdirs();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        String string2 = LOGFILENAME;
        System.out.println("creating Logfile: '" + string2 + "' in: '" + string + "'");
        File file2 = new File(string, string2);
        if (file.canWrite()) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
                printWriter = Debug.setLogFile(new PrintWriter(bufferedWriter));
            }
            catch (Exception exception) {
                printWriter = null;
                exception.printStackTrace();
            }
        } else {
            printWriter = null;
            System.err.println("Fatal: cannot write File: '" + string2 + "' into: " + file);
        }
        return printWriter;
    }

    public static boolean tracing() {
        return TRACE;
    }

    public static boolean stackTracing() {
        return STACKTRACE;
    }

    public static boolean isLOG() {
        return LOG;
    }

    public static void setLOG(boolean bl) {
        System.out.println("LOG = " + bl);
        LOG = bl;
    }

    public static boolean isSTACKTRACE() {
        return STACKTRACE;
    }

    public static void setSTACKTRACE(boolean bl) {
        System.out.println("STACKTRACE = " + bl);
        STACKTRACE = bl;
    }

    public static boolean isTRACE() {
        return TRACE;
    }

    public static void setTRACE(boolean bl) {
        System.out.println("TRACE = " + bl);
        TRACE = bl;
    }

    public static PrintWriter getLogFile() {
        PrintWriter printWriter = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        return printWriter;
    }

    public static synchronized PrintWriter setLogFile(PrintWriter printWriter) {
        System.getProperties().put(IZPACK_LOGFILE, printWriter);
        PrintWriter printWriter2 = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        if (printWriter2 == null) {
            System.err.println("Set::logfile == null");
        }
        return printWriter2;
    }

    static {
        LOGFILE_PREFIX = "IzPack_Logfile_at_";
        LOGFILE_EXTENSION = ".txt";
        LOGFILENAME = LOGFILE_PREFIX + System.currentTimeMillis() + LOGFILE_EXTENSION;
        LOG_TRACE_STATEMENTS = false;
        boolean bl = false;
        try {
            bl = Boolean.getBoolean(DSTACKTRACE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        STACKTRACE = bl;
        boolean bl2 = false;
        try {
            bl2 = Boolean.getBoolean(DLOG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG = bl2;
        boolean bl3 = false;
        try {
            bl3 = STACKTRACE ? true : Boolean.getBoolean(DTRACE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TRACE = bl3;
        if (LOG) {
            System.out.println("LOG enabled.");
            PrintWriter printWriter = Debug.createLogFile();
            Debug.log(Installer.class.getName() + " LogFile created at ");
            Debug.log("System.Properties:", 2);
            Properties properties = System.getProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Debug.log(string + "  =  " + properties.getProperty(string), 0);
            }
            Debug.log("\n==========================================\n", 0);
            Debug.log("\n " + Installer.class.getName() + " installs on: \n", 0);
            Debug.log(OsVersion.getOsDetails(), 0);
            Debug.log("\n==========================================\n", 0);
        }
        if (TRACE) {
            System.out.println("TRACE enabled.");
        }
        if (STACKTRACE) {
            System.out.println("STACKTRACE enabled.");
        }
    }
}

