// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkebackup/v1/restore.proto

package gkebackup

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible values for state of the Restore.
type Restore_State int32

const (
	// The Restore resource is in the process of being created.
	Restore_STATE_UNSPECIFIED Restore_State = 0
	// The Restore resource has been created and the associated RestoreJob
	// Kubernetes resource has been injected into target cluster.
	Restore_CREATING Restore_State = 1
	// The gkebackup agent in the cluster has begun executing the restore
	// operation.
	Restore_IN_PROGRESS Restore_State = 2
	// The restore operation has completed successfully. Restored workloads may
	// not yet be operational.
	Restore_SUCCEEDED Restore_State = 3
	// The restore operation has failed.
	Restore_FAILED Restore_State = 4
	// This Restore resource is in the process of being deleted.
	Restore_DELETING Restore_State = 5
)

// Enum value maps for Restore_State.
var (
	Restore_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "IN_PROGRESS",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "DELETING",
	}
	Restore_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"IN_PROGRESS":       2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"DELETING":          5,
	}
)

func (x Restore_State) Enum() *Restore_State {
	p := new(Restore_State)
	*p = x
	return p
}

func (x Restore_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Restore_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[0].Descriptor()
}

func (Restore_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[0]
}

func (x Restore_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Restore_State.Descriptor instead.
func (Restore_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{0, 0}
}

// Defines how volume data should be restored
type RestoreConfig_VolumeDataRestorePolicy int32

const (
	// Unspecified (illegal).
	RestoreConfig_VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED RestoreConfig_VolumeDataRestorePolicy = 0
	// For each PVC to be restored, will create a new underlying volume (and PV)
	// from the corresponding VolumeBackup contained within the Backup.
	RestoreConfig_RESTORE_VOLUME_DATA_FROM_BACKUP RestoreConfig_VolumeDataRestorePolicy = 1
	// For each PVC to be restored, attempt to reuse the original PV contained
	// in the Backup (with its original underlying volume).  Note that option
	// is likely only usable when restoring a workload to its original cluster.
	RestoreConfig_REUSE_VOLUME_HANDLE_FROM_BACKUP RestoreConfig_VolumeDataRestorePolicy = 2
	// For each PVC to be restored, PVCs will be created without any particular
	// action to restore data.  In this case, the normal Kubernetes provisioning
	// logic would kick in, and this would likely result in either dynamically
	// provisioning blank PVs or binding to statically provisioned PVs.
	RestoreConfig_NO_VOLUME_DATA_RESTORATION RestoreConfig_VolumeDataRestorePolicy = 3
)

// Enum value maps for RestoreConfig_VolumeDataRestorePolicy.
var (
	RestoreConfig_VolumeDataRestorePolicy_name = map[int32]string{
		0: "VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED",
		1: "RESTORE_VOLUME_DATA_FROM_BACKUP",
		2: "REUSE_VOLUME_HANDLE_FROM_BACKUP",
		3: "NO_VOLUME_DATA_RESTORATION",
	}
	RestoreConfig_VolumeDataRestorePolicy_value = map[string]int32{
		"VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED": 0,
		"RESTORE_VOLUME_DATA_FROM_BACKUP":        1,
		"REUSE_VOLUME_HANDLE_FROM_BACKUP":        2,
		"NO_VOLUME_DATA_RESTORATION":             3,
	}
)

func (x RestoreConfig_VolumeDataRestorePolicy) Enum() *RestoreConfig_VolumeDataRestorePolicy {
	p := new(RestoreConfig_VolumeDataRestorePolicy)
	*p = x
	return p
}

func (x RestoreConfig_VolumeDataRestorePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreConfig_VolumeDataRestorePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[1].Descriptor()
}

func (RestoreConfig_VolumeDataRestorePolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[1]
}

func (x RestoreConfig_VolumeDataRestorePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreConfig_VolumeDataRestorePolicy.Descriptor instead.
func (RestoreConfig_VolumeDataRestorePolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 0}
}

// Defines the behavior for handling the situation where cluster-scoped
// resources being restored already exist in the target cluster.
type RestoreConfig_ClusterResourceConflictPolicy int32

const (
	// Unspecified. Only allowed if no cluster-scoped resources will be
	// restored.
	RestoreConfig_CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED RestoreConfig_ClusterResourceConflictPolicy = 0
	// Do not attempt to restore the conflicting resource.
	RestoreConfig_USE_EXISTING_VERSION RestoreConfig_ClusterResourceConflictPolicy = 1
	// Delete the existing version before re-creating it from the Backup.
	// Note that this is a dangerous option which could cause unintentional
	// data loss if used inappropriately - for example, deleting a CRD will
	// cause Kubernetes to delete all CRs of that type.
	RestoreConfig_USE_BACKUP_VERSION RestoreConfig_ClusterResourceConflictPolicy = 2
)

// Enum value maps for RestoreConfig_ClusterResourceConflictPolicy.
var (
	RestoreConfig_ClusterResourceConflictPolicy_name = map[int32]string{
		0: "CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED",
		1: "USE_EXISTING_VERSION",
		2: "USE_BACKUP_VERSION",
	}
	RestoreConfig_ClusterResourceConflictPolicy_value = map[string]int32{
		"CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED": 0,
		"USE_EXISTING_VERSION":                         1,
		"USE_BACKUP_VERSION":                           2,
	}
)

func (x RestoreConfig_ClusterResourceConflictPolicy) Enum() *RestoreConfig_ClusterResourceConflictPolicy {
	p := new(RestoreConfig_ClusterResourceConflictPolicy)
	*p = x
	return p
}

func (x RestoreConfig_ClusterResourceConflictPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreConfig_ClusterResourceConflictPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[2].Descriptor()
}

func (RestoreConfig_ClusterResourceConflictPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[2]
}

func (x RestoreConfig_ClusterResourceConflictPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreConfig_ClusterResourceConflictPolicy.Descriptor instead.
func (RestoreConfig_ClusterResourceConflictPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 1}
}

// Defines the behavior for handling the situation where sets of namespaced
// resources being restored already exist in the target cluster.
type RestoreConfig_NamespacedResourceRestoreMode int32

const (
	// Unspecified (invalid).
	RestoreConfig_NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED RestoreConfig_NamespacedResourceRestoreMode = 0
	// When conflicting top-level resources (either Namespaces or
	// ProtectedApplications, depending upon the scope) are encountered, this
	// will first trigger a delete of the conflicting resource AND ALL OF ITS
	// REFERENCED RESOURCES (e.g., all resources in the Namespace or all
	// resources referenced by the ProtectedApplication) before restoring the
	// resources from the Backup. This mode should only be used when you are
	// intending to revert some portion of a cluster to an earlier state.
	RestoreConfig_DELETE_AND_RESTORE RestoreConfig_NamespacedResourceRestoreMode = 1
	// If conflicting top-level resources (either Namespaces or
	// ProtectedApplications, depending upon the scope) are encountered at the
	// beginning of a restore process, the Restore will fail.  If a conflict
	// occurs during the restore process itself (e.g., because an out of band
	// process creates conflicting resources), a conflict will be reported.
	RestoreConfig_FAIL_ON_CONFLICT RestoreConfig_NamespacedResourceRestoreMode = 2
)

// Enum value maps for RestoreConfig_NamespacedResourceRestoreMode.
var (
	RestoreConfig_NamespacedResourceRestoreMode_name = map[int32]string{
		0: "NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED",
		1: "DELETE_AND_RESTORE",
		2: "FAIL_ON_CONFLICT",
	}
	RestoreConfig_NamespacedResourceRestoreMode_value = map[string]int32{
		"NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED": 0,
		"DELETE_AND_RESTORE":                           1,
		"FAIL_ON_CONFLICT":                             2,
	}
)

func (x RestoreConfig_NamespacedResourceRestoreMode) Enum() *RestoreConfig_NamespacedResourceRestoreMode {
	p := new(RestoreConfig_NamespacedResourceRestoreMode)
	*p = x
	return p
}

func (x RestoreConfig_NamespacedResourceRestoreMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreConfig_NamespacedResourceRestoreMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[3].Descriptor()
}

func (RestoreConfig_NamespacedResourceRestoreMode) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[3]
}

func (x RestoreConfig_NamespacedResourceRestoreMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreConfig_NamespacedResourceRestoreMode.Descriptor instead.
func (RestoreConfig_NamespacedResourceRestoreMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 2}
}

// Represents both a request to Restore some portion of a Backup into
// a target GKE cluster and a record of the restore operation itself.
// Next id: 18
type Restore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full name of the Restore resource.
	// Format: projects/*/locations/*/restorePlans/*/restores/*
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server generated global unique identifier of
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The timestamp when this Restore resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this Restore resource was last
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User specified descriptive string for this Restore.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. A reference to the [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which this Restore
	// will restore. Note that this Backup must be a sub-resource of the
	// RestorePlan's [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan].
	// Format: projects/*/locations/*/backupPlans/*/backups/*.
	Backup string `protobuf:"bytes,6,opt,name=backup,proto3" json:"backup,omitempty"`
	// Output only. The target cluster into which this Restore will restore data.
	// Valid formats:
	//
	//   - projects/*/locations/*/clusters/*
	//   - projects/*/zones/*/clusters/*
	//
	// Inherited from parent RestorePlan's [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
	Cluster string `protobuf:"bytes,7,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Output only. Configuration of the Restore.  Inherited from parent RestorePlan's
	// [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
	RestoreConfig *RestoreConfig `protobuf:"bytes,8,opt,name=restore_config,json=restoreConfig,proto3" json:"restore_config,omitempty"`
	// A set of custom labels supplied by user.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The current state of the Restore.
	State Restore_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.gkebackup.v1.Restore_State" json:"state,omitempty"`
	// Output only. Human-readable description of why the Restore is in its current state.
	StateReason string `protobuf:"bytes,11,opt,name=state_reason,json=stateReason,proto3" json:"state_reason,omitempty"`
	// Output only. Timestamp of when the restore operation completed.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Output only. Number of resources restored during the restore execution.
	ResourcesRestoredCount int32 `protobuf:"varint,13,opt,name=resources_restored_count,json=resourcesRestoredCount,proto3" json:"resources_restored_count,omitempty"`
	// Output only. Number of resources excluded during the restore execution.
	ResourcesExcludedCount int32 `protobuf:"varint,14,opt,name=resources_excluded_count,json=resourcesExcludedCount,proto3" json:"resources_excluded_count,omitempty"`
	// Output only. Number of resources that failed to be restored during the restore
	// execution.
	ResourcesFailedCount int32 `protobuf:"varint,15,opt,name=resources_failed_count,json=resourcesFailedCount,proto3" json:"resources_failed_count,omitempty"`
	// Output only. Number of volumes restored during the restore execution.
	VolumesRestoredCount int32 `protobuf:"varint,16,opt,name=volumes_restored_count,json=volumesRestoredCount,proto3" json:"volumes_restored_count,omitempty"`
	// Output only. `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a restore from overwriting each other.
	// It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform restore updates in order to avoid
	// race conditions: An `etag` is returned in the response to `GetRestore`,
	// and systems are expected to put that etag in the request to
	// `UpdateRestore` or `DeleteRestore` to ensure that their change will be
	// applied to the same version of the resource.
	Etag string `protobuf:"bytes,17,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Restore) Reset() {
	*x = Restore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Restore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Restore) ProtoMessage() {}

func (x *Restore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Restore.ProtoReflect.Descriptor instead.
func (*Restore) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{0}
}

func (x *Restore) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Restore) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Restore) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Restore) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Restore) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Restore) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

func (x *Restore) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *Restore) GetRestoreConfig() *RestoreConfig {
	if x != nil {
		return x.RestoreConfig
	}
	return nil
}

func (x *Restore) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Restore) GetState() Restore_State {
	if x != nil {
		return x.State
	}
	return Restore_STATE_UNSPECIFIED
}

func (x *Restore) GetStateReason() string {
	if x != nil {
		return x.StateReason
	}
	return ""
}

func (x *Restore) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *Restore) GetResourcesRestoredCount() int32 {
	if x != nil {
		return x.ResourcesRestoredCount
	}
	return 0
}

func (x *Restore) GetResourcesExcludedCount() int32 {
	if x != nil {
		return x.ResourcesExcludedCount
	}
	return 0
}

func (x *Restore) GetResourcesFailedCount() int32 {
	if x != nil {
		return x.ResourcesFailedCount
	}
	return 0
}

func (x *Restore) GetVolumesRestoredCount() int32 {
	if x != nil {
		return x.VolumesRestoredCount
	}
	return 0
}

func (x *Restore) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Configuration of a restore.
// Next id: 9
type RestoreConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the mechanism to be used to restore volume data.
	// Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
	// NO_VOLUME_DATA_RESTORATION).
	VolumeDataRestorePolicy RestoreConfig_VolumeDataRestorePolicy `protobuf:"varint,1,opt,name=volume_data_restore_policy,json=volumeDataRestorePolicy,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_VolumeDataRestorePolicy" json:"volume_data_restore_policy,omitempty"`
	// Defines the behavior for handling the situation where cluster-scoped
	// resources being restored already exist in the target cluster. This MUST be
	// set to a value other than CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
	// [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope] is not empty.
	ClusterResourceConflictPolicy RestoreConfig_ClusterResourceConflictPolicy `protobuf:"varint,2,opt,name=cluster_resource_conflict_policy,json=clusterResourceConflictPolicy,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_ClusterResourceConflictPolicy" json:"cluster_resource_conflict_policy,omitempty"`
	// Defines the behavior for handling the situation where sets of namespaced
	// resources being restored already exist in the target cluster. This MUST be
	// set to a value other than NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
	NamespacedResourceRestoreMode RestoreConfig_NamespacedResourceRestoreMode `protobuf:"varint,3,opt,name=namespaced_resource_restore_mode,json=namespacedResourceRestoreMode,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_NamespacedResourceRestoreMode" json:"namespaced_resource_restore_mode,omitempty"`
	// Identifies the cluster-scoped resources to restore from the Backup.
	// Not specifying it means NO cluster resource will be restored.
	ClusterResourceRestoreScope *RestoreConfig_ClusterResourceRestoreScope `protobuf:"bytes,4,opt,name=cluster_resource_restore_scope,json=clusterResourceRestoreScope,proto3" json:"cluster_resource_restore_scope,omitempty"`
	// Specifies the namespaced resources to restore from the Backup.
	// Only one of the entries may be specified. If not specified, NO namespaced
	// resources will be restored.
	//
	// Types that are assignable to NamespacedResourceRestoreScope:
	//	*RestoreConfig_AllNamespaces
	//	*RestoreConfig_SelectedNamespaces
	//	*RestoreConfig_SelectedApplications
	NamespacedResourceRestoreScope isRestoreConfig_NamespacedResourceRestoreScope `protobuf_oneof:"namespaced_resource_restore_scope"`
	// A list of transformation rules to be applied against Kubernetes resources
	// as they are selected for restoration from a Backup. Rules are executed in
	// order defined - this order matters, as changes made by a rule may impact
	// the filtering logic of subsequent rules. An empty list means no
	// substitution will occur.
	SubstitutionRules []*RestoreConfig_SubstitutionRule `protobuf:"bytes,8,rep,name=substitution_rules,json=substitutionRules,proto3" json:"substitution_rules,omitempty"`
}

func (x *RestoreConfig) Reset() {
	*x = RestoreConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig) ProtoMessage() {}

func (x *RestoreConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig.ProtoReflect.Descriptor instead.
func (*RestoreConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1}
}

func (x *RestoreConfig) GetVolumeDataRestorePolicy() RestoreConfig_VolumeDataRestorePolicy {
	if x != nil {
		return x.VolumeDataRestorePolicy
	}
	return RestoreConfig_VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED
}

func (x *RestoreConfig) GetClusterResourceConflictPolicy() RestoreConfig_ClusterResourceConflictPolicy {
	if x != nil {
		return x.ClusterResourceConflictPolicy
	}
	return RestoreConfig_CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED
}

func (x *RestoreConfig) GetNamespacedResourceRestoreMode() RestoreConfig_NamespacedResourceRestoreMode {
	if x != nil {
		return x.NamespacedResourceRestoreMode
	}
	return RestoreConfig_NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED
}

func (x *RestoreConfig) GetClusterResourceRestoreScope() *RestoreConfig_ClusterResourceRestoreScope {
	if x != nil {
		return x.ClusterResourceRestoreScope
	}
	return nil
}

func (m *RestoreConfig) GetNamespacedResourceRestoreScope() isRestoreConfig_NamespacedResourceRestoreScope {
	if m != nil {
		return m.NamespacedResourceRestoreScope
	}
	return nil
}

func (x *RestoreConfig) GetAllNamespaces() bool {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_AllNamespaces); ok {
		return x.AllNamespaces
	}
	return false
}

func (x *RestoreConfig) GetSelectedNamespaces() *Namespaces {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_SelectedNamespaces); ok {
		return x.SelectedNamespaces
	}
	return nil
}

func (x *RestoreConfig) GetSelectedApplications() *NamespacedNames {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_SelectedApplications); ok {
		return x.SelectedApplications
	}
	return nil
}

func (x *RestoreConfig) GetSubstitutionRules() []*RestoreConfig_SubstitutionRule {
	if x != nil {
		return x.SubstitutionRules
	}
	return nil
}

type isRestoreConfig_NamespacedResourceRestoreScope interface {
	isRestoreConfig_NamespacedResourceRestoreScope()
}

type RestoreConfig_AllNamespaces struct {
	// Restore all namespaced resources in the Backup if set to "True".
	// Specifying this field to "False" is an error.
	AllNamespaces bool `protobuf:"varint,5,opt,name=all_namespaces,json=allNamespaces,proto3,oneof"`
}

type RestoreConfig_SelectedNamespaces struct {
	// A list of selected Namespaces to restore from the Backup. The listed
	// Namespaces and all resources contained in them will be restored.
	SelectedNamespaces *Namespaces `protobuf:"bytes,6,opt,name=selected_namespaces,json=selectedNamespaces,proto3,oneof"`
}

type RestoreConfig_SelectedApplications struct {
	// A list of selected ProtectedApplications to restore. The listed
	// ProtectedApplications and all the resources to which they refer will be
	// restored.
	SelectedApplications *NamespacedNames `protobuf:"bytes,7,opt,name=selected_applications,json=selectedApplications,proto3,oneof"`
}

func (*RestoreConfig_AllNamespaces) isRestoreConfig_NamespacedResourceRestoreScope() {}

func (*RestoreConfig_SelectedNamespaces) isRestoreConfig_NamespacedResourceRestoreScope() {}

func (*RestoreConfig_SelectedApplications) isRestoreConfig_NamespacedResourceRestoreScope() {}

// This is a direct map to the Kubernetes GroupKind type
// [GroupKind](https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind)
// and is used for identifying specific "types" of resources to restore.
type RestoreConfig_GroupKind struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// API group string of a Kubernetes resource, e.g.
	// "apiextensions.k8s.io", "storage.k8s.io", etc.
	// Note: use empty string for core API group
	ResourceGroup string `protobuf:"bytes,1,opt,name=resource_group,json=resourceGroup,proto3" json:"resource_group,omitempty"`
	// Kind of a Kubernetes resource, e.g.
	// "CustomResourceDefinition", "StorageClass", etc.
	ResourceKind string `protobuf:"bytes,2,opt,name=resource_kind,json=resourceKind,proto3" json:"resource_kind,omitempty"`
}

func (x *RestoreConfig_GroupKind) Reset() {
	*x = RestoreConfig_GroupKind{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_GroupKind) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_GroupKind) ProtoMessage() {}

func (x *RestoreConfig_GroupKind) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_GroupKind.ProtoReflect.Descriptor instead.
func (*RestoreConfig_GroupKind) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 0}
}

func (x *RestoreConfig_GroupKind) GetResourceGroup() string {
	if x != nil {
		return x.ResourceGroup
	}
	return ""
}

func (x *RestoreConfig_GroupKind) GetResourceKind() string {
	if x != nil {
		return x.ResourceKind
	}
	return ""
}

// Identifies the cluster-scoped resources to restore from the Backup.
type RestoreConfig_ClusterResourceRestoreScope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of "types" of cluster-scoped resources to be restored from the
	// Backup.  An empty list means that NO cluster-scoped resources will be
	// restored. Note that Namespaces and PersistentVolume restoration is
	// handled separately and is not governed by this field.
	SelectedGroupKinds []*RestoreConfig_GroupKind `protobuf:"bytes,1,rep,name=selected_group_kinds,json=selectedGroupKinds,proto3" json:"selected_group_kinds,omitempty"`
}

func (x *RestoreConfig_ClusterResourceRestoreScope) Reset() {
	*x = RestoreConfig_ClusterResourceRestoreScope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_ClusterResourceRestoreScope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_ClusterResourceRestoreScope) ProtoMessage() {}

func (x *RestoreConfig_ClusterResourceRestoreScope) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_ClusterResourceRestoreScope.ProtoReflect.Descriptor instead.
func (*RestoreConfig_ClusterResourceRestoreScope) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 1}
}

func (x *RestoreConfig_ClusterResourceRestoreScope) GetSelectedGroupKinds() []*RestoreConfig_GroupKind {
	if x != nil {
		return x.SelectedGroupKinds
	}
	return nil
}

// A transformation rule to be applied against Kubernetes resources as they
// are selected for restoration from a Backup. A rule contains both filtering
// logic (which resources are subject to substitution) and substitution logic.
type RestoreConfig_SubstitutionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Filtering parameter) Any resource subject to substitution must be
	// contained within one of the listed Kubernetes Namespace in the Backup.
	// If this field is not provided, no namespace filtering will be performed
	// (all resources in all Namespaces, including all cluster-scoped resources,
	// will be candidates for substitution).
	// To mix cluster-scoped and namespaced resources in the same rule, use an
	// empty string ("") as one of the target namespaces.
	TargetNamespaces []string `protobuf:"bytes,1,rep,name=target_namespaces,json=targetNamespaces,proto3" json:"target_namespaces,omitempty"`
	// (Filtering parameter) Any resource subject to substitution must belong to
	// one of the listed "types".
	// If this field is not provided, no type filtering will be performed (all
	// resources of all types matching previous filtering parameters will be
	// candidates for substitution).
	TargetGroupKinds []*RestoreConfig_GroupKind `protobuf:"bytes,2,rep,name=target_group_kinds,json=targetGroupKinds,proto3" json:"target_group_kinds,omitempty"`
	// Required. This is a [JSONPath]
	// (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
	// expression that matches specific fields of candidate
	// resources and it operates as both a filtering parameter (resources that
	// are not matched with this expression will not be candidates for
	// substitution) as well as a field identifier (identifies exactly which
	// fields out of the candidate resources will be modified).
	TargetJsonPath string `protobuf:"bytes,3,opt,name=target_json_path,json=targetJsonPath,proto3" json:"target_json_path,omitempty"`
	// (Filtering parameter) This is a [regular expression]
	// (https://en.wikipedia.org/wiki/Regular_expression)
	// that is compared against the fields matched by the target_json_path
	// expression (and must also have passed the previous filters).
	// Substitution will not be performed against fields whose
	// value does not match this expression. If this field is NOT specified,
	// then ALL fields matched by the target_json_path expression will undergo
	// substitution. Note that an empty (e.g., "", rather than unspecified)
	// value for for this field will only match empty fields.
	OriginalValuePattern string `protobuf:"bytes,4,opt,name=original_value_pattern,json=originalValuePattern,proto3" json:"original_value_pattern,omitempty"`
	// This is the new value to set for any fields that pass the filtering and
	// selection criteria. To remove a value from a Kubernetes resource, either
	// leave this field unspecified, or set it to the empty string ("").
	NewValue string `protobuf:"bytes,5,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
}

func (x *RestoreConfig_SubstitutionRule) Reset() {
	*x = RestoreConfig_SubstitutionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_SubstitutionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_SubstitutionRule) ProtoMessage() {}

func (x *RestoreConfig_SubstitutionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_SubstitutionRule.ProtoReflect.Descriptor instead.
func (*RestoreConfig_SubstitutionRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 2}
}

func (x *RestoreConfig_SubstitutionRule) GetTargetNamespaces() []string {
	if x != nil {
		return x.TargetNamespaces
	}
	return nil
}

func (x *RestoreConfig_SubstitutionRule) GetTargetGroupKinds() []*RestoreConfig_GroupKind {
	if x != nil {
		return x.TargetGroupKinds
	}
	return nil
}

func (x *RestoreConfig_SubstitutionRule) GetTargetJsonPath() string {
	if x != nil {
		return x.TargetJsonPath
	}
	return ""
}

func (x *RestoreConfig_SubstitutionRule) GetOriginalValuePattern() string {
	if x != nil {
		return x.OriginalValuePattern
	}
	return ""
}

func (x *RestoreConfig_SubstitutionRule) GetNewValue() string {
	if x != nil {
		return x.NewValue
	}
	return ""
}

var File_google_cloud_gkebackup_v1_restore_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_restore_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe7, 0x09, 0x0a, 0x07, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15,
	0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x06, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x05,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12,
	0x42, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x44,
	0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x39, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a,
	0x16, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x14, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x66, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e,
	0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x3a, 0x7d, 0xea, 0x41, 0x7a, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x56, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x7d,
	0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x7d, 0x22, 0xf1, 0x0e, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7d, 0x0a, 0x1a, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x17, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x8f, 0x01, 0x0a, 0x20, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69,
	0x63, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x1d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x8f, 0x01, 0x0a, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x1d, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x1e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x1b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d,
	0x61, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x58, 0x0a,
	0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x15, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x48, 0x00, 0x52, 0x14, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x68, 0x0a, 0x12, 0x73, 0x75,
	0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x11, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x1a, 0x57, 0x0a, 0x09, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e,
	0x64, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x1a, 0x83, 0x01,
	0x0a, 0x1b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x64, 0x0a,
	0x14, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x6b, 0x69, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x52,
	0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69,
	0x6e, 0x64, 0x73, 0x1a, 0xa3, 0x02, 0x0a, 0x10, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4a, 0x73,
	0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6e, 0x65, 0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xaf, 0x01, 0x0a, 0x17, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2a, 0x0a, 0x26, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x56, 0x4f, 0x4c,
	0x55, 0x4d, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x42, 0x41,
	0x43, 0x4b, 0x55, 0x50, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x55, 0x53, 0x45, 0x5f,
	0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x48, 0x41, 0x4e, 0x44, 0x4c, 0x45, 0x5f, 0x46, 0x52,
	0x4f, 0x4d, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x4e,
	0x4f, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x45,
	0x53, 0x54, 0x4f, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22, 0x83, 0x01, 0x0a, 0x1d,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x30, 0x0a,
	0x2c, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49, 0x43, 0x54, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x18, 0x0a, 0x14, 0x55, 0x53, 0x45, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x49, 0x4e, 0x47, 0x5f,
	0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x53, 0x45,
	0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10,
	0x02, 0x22, 0x7f, 0x0a, 0x1d, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x30, 0x0a, 0x2c, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x44,
	0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52,
	0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x41,
	0x4e, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10,
	0x46, 0x41, 0x49, 0x4c, 0x5f, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49, 0x43, 0x54,
	0x10, 0x02, 0x42, 0x23, 0x0a, 0x21, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x42, 0xca, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2f, 0x76, 0x31, 0x3b, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0xaa, 0x02, 0x19,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_v1_restore_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_restore_proto_rawDescData = file_google_cloud_gkebackup_v1_restore_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_restore_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_restore_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_restore_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_restore_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_gkebackup_v1_restore_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_gkebackup_v1_restore_proto_goTypes = []interface{}{
	(Restore_State)(0),                                // 0: google.cloud.gkebackup.v1.Restore.State
	(RestoreConfig_VolumeDataRestorePolicy)(0),        // 1: google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
	(RestoreConfig_ClusterResourceConflictPolicy)(0),  // 2: google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
	(RestoreConfig_NamespacedResourceRestoreMode)(0),  // 3: google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
	(*Restore)(nil),                                   // 4: google.cloud.gkebackup.v1.Restore
	(*RestoreConfig)(nil),                             // 5: google.cloud.gkebackup.v1.RestoreConfig
	nil,                                               // 6: google.cloud.gkebackup.v1.Restore.LabelsEntry
	(*RestoreConfig_GroupKind)(nil),                   // 7: google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	(*RestoreConfig_ClusterResourceRestoreScope)(nil), // 8: google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
	(*RestoreConfig_SubstitutionRule)(nil),            // 9: google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
	(*timestamppb.Timestamp)(nil),                     // 10: google.protobuf.Timestamp
	(*Namespaces)(nil),                                // 11: google.cloud.gkebackup.v1.Namespaces
	(*NamespacedNames)(nil),                           // 12: google.cloud.gkebackup.v1.NamespacedNames
}
var file_google_cloud_gkebackup_v1_restore_proto_depIdxs = []int32{
	10, // 0: google.cloud.gkebackup.v1.Restore.create_time:type_name -> google.protobuf.Timestamp
	10, // 1: google.cloud.gkebackup.v1.Restore.update_time:type_name -> google.protobuf.Timestamp
	5,  // 2: google.cloud.gkebackup.v1.Restore.restore_config:type_name -> google.cloud.gkebackup.v1.RestoreConfig
	6,  // 3: google.cloud.gkebackup.v1.Restore.labels:type_name -> google.cloud.gkebackup.v1.Restore.LabelsEntry
	0,  // 4: google.cloud.gkebackup.v1.Restore.state:type_name -> google.cloud.gkebackup.v1.Restore.State
	10, // 5: google.cloud.gkebackup.v1.Restore.complete_time:type_name -> google.protobuf.Timestamp
	1,  // 6: google.cloud.gkebackup.v1.RestoreConfig.volume_data_restore_policy:type_name -> google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
	2,  // 7: google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_conflict_policy:type_name -> google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
	3,  // 8: google.cloud.gkebackup.v1.RestoreConfig.namespaced_resource_restore_mode:type_name -> google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
	8,  // 9: google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope:type_name -> google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
	11, // 10: google.cloud.gkebackup.v1.RestoreConfig.selected_namespaces:type_name -> google.cloud.gkebackup.v1.Namespaces
	12, // 11: google.cloud.gkebackup.v1.RestoreConfig.selected_applications:type_name -> google.cloud.gkebackup.v1.NamespacedNames
	9,  // 12: google.cloud.gkebackup.v1.RestoreConfig.substitution_rules:type_name -> google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
	7,  // 13: google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.selected_group_kinds:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	7,  // 14: google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.target_group_kinds:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_restore_proto_init() }
func file_google_cloud_gkebackup_v1_restore_proto_init() {
	if File_google_cloud_gkebackup_v1_restore_proto != nil {
		return
	}
	file_google_cloud_gkebackup_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Restore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreConfig_GroupKind); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreConfig_ClusterResourceRestoreScope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreConfig_SubstitutionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*RestoreConfig_AllNamespaces)(nil),
		(*RestoreConfig_SelectedNamespaces)(nil),
		(*RestoreConfig_SelectedApplications)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_restore_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_restore_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_restore_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkebackup_v1_restore_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkebackup_v1_restore_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_restore_proto = out.File
	file_google_cloud_gkebackup_v1_restore_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_restore_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_restore_proto_depIdxs = nil
}
